/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.IsolateArguments;
import com.oracle.svm.core.Uninterruptible;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.type.CCharPointer;

public class IsolateArgumentAccess {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long readLong(IsolateArguments arguments, int index) {
        return arguments.getParsedArgs().read(index);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void writeLong(IsolateArguments arguments, int index, long value) {
        arguments.getParsedArgs().write(index, value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int readInt(IsolateArguments arguments, int index) {
        return (int)IsolateArgumentAccess.readLong(arguments, index);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void writeInt(IsolateArguments arguments, int index, int value) {
        IsolateArgumentAccess.writeLong(arguments, index, value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean readBoolean(IsolateArguments arguments, int index) {
        return IsolateArgumentAccess.readLong(arguments, index) == 1L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void writeBoolean(IsolateArguments arguments, int index, boolean value) {
        IsolateArgumentAccess.writeLong(arguments, index, value ? 1L : 0L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CCharPointer readCCharPointer(IsolateArguments arguments, int index) {
        return (CCharPointer)Word.pointer((long)IsolateArgumentAccess.readLong(arguments, index));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void writeCCharPointer(IsolateArguments arguments, int index, CCharPointer value) {
        IsolateArgumentAccess.writeLong(arguments, index, value.rawValue());
    }
}

