/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.heap.dump.HeapDumping;
import com.oracle.svm.core.jdk.management.ManagementAgentModule;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.util.LogUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

public final class VMInspectionOptions {
    private static final String ENABLE_MONITORING_OPTION = "enable-monitoring";
    private static final String MONITORING_DEFAULT_NAME = "<deprecated-default>";
    private static final String MONITORING_ALL_NAME = "all";
    private static final String MONITORING_HEAPDUMP_NAME = "heapdump";
    private static final String MONITORING_JFR_NAME = "jfr";
    private static final String MONITORING_JVMSTAT_NAME = "jvmstat";
    private static final String MONITORING_JMXCLIENT_NAME = "jmxclient";
    private static final String MONITORING_JMXSERVER_NAME = "jmxserver";
    private static final String MONITORING_THREADDUMP_NAME = "threaddump";
    private static final String MONITORING_NMT_NAME = "nmt";
    private static final String MONITORING_JCMD_NAME = "jcmd";
    private static final Set<String> MONITORING_ALL_VALUES = Set.of("heapdump", "jfr", "jvmstat", "jmxclient", "jmxserver", "threaddump", "nmt", "jcmd", "all", "<deprecated-default>");
    private static final List<String> NOT_SUPPORTED_ON_WINDOWS = List.of("heapdump", "jfr", "jvmstat", "jmxclient", "jmxserver", "jcmd");
    private static final String MONITORING_ALLOWED_VALUES_TEXT = "'heapdump', 'jfr', 'jvmstat', 'jmxserver' (experimental), 'jmxclient' (experimental), 'threaddump', 'nmt' (experimental), 'jcmd' (experimental), or 'all' (deprecated behavior: defaults to 'all' if no argument is provided)";
    @APIOption(name={"enable-monitoring"}, defaultValue={"<deprecated-default>"})
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> EnableMonitoringFeatures = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter(), VMInspectionOptions::validateEnableMonitoringFeatures);
    public static final HostedOptionKey<Boolean> DumpRuntimeCompilationOnSignal = new HostedOptionKey<Boolean>(false, VMInspectionOptions::notSupportedOnWindows);
    public static final RuntimeOptionKey<Boolean> PrintNMTStatistics;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void notSupportedOnWindows(HostedOptionKey<Boolean> optionKey) {
        if (Platform.includedIn(InternalPlatform.WINDOWS_BASE.class) && optionKey.getValue().booleanValue()) {
            String msg = String.format("the option '%s' is not supported on Windows and will be ignored.", optionKey.getName());
            LogUtils.warning((String)msg);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void validateEnableMonitoringFeatures(OptionKey<?> optionKey) {
        Set<String> enabledFeatures = VMInspectionOptions.getEnabledMonitoringFeatures();
        if (enabledFeatures.contains(MONITORING_DEFAULT_NAME)) {
            LogUtils.warning((String)"'%s' without an argument is deprecated. Please always explicitly specify the list of monitoring features to be enabled (for example, '%s').", (Object[])new Object[]{VMInspectionOptions.getDefaultMonitoringCommandArgument(), SubstrateOptionsParser.commandArgument(EnableMonitoringFeatures, String.join((CharSequence)",", List.of(MONITORING_HEAPDUMP_NAME, MONITORING_JFR_NAME)))});
        }
        enabledFeatures.removeAll(MONITORING_ALL_VALUES);
        if (!enabledFeatures.isEmpty()) {
            throw UserError.abort("The '%s' option contains invalid value(s): %s. It can only contain %s.", VMInspectionOptions.getDefaultMonitoringCommandArgument(), String.join((CharSequence)", ", enabledFeatures), MONITORING_ALLOWED_VALUES_TEXT);
        }
        if (Platform.includedIn(InternalPlatform.WINDOWS_BASE.class)) {
            Set<String> notSupported = VMInspectionOptions.getEnabledMonitoringFeatures();
            notSupported.retainAll(NOT_SUPPORTED_ON_WINDOWS);
            if (!PerfManager.Options.PerfDataMemoryMappedFile.getValue().booleanValue()) {
                notSupported.remove(MONITORING_JVMSTAT_NAME);
            }
            if (!notSupported.isEmpty()) {
                String msg = String.format("the option '%s' contains value(s) that are not supported on Windows: %s. Those values will be ignored.", VMInspectionOptions.getDefaultMonitoringCommandArgument(), String.join((CharSequence)", ", notSupported));
                LogUtils.warning((String)msg);
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static String getDefaultMonitoringCommandArgument() {
        return SubstrateOptionsParser.commandArgument(EnableMonitoringFeatures, MONITORING_DEFAULT_NAME);
    }

    @Fold
    public static String getHeapDumpNotSupportedMessage() {
        return "Unable to dump heap. Heap dumping is only supported on Linux and MacOS for native binaries built with '" + SubstrateOptionsParser.commandArgument(EnableMonitoringFeatures, MONITORING_HEAPDUMP_NAME) + "'.";
    }

    @Fold
    public static String getJfrNotSupportedMessage() {
        return "JFR is only supported on Linux and MacOS for native binaries built with '" + SubstrateOptionsParser.commandArgument(EnableMonitoringFeatures, MONITORING_JFR_NAME) + "'.";
    }

    private static Set<String> getEnabledMonitoringFeatures() {
        return new HashSet<String>(EnableMonitoringFeatures.getValue().values());
    }

    private static boolean hasAllOrKeywordMonitoringSupport(String keyword) {
        Set<String> enabledFeatures = VMInspectionOptions.getEnabledMonitoringFeatures();
        return enabledFeatures.contains(MONITORING_ALL_NAME) || enabledFeatures.contains(MONITORING_DEFAULT_NAME) || enabledFeatures.contains(keyword);
    }

    @Fold
    public static boolean hasHeapDumpSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_HEAPDUMP_NAME) && !Platform.includedIn(InternalPlatform.WINDOWS_BASE.class);
    }

    public static boolean dumpImageHeap() {
        if (VMInspectionOptions.hasHeapDumpSupport()) {
            String absoluteHeapDumpPath = HeapDumping.getHeapDumpPath(SubstrateOptions.Name.getValue() + ".hprof");
            try {
                HeapDumping.singleton().dumpHeap(absoluteHeapDumpPath, true);
            }
            catch (IOException e) {
                System.err.println("Failed to create heap dump:");
                e.printStackTrace();
                return false;
            }
            System.out.println("Heap dump created at '" + absoluteHeapDumpPath + "'.");
            return true;
        }
        System.out.println(VMInspectionOptions.getHeapDumpNotSupportedMessage());
        return false;
    }

    @Fold
    public static boolean hasJfrSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_JFR_NAME) && !Platform.includedIn(InternalPlatform.WINDOWS_BASE.class);
    }

    @Fold
    public static boolean hasJvmstatSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_JVMSTAT_NAME) && (!Platform.includedIn(InternalPlatform.WINDOWS_BASE.class) || PerfManager.Options.PerfDataMemoryMappedFile.getValue() == false);
    }

    @Fold
    public static boolean hasJmxServerSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_JMXSERVER_NAME) && !Platform.includedIn(InternalPlatform.WINDOWS_BASE.class) && ManagementAgentModule.isPresent();
    }

    @Fold
    public static boolean hasJmxClientSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_JMXCLIENT_NAME) && !Platform.includedIn(InternalPlatform.WINDOWS_BASE.class);
    }

    @Fold
    public static boolean hasThreadDumpSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_THREADDUMP_NAME) || DeprecatedOptions.DumpThreadStacksOnSignal.getValue() != false;
    }

    @Fold
    public static boolean hasNativeMemoryTrackingSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_NMT_NAME);
    }

    @Fold
    public static boolean hasJCmdSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_JCMD_NAME) && !Platform.includedIn(InternalPlatform.WINDOWS_BASE.class);
    }

    private VMInspectionOptions() {
    }

    static {
        assert (MONITORING_ALL_VALUES.stream().allMatch(v -> MONITORING_DEFAULT_NAME.equals(v) || MONITORING_ALLOWED_VALUES_TEXT.contains((CharSequence)v))) : "A value is missing in the user-facing help text";
        PrintNMTStatistics = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }

    static class DeprecatedOptions {
        static final HostedOptionKey<Boolean> AllowVMInspection = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                EnableMonitoringFeatures.update(values, newValue != false ? VMInspectionOptions.MONITORING_ALL_NAME : "");
                DumpRuntimeCompilationOnSignal.update(values, true);
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
            }
        };
        public static final HostedOptionKey<Boolean> DumpThreadStacksOnSignal = new HostedOptionKey<Boolean>(false);

        DeprecatedOptions() {
        }
    }
}

