/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.aarch64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.nodes.aarch64.AArch64XPACNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

@AutomaticallyRegisteredImageSingleton(value={FrameAccess.class})
@Platforms(value={Platform.AARCH64.class})
public class AArch64FrameAccess
extends FrameAccess {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected int getReturnAddressSize() {
        return AArch64FrameAccess.wordSize();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CodePointer unsafeReadReturnAddress(Pointer sourceSp) {
        CodePointer returnAddress = super.unsafeReadReturnAddress(sourceSp);
        return AArch64FrameAccess.stripAddress(returnAddress);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CodePointer stripAddress(CodePointer returnAddress) {
        if (SubstrateControlFlowIntegrity.enabled()) {
            return AArch64XPACNode.stripAddress(returnAddress);
        }
        return returnAddress;
    }
}

