/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoImpl;
import com.oracle.svm.core.code.CodeInfoTether;
import com.oracle.svm.core.code.ImageCodeInfoStorage;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.util.VMError;
import java.util.EnumSet;
import java.util.List;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.UnsignedWord;

public class ImageCodeInfo
implements MultiLayeredImageSingleton,
UnsavedSingleton {
    public static final String CODE_INFO_NAME = "image code";
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final HostedImageCodeInfo hostedImageCodeInfo = new HostedImageCodeInfo();
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private CodePointer codeStart;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private UnsignedWord entryPointOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private UnsignedWord codeSize;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private UnsignedWord dataOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private UnsignedWord dataSize;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private UnsignedWord codeAndDataMemorySize;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private int methodTableFirstId;
    private final Object[] objectFields;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    byte[] codeInfoIndex;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    byte[] codeInfoEncodings;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    byte[] referenceMapEncoding;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    byte[] frameInfoEncodings;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    Object[] objectConstants;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    Class<?>[] classes;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    String[] memberNames;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    String[] otherStrings;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    byte[] methodTable;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ImageCodeInfo() {
        NonmovableObjectArray objfields = NonmovableArrays.createObjectArray(Object[].class, 3, NmtCategory.Code);
        NonmovableArrays.setObject(objfields, 1, CODE_INFO_NAME);
        NonmovableArrays.setObject(objfields, 0, new CodeInfoTether(true));
        this.objectFields = (Object[])NonmovableArrays.getHostedArray(objfields);
    }

    @Uninterruptible(reason="Executes during isolate creation.")
    static CodeInfo prepareCodeInfo() {
        ImageCodeInfo[] imageCodeInfos = (ImageCodeInfo[])MultiLayeredImageSingleton.getAllLayers(ImageCodeInfo.class);
        ImageCodeInfoStorage[] runtimeCodeInfos = (ImageCodeInfoStorage[])MultiLayeredImageSingleton.getAllLayers(ImageCodeInfoStorage.class);
        int size = imageCodeInfos.length;
        for (int i = 0; i < size; ++i) {
            ImageCodeInfo imageCodeInfo = imageCodeInfos[i];
            CodeInfoImpl codeInfoImpl = runtimeCodeInfos[i].getData();
            CodeInfoImpl nextCodeInfoImpl = i + 1 < size ? runtimeCodeInfos[i + 1].getData() : (CodeInfoImpl)Word.nullPointer();
            ImageCodeInfo.prepareCodeInfo0(imageCodeInfo, codeInfoImpl, nextCodeInfoImpl);
        }
        return runtimeCodeInfos[0].getData();
    }

    @Uninterruptible(reason="Executes during isolate creation.")
    private static void prepareCodeInfo0(ImageCodeInfo imageCodeInfo, CodeInfoImpl infoImpl, CodeInfo next) {
        assert (infoImpl.getCodeStart().isNull()) : "already initialized";
        infoImpl.setObjectFields(NonmovableArrays.fromImageHeap(imageCodeInfo.objectFields));
        infoImpl.setCodeStart(imageCodeInfo.codeStart);
        infoImpl.setCodeSize(imageCodeInfo.codeSize);
        infoImpl.setDataOffset(imageCodeInfo.dataOffset);
        infoImpl.setDataSize(imageCodeInfo.dataSize);
        infoImpl.setCodeAndDataMemorySize(imageCodeInfo.codeAndDataMemorySize);
        infoImpl.setCodeInfoIndex(NonmovableArrays.fromImageHeap((Object)imageCodeInfo.codeInfoIndex));
        infoImpl.setCodeInfoEncodings(NonmovableArrays.fromImageHeap((Object)imageCodeInfo.codeInfoEncodings));
        infoImpl.setStackReferenceMapEncoding(NonmovableArrays.fromImageHeap((Object)imageCodeInfo.referenceMapEncoding));
        infoImpl.setFrameInfoEncodings(NonmovableArrays.fromImageHeap((Object)imageCodeInfo.frameInfoEncodings));
        infoImpl.setObjectConstants(NonmovableArrays.fromImageHeap(imageCodeInfo.objectConstants));
        infoImpl.setClasses(NonmovableArrays.fromImageHeap(imageCodeInfo.classes));
        infoImpl.setMemberNames(NonmovableArrays.fromImageHeap(imageCodeInfo.memberNames));
        infoImpl.setOtherStrings(NonmovableArrays.fromImageHeap(imageCodeInfo.otherStrings));
        infoImpl.setMethodTable(NonmovableArrays.fromImageHeap((Object)imageCodeInfo.methodTable));
        infoImpl.setMethodTableFirstId(imageCodeInfo.methodTableFirstId);
        infoImpl.setIsAOTImageCode(true);
        infoImpl.setNextImageCodeInfo(next);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CodePointer getCodeStart() {
        return this.codeStart;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HostedImageCodeInfo getHostedImageCodeInfo() {
        return this.hostedImageCodeInfo;
    }

    public List<Integer> getTotalByteArrayLengths() {
        return List.of(Integer.valueOf(this.codeInfoIndex.length), Integer.valueOf(this.codeInfoEncodings.length), Integer.valueOf(this.referenceMapEncoding.length), Integer.valueOf(this.frameInfoEncodings.length), Integer.valueOf(this.methodTable.length));
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public class HostedImageCodeInfo
    implements CodeInfoImpl {
        @Override
        public CodePointer getCodeStart() {
            return ImageCodeInfo.this.codeStart;
        }

        @Override
        public UnsignedWord getCodeSize() {
            return ImageCodeInfo.this.codeSize;
        }

        @Override
        public UnsignedWord getDataOffset() {
            return ImageCodeInfo.this.dataOffset;
        }

        @Override
        public UnsignedWord getDataSize() {
            return ImageCodeInfo.this.dataSize;
        }

        @Override
        public UnsignedWord getCodeAndDataMemorySize() {
            return ImageCodeInfo.this.codeAndDataMemorySize;
        }

        @Override
        public NonmovableArray<Byte> getStackReferenceMapEncoding() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.referenceMapEncoding);
        }

        @Override
        public void setCodeStart(CodePointer value) {
            ImageCodeInfo.this.codeStart = value;
        }

        @Override
        public UnsignedWord getCodeEntryPointOffset() {
            return ImageCodeInfo.this.entryPointOffset;
        }

        @Override
        public void setCodeSize(UnsignedWord value) {
            ImageCodeInfo.this.codeSize = value;
        }

        @Override
        public void setCodeEntryPointOffset(UnsignedWord offset) {
            ImageCodeInfo.this.entryPointOffset = offset;
        }

        @Override
        public void setDataOffset(UnsignedWord value) {
            ImageCodeInfo.this.dataOffset = value;
        }

        @Override
        public void setDataSize(UnsignedWord value) {
            ImageCodeInfo.this.dataSize = value;
        }

        @Override
        public void setCodeAndDataMemorySize(UnsignedWord value) {
            ImageCodeInfo.this.codeAndDataMemorySize = value;
        }

        @Override
        public NonmovableArray<Byte> getCodeInfoIndex() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.codeInfoIndex);
        }

        @Override
        public void setCodeInfoIndex(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.codeInfoIndex = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableArray<Byte> getCodeInfoEncodings() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.codeInfoEncodings);
        }

        @Override
        public void setCodeInfoEncodings(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.codeInfoEncodings = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public void setStackReferenceMapEncoding(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.referenceMapEncoding = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableArray<Byte> getFrameInfoEncodings() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.frameInfoEncodings);
        }

        @Override
        public void setFrameInfoEncodings(NonmovableArray<Byte> array) {
            ImageCodeInfo.this.frameInfoEncodings = (byte[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<Object> getObjectConstants() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.objectConstants);
        }

        @Override
        public void setObjectConstants(NonmovableObjectArray<Object> array) {
            ImageCodeInfo.this.objectConstants = (Object[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<Class<?>> getClasses() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.classes);
        }

        @Override
        public void setClasses(NonmovableObjectArray<Class<?>> array) {
            ImageCodeInfo.this.classes = (Class[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<String> getMemberNames() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.memberNames);
        }

        @Override
        public void setMemberNames(NonmovableObjectArray<String> array) {
            ImageCodeInfo.this.memberNames = (String[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableObjectArray<String> getOtherStrings() {
            return NonmovableArrays.fromImageHeap(ImageCodeInfo.this.otherStrings);
        }

        @Override
        public void setOtherStrings(NonmovableObjectArray<String> array) {
            ImageCodeInfo.this.otherStrings = (String[])NonmovableArrays.getHostedArray(array);
        }

        @Override
        public NonmovableArray<Byte> getMethodTable() {
            return NonmovableArrays.fromImageHeap((Object)ImageCodeInfo.this.methodTable);
        }

        @Override
        public void setMethodTable(NonmovableArray<Byte> methods) {
            ImageCodeInfo.this.methodTable = (byte[])NonmovableArrays.getHostedArray(methods);
        }

        @Override
        public int getMethodTableFirstId() {
            return ImageCodeInfo.this.methodTableFirstId;
        }

        @Override
        public void setMethodTableFirstId(int methodId) {
            ImageCodeInfo.this.methodTableFirstId = methodId;
        }

        @Override
        public void setObjectFields(NonmovableObjectArray<Object> fields) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableObjectArray<Object> getObjectFields() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public int getTier() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setTier(int tier) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public int getState() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setState(int state) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<Byte> getCodeConstantsReferenceMapEncoding() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setCodeConstantsReferenceMapEncoding(NonmovableArray<Byte> objectsReferenceMapEncoding) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public long getCodeConstantsReferenceMapIndex() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setCodeConstantsReferenceMapIndex(long objectsReferenceMapIndex) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<Integer> getDeoptimizationStartOffsets() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setDeoptimizationStartOffsets(NonmovableArray<Integer> deoptimizationStartOffsets) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<Byte> getDeoptimizationEncodings() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setDeoptimizationEncodings(NonmovableArray<Byte> deoptimizationEncodings) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableObjectArray<Object> getDeoptimizationObjectConstants() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setDeoptimizationObjectConstants(NonmovableObjectArray<Object> deoptimizationObjectConstants) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> getCodeObserverHandles() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setCodeObserverHandles(NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> handles) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public Word getGCData() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setAllObjectsAreInImageHeap(boolean value) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public boolean getAllObjectsAreInImageHeap() {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public void setIsAOTImageCode(boolean value) {
            throw VMError.shouldNotReachHere("not supported for image code");
        }

        @Override
        public boolean getIsAOTImageCode() {
            return true;
        }

        @Override
        public void setNextImageCodeInfo(CodeInfo next) {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }

        @Override
        public CodeInfo getNextImageCodeInfo() {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }

        public boolean isNull() {
            return false;
        }

        public boolean isNonNull() {
            return !this.isNull();
        }

        public boolean equal(ComparableWord val) {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }

        public boolean notEqual(ComparableWord val) {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }

        public long rawValue() {
            throw VMError.shouldNotReachHere("not supported during image generation");
        }
    }
}

