/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.deopt.DeoptimizationCanaryFeature;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public class DeoptimizationSupport {
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private CFunctionPointer eagerDeoptStubPointer;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private CFunctionPointer lazyDeoptStubPrimitiveReturnPointer;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private CFunctionPointer lazyDeoptStubObjectReturnPointer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DeoptimizationSupport() {
    }

    @Fold
    public static boolean enabled() {
        return ImageSingletons.contains(DeoptimizationCanaryFeature.class);
    }

    @Fold
    static DeoptimizationSupport get() {
        return (DeoptimizationSupport)ImageSingletons.lookup(DeoptimizationSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setEagerDeoptStubPointer(CFunctionPointer ptr) {
        assert (DeoptimizationSupport.get().eagerDeoptStubPointer == null) : "multiple eagerDeoptStub methods registered";
        DeoptimizationSupport.get().eagerDeoptStubPointer = ptr;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setLazyDeoptStubPrimitiveReturnPointer(CFunctionPointer ptr) {
        assert (DeoptimizationSupport.get().lazyDeoptStubPrimitiveReturnPointer == null) : "multiple lazyDeoptStubPrimitiveReturn methods registered";
        assert (Deoptimizer.Options.LazyDeoptimization.getValue().booleanValue()) : "lazy deoptimization not enabled";
        DeoptimizationSupport.get().lazyDeoptStubPrimitiveReturnPointer = ptr;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setLazyDeoptStubObjectReturnPointer(CFunctionPointer ptr) {
        assert (DeoptimizationSupport.get().lazyDeoptStubObjectReturnPointer == null) : "multiple lazyDeoptStubObjectReturn methods registered";
        assert (Deoptimizer.Options.LazyDeoptimization.getValue().booleanValue()) : "lazy deoptimization not enabled";
        DeoptimizationSupport.get().lazyDeoptStubObjectReturnPointer = ptr;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CFunctionPointer getEagerDeoptStubPointer() {
        CFunctionPointer ptr = DeoptimizationSupport.get().eagerDeoptStubPointer;
        assert (ptr.rawValue() != 0L);
        return ptr;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CFunctionPointer getLazyDeoptStubPrimitiveReturnPointer() {
        assert (Deoptimizer.Options.LazyDeoptimization.getValue().booleanValue()) : "lazy deoptimization not enabled";
        CFunctionPointer ptr = DeoptimizationSupport.get().lazyDeoptStubPrimitiveReturnPointer;
        assert (ptr.rawValue() != 0L);
        return ptr;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CFunctionPointer getLazyDeoptStubObjectReturnPointer() {
        assert (Deoptimizer.Options.LazyDeoptimization.getValue().booleanValue()) : "lazy deoptimization not enabled";
        CFunctionPointer ptr = DeoptimizationSupport.get().lazyDeoptStubObjectReturnPointer;
        assert (ptr.rawValue() != 0L);
        return ptr;
    }
}

