/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.collections.RingBuffer;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptState;
import com.oracle.svm.core.deopt.DeoptimizationCounters;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.graal.code.StubCallingConvention;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.SuspendSerialGCMaxHeapSize;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.log.StringBuilderLog;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.snippets.ExceptionUnwind;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaFrame;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteOrder;
import java.util.ArrayList;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.util.TypeConversion;
import jdk.graal.compiler.nodes.UnreachableNode;
import jdk.graal.compiler.word.BarrieredAccess;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class Deoptimizer {
    private static final int MAX_DEOPTIMIZATION_EVENT_PRINT_LENGTH = 1000;
    private static final RingBuffer<char[]> recentDeoptimizationEvents = new RingBuffer(SubstrateOptions.DiagnosticBufferSize.getValue());
    private static final int actionShift = 0;
    private static final int actionBits = 32 - Integer.numberOfLeadingZeros(DeoptimizationAction.values().length);
    private static final int reasonShift = 0 + actionBits;
    private static final int reasonBits = 32 - Integer.numberOfLeadingZeros(DeoptimizationReason.values().length);
    private static final int idShift = reasonShift + reasonBits;
    private static final int idBits = 32;
    public static boolean testGCinDeoptimizer;
    public static boolean testEagerDeoptInLazyDeoptFatalError;
    public static boolean testLazyDeoptInLazyDeopt;
    int endOfParams;
    private final CodeInfoQueryResult sourceChunk;
    private ArrayList<DeoptimizedFrame.RelockObjectData> relockedObjects;
    protected int targetContentSize;
    private final DeoptState deoptState;
    private final IsolateThread requestingThread;
    private static final RingBuffer.Consumer<char[]> deoptEventsConsumer;

    public static long encodeDeoptActionAndReasonToLong(DeoptimizationAction action, DeoptimizationReason reason, int speculationId) {
        return (long)action.ordinal() << 0 | (long)reason.ordinal() << reasonShift | (long)speculationId << idShift;
    }

    public static JavaConstant encodeDeoptActionAndReason(DeoptimizationAction action, DeoptimizationReason reason, int speculationId) {
        PrimitiveConstant result = JavaConstant.forLong((long)Deoptimizer.encodeDeoptActionAndReasonToLong(action, reason, speculationId));
        assert (Deoptimizer.decodeDeoptAction((JavaConstant)result) == action) : result;
        assert (Deoptimizer.decodeDeoptReason((JavaConstant)result) == reason) : result;
        assert (Deoptimizer.decodeDebugId((JavaConstant)result) == speculationId) : result;
        return result;
    }

    public static DeoptimizationAction decodeDeoptAction(long actionAndReason) {
        return DeoptimizationAction.values()[(int)(actionAndReason >> 0 & (1L << actionBits) - 1L)];
    }

    public static DeoptimizationReason decodeDeoptReason(long actionAndReason) {
        return DeoptimizationReason.values()[(int)(actionAndReason >> reasonShift & (1L << reasonBits) - 1L)];
    }

    public static int decodeDebugId(long actionAndReason) {
        return (int)(actionAndReason >> idShift & 0xFFFFFFFFL);
    }

    public static DeoptimizationAction decodeDeoptAction(JavaConstant actionAndReason) {
        return Deoptimizer.decodeDeoptAction(actionAndReason.asLong());
    }

    public static DeoptimizationReason decodeDeoptReason(JavaConstant actionAndReason) {
        return Deoptimizer.decodeDeoptReason(actionAndReason.asLong());
    }

    public static int decodeDebugId(JavaConstant actionAndReason) {
        return Deoptimizer.decodeDebugId(actionAndReason.asLong());
    }

    private static boolean checkEncoding() {
        for (DeoptimizationAction action : DeoptimizationAction.values()) {
            for (DeoptimizationReason reason : DeoptimizationReason.values()) {
                for (int speculationId : new int[]{0, 1, -1, Integer.MIN_VALUE, Integer.MAX_VALUE}) {
                    Deoptimizer.encodeDeoptActionAndReason(action, reason, speculationId);
                }
            }
        }
        return true;
    }

    public static void maybeTestGC() {
        if (testGCinDeoptimizer) {
            Heap.getHeap().getGC().collect(GCCause.TestGCInDeoptimizer);
        }
    }

    private static void maybeTestDeoptDuringLazyDeopt(Deoptimizer deoptimizer, CodePointer pc) {
        VMError.guarantee(!testEagerDeoptInLazyDeoptFatalError || !testLazyDeoptInLazyDeopt, "Cannot test both eager deopt and lazy deopt");
        if (testEagerDeoptInLazyDeoptFatalError) {
            deoptimizer.deoptSourceFrameEagerly(pc, false);
        } else if (testLazyDeoptInLazyDeopt) {
            Deoptimizer.deoptimizeFrame(deoptimizer.deoptState.sourceSp, false, null);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean checkIsDeoptimized(JavaFrame frame) {
        return Deoptimizer.checkLazyDeoptimized(frame) || Deoptimizer.checkEagerDeoptimized(frame) != null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static DeoptimizedFrame checkEagerDeoptimized(JavaFrame frame) {
        if (DeoptimizationSupport.enabled()) {
            return Deoptimizer.checkEagerDeoptimized0(frame.getSP(), frame.getIP());
        }
        return null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static DeoptimizedFrame checkEagerDeoptimized(IsolateThread thread, Pointer sp) {
        if (DeoptimizationSupport.enabled()) {
            CodePointer ip = FrameAccess.singleton().readReturnAddress(thread, sp);
            return Deoptimizer.checkEagerDeoptimized0(sp, ip);
        }
        return null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static DeoptimizedFrame checkEagerDeoptimized0(Pointer sp, CodePointer ip) {
        if (ip.equal((ComparableWord)DeoptimizationSupport.getEagerDeoptStubPointer())) {
            DeoptimizedFrame result = (DeoptimizedFrame)ReferenceAccess.singleton().readObjectAt(sp, true);
            if (result == null) {
                throw Deoptimizer.checkDeoptimizedError(sp);
            }
            return result;
        }
        return null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean checkLazyDeoptimized(JavaFrame frame) {
        if (DeoptimizationSupport.enabled() && Options.LazyDeoptimization.getValue().booleanValue()) {
            return frame.getIsPendingLazyDeopt();
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean checkLazyDeoptimized(IsolateThread thread, Pointer sp) {
        if (DeoptimizationSupport.enabled() && Options.LazyDeoptimization.getValue().booleanValue()) {
            CodePointer ip = FrameAccess.singleton().readReturnAddress(thread, sp);
            return Deoptimizer.isLazyDeoptStub(ip);
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean checkLazyDeoptimized(CodePointer ip) {
        if (DeoptimizationSupport.enabled() && Options.LazyDeoptimization.getValue().booleanValue()) {
            return Deoptimizer.isLazyDeoptStub(ip);
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isLazyDeoptStub(CodePointer ip) {
        assert (Options.LazyDeoptimization.getValue().booleanValue());
        return ip.equal((ComparableWord)DeoptimizationSupport.getLazyDeoptStubPrimitiveReturnPointer()) || ip.equal((ComparableWord)DeoptimizationSupport.getLazyDeoptStubObjectReturnPointer());
    }

    @Uninterruptible(reason="Switch to interruptible code and report a fatal error.", calleeMustBe=false)
    private static RuntimeException checkDeoptimizedError(Pointer sp) {
        throw Deoptimizer.checkDeoptimizedError0(sp);
    }

    @NeverInline(value="Throws error and exits")
    private static RuntimeException checkDeoptimizedError0(Pointer sp) {
        Log.log().string("Unable to retrieve Deoptimized frame. sp: ").hex(sp.rawValue()).newline();
        throw VMError.shouldNotReachHere("Unable to retrieve Deoptimized frame");
    }

    @Uninterruptible(reason="Prevent stack walks from seeing an inconsistent stack.")
    private void installDeoptimizedFrame(DeoptimizedFrame deoptimizedFrame) {
        FrameAccess.singleton().writeReturnAddress(this.deoptState.targetThread, this.deoptState.sourceSp, (CodePointer)DeoptimizationSupport.getEagerDeoptStubPointer());
        ReferenceAccess.singleton().writeObjectAt(this.deoptState.sourceSp, deoptimizedFrame, true);
    }

    @NeverInline(value="deoptimize must have a separate stack frame")
    public static void deoptimizeAll() {
        VMOperation.guaranteeNotInProgress("With a VM Operation in progress, we cannot determine the thread requesting deoptimization.");
        DeoptimizeAllOperation vmOp = new DeoptimizeAllOperation(CurrentIsolate.getCurrentThread());
        vmOp.enqueue();
    }

    @NeverInline(value="deoptimize must have a separate stack frame")
    public static void deoptimizeInRange(CodePointer fromIp, CodePointer toIp, boolean deoptAll, IsolateThread requestingThread) {
        VMOperation.guaranteeInProgressAtSafepoint("Deoptimization requires a safepoint.");
        Deoptimizer.deoptimizeInRangeOperation(fromIp, toIp, deoptAll, requestingThread);
    }

    @NeverInline(value="Starting a stack walk in the caller frame. Note that we could start the stack frame also further down the stack, because VM operation frames never need deoptimization. But we don't store stack frame information for the first frame we would need to process.")
    private static void deoptimizeInRangeOperation(CodePointer fromIp, CodePointer toIp, boolean deoptAll, IsolateThread requestingThread) {
        VMOperation.guaranteeInProgressAtSafepoint("Deoptimizer.deoptimizeInRangeOperation, but not in VMOperation.");
        Pointer sp = KnownIntrinsics.readCallerStackPointer();
        StackFrameVisitor currentThreadDeoptVisitor = Deoptimizer.getStackFrameVisitor((Pointer)fromIp, (Pointer)toIp, deoptAll, CurrentIsolate.getCurrentThread(), requestingThread);
        JavaStackWalker.walkCurrentThread(sp, currentThreadDeoptVisitor);
        IsolateThread vmThread = VMThreads.firstThread();
        while (vmThread.isNonNull()) {
            if (vmThread != CurrentIsolate.getCurrentThread()) {
                StackFrameVisitor deoptVisitor = Deoptimizer.getStackFrameVisitor((Pointer)fromIp, (Pointer)toIp, deoptAll, vmThread, requestingThread);
                JavaStackWalker.walkThread(vmThread, deoptVisitor);
            }
            vmThread = VMThreads.nextThread(vmThread);
        }
        Deoptimizer.maybeTestGC();
    }

    private static StackFrameVisitor getStackFrameVisitor(final Pointer fromIp, final Pointer toIp, final boolean deoptAll, final IsolateThread targetThread, final IsolateThread requestingThread) {
        return new StackFrameVisitor(){

            @Override
            public boolean visitRegularFrame(Pointer frameSp, CodePointer frameIp, CodeInfo codeInfo) {
                Pointer ip = (Pointer)frameIp;
                if (ip.aboveOrEqual((UnsignedWord)fromIp) && ip.belowThan((UnsignedWord)toIp) || deoptAll) {
                    CodeInfoQueryResult queryResult = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, frameIp);
                    Deoptimizer deoptimizer = new Deoptimizer(frameSp, queryResult, targetThread, requestingThread);
                    deoptimizer.deoptSourceFrameLazily(frameIp, deoptAll);
                }
                return true;
            }

            @Override
            protected boolean visitDeoptimizedFrame(Pointer originalSP, CodePointer deoptStubIP, DeoptimizedFrame deoptimizedFrame) {
                return true;
            }
        };
    }

    @NeverInline(value="Inlining of this method would require that we have deopt targets for callees of this method (SVM internals).")
    public static void deoptimizeFrame(Pointer sp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation) {
        boolean deoptEagerly = Options.LazyDeoptimization.getValue() == false;
        Deoptimizer.deoptimizeFrame0(sp, ignoreNonDeoptimizable, speculation, deoptEagerly);
    }

    @NeverInline(value="Inlining of this method would require that we have deopt targets for callees of this method (SVM internals).")
    public static void deoptimizeFrameEagerly(Pointer sp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation) {
        Deoptimizer.deoptimizeFrame0(sp, ignoreNonDeoptimizable, speculation, true);
    }

    private static void deoptimizeFrame0(Pointer sp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, boolean deoptEagerly) {
        IsolateThread targetThread = CurrentIsolate.getCurrentThread();
        if (Deoptimizer.checkDeoptimizedThenRegisterSpeculationFailure(deoptEagerly, targetThread, sp, speculation)) {
            return;
        }
        VMOperation.guaranteeNotInProgress("With a VM Operation in progress, we cannot determine the thread requesting deoptimization.");
        DeoptimizeFrameOperation vmOp = new DeoptimizeFrameOperation(sp, ignoreNonDeoptimizable, speculation, targetThread, deoptEagerly, CurrentIsolate.getCurrentThread());
        vmOp.enqueue();
    }

    private static boolean checkDeoptimizedThenRegisterSpeculationFailure(boolean deoptEagerly, IsolateThread targetThread, Pointer sp, SpeculationLog.SpeculationReason speculation) {
        DeoptimizedFrame deoptFrame = Deoptimizer.checkEagerDeoptimized(targetThread, sp);
        if (deoptFrame != null) {
            Deoptimizer.registerSpeculationFailure(deoptFrame.getSourceInstalledCode(), speculation);
            return true;
        }
        if (!deoptEagerly && Deoptimizer.checkLazyDeoptimized(targetThread, sp)) {
            CodePointer originalReturnAddress = Deoptimizer.readLazyDeoptOriginalReturnAddress(targetThread, sp);
            SubstrateInstalledCode installedCode = CodeInfoTable.lookupInstalledCode(originalReturnAddress);
            Deoptimizer.registerSpeculationFailure(installedCode, speculation);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo object.")
    private static void deoptimizeFrame(IsolateThread targetThread, Pointer sp, CodePointer ip, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, boolean deoptEagerly, IsolateThread requestingThread) {
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
            Deoptimizer.deoptimize(targetThread, sp, ip, ignoreNonDeoptimizable, speculation, info, deoptEagerly, requestingThread);
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    @Uninterruptible(reason="Pass the now protected CodeInfo object to interruptible code.", calleeMustBe=false)
    private static void deoptimize(IsolateThread targetThread, Pointer sp, CodePointer ip, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, CodeInfo info, boolean deoptEagerly, IsolateThread requestingThread) {
        Deoptimizer.deoptimize0(targetThread, sp, ip, ignoreNonDeoptimizable, speculation, info, deoptEagerly, requestingThread);
    }

    private static void deoptimize0(IsolateThread targetThread, Pointer sp, CodePointer ip, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, CodeInfo info, boolean deoptEagerly, IsolateThread requestingThread) {
        CodeInfoQueryResult queryResult = CodeInfoTable.lookupCodeInfoQueryResult(info, ip);
        Deoptimizer deoptimizer = new Deoptimizer(sp, queryResult, targetThread, requestingThread);
        if (deoptEagerly) {
            DeoptimizedFrame sourceFrame = deoptimizer.deoptSourceFrameEagerly(ip, ignoreNonDeoptimizable);
            if (sourceFrame != null) {
                Deoptimizer.registerSpeculationFailure(sourceFrame.getSourceInstalledCode(), speculation);
            }
        } else {
            deoptimizer.deoptSourceFrameLazily(ip, ignoreNonDeoptimizable);
            SubstrateInstalledCode installedCode = CodeInfoTable.lookupInstalledCode(ip);
            Deoptimizer.registerSpeculationFailure(installedCode, speculation);
        }
    }

    public static void invalidateMethodOfFrame(IsolateThread thread, Pointer sp, SpeculationLog.SpeculationReason speculation) {
        VMError.guarantee(thread == CurrentIsolate.getCurrentThread());
        CodePointer ip = FrameAccess.singleton().readReturnAddress(thread, sp);
        if (Deoptimizer.checkLazyDeoptimized(ip)) {
            ip = Deoptimizer.readLazyDeoptOriginalReturnAddress(thread, sp);
        }
        SubstrateInstalledCode installedCode = CodeInfoTable.lookupInstalledCode(ip);
        DeoptimizedFrame deoptimizedFrame = Deoptimizer.checkEagerDeoptimized(thread, sp);
        if (deoptimizedFrame != null) {
            installedCode = deoptimizedFrame.getSourceInstalledCode();
            if (installedCode == null) {
                return;
            }
        } else if (installedCode == null) {
            throw VMError.shouldNotReachHere("Only runtime compiled methods can be invalidated. sp = " + Long.toHexString(sp.rawValue()) + ", returnAddress = " + Long.toHexString(ip.rawValue()));
        }
        Deoptimizer.registerSpeculationFailure(installedCode, speculation);
        VMOperation.guaranteeNotInProgress("invalidateMethodOfFrame: running user code that can block");
        installedCode.invalidate();
    }

    private static void registerSpeculationFailure(SubstrateInstalledCode installedCode, SpeculationLog.SpeculationReason speculation) {
        SubstrateSpeculationLog speculationLog;
        if (installedCode != null && speculation != null && (speculationLog = installedCode.getSpeculationLog()) != null) {
            speculationLog.addFailedSpeculation(speculation);
        }
    }

    public Deoptimizer(Pointer sourceSp, CodeInfoQueryResult sourceChunk, IsolateThread targetThread, IsolateThread requestingThread) {
        VMError.guarantee(sourceChunk != null, "Must not be null.");
        this.sourceChunk = sourceChunk;
        this.deoptState = new DeoptState(sourceSp, targetThread);
        this.requestingThread = requestingThread;
    }

    public DeoptState getDeoptState() {
        return this.deoptState;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isNonNullValue(UnsignedWord pointer) {
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            return pointer != Word.nullPointer() && pointer != KnownIntrinsics.heapBase();
        }
        return pointer != Word.nullPointer();
    }

    @StubCallingConvention
    @DeoptStub(stubType=StubType.EntryStub)
    @Uninterruptible(reason="Rewriting stack; gpReturnValue holds object reference.")
    public static UnsignedWord lazyDeoptStubObjectReturn(Pointer originalStackPointer, UnsignedWord gpReturnValue, UnsignedWord fpReturnValue) {
        CFunctionPointer returnAddress = DeoptimizationSupport.getLazyDeoptStubObjectReturnPointer();
        FrameAccess.singleton().writeReturnAddress(CurrentIsolate.getCurrentThread(), originalStackPointer, (CodePointer)returnAddress);
        try {
            assert (PointerUtils.isAMultiple((PointerBase)KnownIntrinsics.readStackPointer(), Word.unsigned((int)ConfigurationValues.getTarget().stackAlignment)));
            assert (Options.LazyDeoptimization.getValue().booleanValue());
            assert (VMThreads.StatusSupport.isStatusJava()) : "Deopt stub execution must not be visible to other threads.";
            boolean hasException = ExceptionUnwind.getLazyDeoptStubShouldReturnToExceptionHandler();
            if (hasException) {
                ExceptionUnwind.setLazyDeoptStubShouldReturnToExceptionHandler(false);
            }
            Object gpReturnValueObject = null;
            if (Deoptimizer.isNonNullValue(gpReturnValue)) {
                gpReturnValueObject = ((Pointer)gpReturnValue).toObject();
            }
            Deoptimizer.lazyDeoptStubCore(originalStackPointer, gpReturnValue, fpReturnValue, hasException, gpReturnValueObject);
            throw UnreachableNode.unreachable();
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHere("Exception in lazy deopt stub", t);
        }
    }

    @StubCallingConvention
    @DeoptStub(stubType=StubType.EntryStub)
    @Uninterruptible(reason="Rewriting stack.")
    public static UnsignedWord lazyDeoptStubPrimitiveReturn(Pointer originalStackPointer, UnsignedWord gpReturnValue, UnsignedWord fpReturnValue) {
        CFunctionPointer returnAddress = DeoptimizationSupport.getLazyDeoptStubPrimitiveReturnPointer();
        FrameAccess.singleton().writeReturnAddress(CurrentIsolate.getCurrentThread(), originalStackPointer, (CodePointer)returnAddress);
        try {
            assert (PointerUtils.isAMultiple((PointerBase)KnownIntrinsics.readStackPointer(), Word.unsigned((int)ConfigurationValues.getTarget().stackAlignment)));
            assert (Options.LazyDeoptimization.getValue().booleanValue());
            assert (VMThreads.StatusSupport.isStatusJava()) : "Deopt stub execution must not be visible to other threads.";
            assert (!ExceptionUnwind.getLazyDeoptStubShouldReturnToExceptionHandler());
            Deoptimizer.lazyDeoptStubCore(originalStackPointer, gpReturnValue, fpReturnValue, false, null);
            throw UnreachableNode.unreachable();
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHere("Exception in lazy deopt stub", t);
        }
    }

    @Uninterruptible(reason="Rewriting stack.")
    private static UnsignedWord lazyDeoptStubCore(Pointer originalStackPointer, UnsignedWord gpReturnValue, UnsignedWord fpReturnValue, boolean hasException, Object gpReturnValueObject) {
        DeoptimizedFrame deoptFrame;
        CodePointer deoptStubAddress = FrameAccess.singleton().readReturnAddress(CurrentIsolate.getCurrentThread(), originalStackPointer);
        assert (Deoptimizer.isLazyDeoptStub(deoptStubAddress));
        CodePointer originalReturnAddress = (CodePointer)originalStackPointer.readWord(0);
        VMError.guarantee(originalReturnAddress.isNonNull());
        try {
            deoptFrame = Deoptimizer.constructLazilyDeoptimizedFrameInterruptibly(originalStackPointer, originalReturnAddress, hasException);
        }
        catch (OutOfMemoryError ex) {
            ExceptionUnwind.unwindExceptionSkippingCaller(ex, originalStackPointer);
            throw UnreachableNode.unreachable();
        }
        DeoptimizationCounters.counters().deoptCount.inc();
        VMError.guarantee(deoptFrame != null, "was not able to lazily construct a deoptimized frame");
        Pointer newSp = Deoptimizer.computeNewStackPointer(originalStackPointer, deoptFrame);
        deoptFrame.buildContent(newSp);
        VMError.guarantee(originalStackPointer.readWord(0) == originalReturnAddress, "Eager deoptimization should not occur when lazy deoptimization is in progress");
        CodePointer returnAddressAfter = FrameAccess.singleton().readReturnAddress(CurrentIsolate.getCurrentThread(), originalStackPointer);
        VMError.guarantee(returnAddressAfter == deoptStubAddress, "Return address must remain unchanged during deoptimization");
        recentDeoptimizationEvents.append(deoptFrame.getCompletedMessage());
        UnsignedWord updatedGpReturnValue = gpReturnValue;
        if (gpReturnValueObject != null) {
            updatedGpReturnValue = Word.objectToUntrackedPointer((Object)gpReturnValueObject);
        }
        return Deoptimizer.rewriteStackStub(newSp, updatedGpReturnValue, fpReturnValue, deoptFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Wrapper to call interruptible methods", calleeMustBe=false)
    private static DeoptimizedFrame constructLazilyDeoptimizedFrameInterruptibly(Pointer sourceSp, CodePointer ip, boolean hasException) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        SuspendSerialGCMaxHeapSize.suspendInCurrentThread();
        try {
            DeoptimizedFrame deoptimizedFrame;
            UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
            Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
            try {
                CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
                deoptimizedFrame = Deoptimizer.constructLazilyDeoptimizedFrameInterruptibly0(sourceSp, info, ip, hasException);
            }
            catch (Throwable throwable) {
                CodeInfoAccess.releaseTether(untetheredInfo, tether);
                throw throwable;
            }
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
            return deoptimizedFrame;
        }
        finally {
            SuspendSerialGCMaxHeapSize.resumeInCurrentThread();
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    private static DeoptimizedFrame constructLazilyDeoptimizedFrameInterruptibly0(Pointer sourceSp, CodeInfo info, CodePointer ip, boolean hasException) {
        Deoptimizer.maybeTestGC();
        CodeInfoQueryResult sourceChunk = CodeInfoTable.lookupCodeInfoQueryResult(info, ip);
        Deoptimizer.maybeTestGC();
        Deoptimizer deoptimizer = new Deoptimizer(sourceSp, sourceChunk, CurrentIsolate.getCurrentThread(), CurrentIsolate.getCurrentThread());
        Deoptimizer.maybeTestDeoptDuringLazyDeopt(deoptimizer, ip);
        DeoptimizedFrame deoptFrame = deoptimizer.doDeoptSourceFrame(ip, true, false);
        if (hasException) {
            deoptFrame.takeException();
        }
        Deoptimizer.maybeTestGC();
        return deoptFrame;
    }

    @DeoptStub(stubType=StubType.EntryStub)
    @Uninterruptible(reason="Frame holds Objects in unmanaged storage.")
    public static UnsignedWord eagerDeoptStub(Pointer originalStackPointer, UnsignedWord gpReturnValue, UnsignedWord fpReturnValue) {
        CFunctionPointer returnAddress = DeoptimizationSupport.getEagerDeoptStubPointer();
        FrameAccess.singleton().writeReturnAddress(CurrentIsolate.getCurrentThread(), originalStackPointer, (CodePointer)returnAddress);
        try {
            assert (PointerUtils.isAMultiple((PointerBase)KnownIntrinsics.readStackPointer(), Word.unsigned((int)ConfigurationValues.getTarget().stackAlignment)));
            VMError.guarantee(VMThreads.StatusSupport.isStatusJava(), "Deopt stub execution must not be visible to other threads.");
            DeoptimizedFrame frame = (DeoptimizedFrame)ReferenceAccess.singleton().readObjectAt(originalStackPointer, true);
            DeoptimizationCounters.counters().deoptCount.inc();
            if (DeoptimizationCounters.Options.ProfileDeoptimization.getValue().booleanValue()) {
                DeoptimizationCounters.startTime.set(System.nanoTime());
            }
            Pointer newSp = Deoptimizer.computeNewStackPointer(originalStackPointer, frame);
            frame.buildContent(newSp);
            frame.unpin();
            recentDeoptimizationEvents.append(frame.getCompletedMessage());
            Deoptimizer.rewriteStackStub(newSp, gpReturnValue, fpReturnValue, frame);
            throw UnreachableNode.unreachable();
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHere("Exception in eager deopt stub", t);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer computeNewStackPointer(Pointer originalStackPointer, DeoptimizedFrame deoptimizedFrame) {
        Pointer callerStackPointer = originalStackPointer.add(Word.unsigned((long)deoptimizedFrame.getSourceTotalFrameSize()));
        JavaFrameAnchors.verifyTopFrameAnchor(callerStackPointer);
        return callerStackPointer.subtract(deoptimizedFrame.getTargetContent().getSize());
    }

    @DeoptStub(stubType=StubType.ExitStub)
    @NeverInline(value="Custom prologue modifies stack pointer register")
    @Uninterruptible(reason="Frame holds Objects in unmanaged storage.")
    private static UnsignedWord rewriteStackStub(Pointer newSp, UnsignedWord gpReturnValue, UnsignedWord fpReturnValue, DeoptimizedFrame frame) {
        Pointer bottomSp = newSp.subtract(FrameAccess.returnAddressSize() + Deoptimizer.savedBasePointerSize());
        frame.getTargetContent().copyToPointer(bottomSp);
        if (DeoptimizationCounters.Options.ProfileDeoptimization.getValue().booleanValue()) {
            DeoptimizationCounters.counters().timeSpentInDeopt.add(System.nanoTime() - DeoptimizationCounters.startTime.get());
        }
        return gpReturnValue;
    }

    @Fold
    static int savedBasePointerSize() {
        if (SubstrateOptions.hasFramePointer()) {
            return FrameAccess.wordSize();
        }
        VMError.guarantee(Platform.includedIn(Platform.AMD64.class));
        return 0;
    }

    private void deoptSourceFrameLazily(CodePointer pc, boolean ignoreNonDeoptimizable) {
        assert (VMOperation.isInProgressAtSafepoint());
        if (!Options.LazyDeoptimization.getValue().booleanValue()) {
            this.deoptSourceFrameEagerly(pc, ignoreNonDeoptimizable);
            return;
        }
        if (Deoptimizer.checkLazyDeoptimized(this.deoptState.targetThread, this.deoptState.sourceSp) || Deoptimizer.checkEagerDeoptimized(this.deoptState.targetThread, this.deoptState.sourceSp) != null) {
            return;
        }
        if (!Deoptimizer.canBeDeoptimized(this.sourceChunk.getFrameInfo())) {
            if (ignoreNonDeoptimizable) {
                return;
            }
            throw Deoptimizer.fatalDeoptimizationError("Deoptimization: cannot lazily deoptimize a method that has no deoptimization entry point", this.sourceChunk.getFrameInfo(), this.sourceChunk.getFrameInfo());
        }
        FrameInfoQueryResult frameInfo = this.sourceChunk.getFrameInfo();
        CodeInfoQueryResult targetInfo = CodeInfoTable.lookupDeoptimizationEntrypoint(frameInfo.getDeoptMethodImageCodeInfo(), frameInfo.getDeoptMethodOffset(), frameInfo.getEncodedBci());
        Deoptimizer.installLazyDeoptStubReturnAddress(targetInfo.getDeoptReturnValueIsObject(), this.deoptState.sourceSp, this.deoptState.targetThread);
    }

    private DeoptimizedFrame deoptSourceFrameEagerly(CodePointer pc, boolean ignoreNonDeoptimizable) {
        if (!Deoptimizer.canBeDeoptimized(this.sourceChunk.getFrameInfo())) {
            if (ignoreNonDeoptimizable) {
                return null;
            }
            throw Deoptimizer.fatalDeoptimizationError("Deoptimization: cannot eagerly deoptimize a method that has no deoptimization entry point", this.sourceChunk.getFrameInfo(), this.sourceChunk.getFrameInfo());
        }
        EagerDeoptSourceFrameOperation operation = new EagerDeoptSourceFrameOperation(this, pc, ignoreNonDeoptimizable);
        operation.enqueue();
        return operation.getResult();
    }

    public DeoptimizedFrame deoptimizeEagerly() {
        VMError.guarantee(this.requestingThread == CurrentIsolate.getCurrentThread(), "This method should be called by the thread which creates the Deoptimizer.");
        return this.deoptSourceFrameEagerly(this.sourceChunk.getIP(), false);
    }

    @Uninterruptible(reason="Prevent stack walks from seeing an inconsistent stack.")
    private static void installLazyDeoptStubReturnAddress(boolean returnValueIsObject, Pointer sourceSp, IsolateThread targetThread) {
        assert (Options.LazyDeoptimization.getValue().booleanValue());
        assert (VMOperation.isInProgressAtSafepoint());
        CodePointer originalReturnAddress = FrameAccess.singleton().readReturnAddress(targetThread, sourceSp);
        CFunctionPointer stubAddress = returnValueIsObject ? DeoptimizationSupport.getLazyDeoptStubObjectReturnPointer() : DeoptimizationSupport.getLazyDeoptStubPrimitiveReturnPointer();
        FrameAccess.singleton().writeReturnAddress(targetThread, sourceSp, (CodePointer)stubAddress);
        sourceSp.writeWord(0, (WordBase)originalReturnAddress);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static CodePointer readLazyDeoptOriginalReturnAddress(IsolateThread thread, Pointer sp) {
        assert (Deoptimizer.checkLazyDeoptimized(thread, sp));
        return (CodePointer)sp.readWord(0);
    }

    @Uninterruptible(reason="Prevent stack walks from seeing an inconsistent stack.")
    private static void uninstallLazyDeoptStubReturnAddress(Pointer sourceSp, IsolateThread thread) {
        assert (Options.LazyDeoptimization.getValue().booleanValue());
        assert (VMOperation.isInProgressAtSafepoint());
        CodePointer originalReturnAddress = (CodePointer)sourceSp.readWord(0);
        assert (originalReturnAddress.isNonNull());
        sourceSp.writeWord(0, (WordBase)Word.nullPointer());
        FrameAccess.singleton().writeReturnAddress(thread, sourceSp, originalReturnAddress);
    }

    private static boolean canBeDeoptimized(FrameInfoQueryResult frame) {
        if (frame == null) {
            return false;
        }
        for (FrameInfoQueryResult currFrame = frame; currFrame != null; currFrame = currFrame.getCaller()) {
            if (currFrame.getDeoptMethodOffset() != 0) continue;
            return false;
        }
        return true;
    }

    private DeoptimizedFrame doDeoptSourceFrame(CodePointer pc, boolean ignoreNonDeoptimizable, boolean isEagerDeopt) {
        FrameInfoQueryResult frameInfo;
        DeoptimizedFrame existing;
        assert (!isEagerDeopt || VMOperation.isInProgressAtSafepoint()) : "eager deopts may only happen at a safepoint";
        if (Options.LazyDeoptimization.getValue().booleanValue()) {
            VMError.guarantee(this.deoptState.targetThread == this.requestingThread, "With lazy deoptimization enabled, this method may only be called for the requesting thread.");
        }
        if ((existing = Deoptimizer.checkEagerDeoptimized(this.deoptState.targetThread, this.deoptState.sourceSp)) != null) {
            return existing;
        }
        if (isEagerDeopt && Deoptimizer.checkLazyDeoptimized(this.deoptState.targetThread, this.deoptState.sourceSp)) {
            Deoptimizer.uninstallLazyDeoptStubReturnAddress(this.deoptState.sourceSp, this.deoptState.targetThread);
        }
        if ((frameInfo = this.sourceChunk.getFrameInfo()) == null) {
            if (ignoreNonDeoptimizable) {
                return null;
            }
            throw VMError.shouldNotReachHere("Deoptimization: cannot deoptimize a method that was not marked as deoptimizable from address " + Long.toHexString(pc.rawValue()));
        }
        assert (this.endOfParams == 0) : this.endOfParams;
        DeoptimizedFrame.VirtualFrame previousVirtualFrame = null;
        DeoptimizedFrame.VirtualFrame topFrame = null;
        for (FrameInfoQueryResult deoptInfo = frameInfo; deoptInfo != null; deoptInfo = deoptInfo.getCaller()) {
            DeoptimizationCounters.counters().virtualFrameCount.inc();
            if (deoptInfo.getDeoptMethodOffset() == 0) {
                if (ignoreNonDeoptimizable) {
                    return null;
                }
                throw Deoptimizer.fatalDeoptimizationError("Deoptimization: cannot deoptimize a method that has no deoptimization entry point", deoptInfo, frameInfo);
            }
            CodeInfoQueryResult targetInfo = CodeInfoTable.lookupDeoptimizationEntrypoint(deoptInfo.getDeoptMethodImageCodeInfo(), deoptInfo.getDeoptMethodOffset(), deoptInfo.getEncodedBci());
            if (targetInfo == null || targetInfo.getFrameInfo() == null) {
                throw Deoptimizer.fatalDeoptimizationError("Deoptimization: no matching target bytecode frame found for deopt target method", deoptInfo, frameInfo);
            }
            if (!targetInfo.getFrameInfo().isDeoptEntry()) {
                throw Deoptimizer.fatalDeoptimizationError("Deoptimization: target frame information not marked as deoptimization entry point", deoptInfo, frameInfo);
            }
            if (targetInfo.getFrameInfo().getDeoptMethod() != null && targetInfo.getFrameInfo().getDeoptMethod().hasCalleeSavedRegisters()) {
                throw Deoptimizer.fatalDeoptimizationError("Deoptimization: target method has callee saved registers, which are not properly restored by the deoptimization runtime", deoptInfo, frameInfo);
            }
            DeoptimizedFrame.VirtualFrame virtualFrame = this.constructTargetFrame(targetInfo, deoptInfo);
            if (previousVirtualFrame != null) {
                previousVirtualFrame.caller = virtualFrame;
            } else {
                topFrame = virtualFrame;
            }
            previousVirtualFrame = virtualFrame;
        }
        if (this.sourceChunk.getTotalFrameSize() < (long)FrameAccess.wordSize()) {
            throw Deoptimizer.fatalDeoptimizationError(String.format("Insufficient space in frame for pointer to DeoptimizedFrame sourceChunkSize: %s, word size: %s", this.sourceChunk.getTotalFrameSize(), FrameAccess.wordSize()), frameInfo, frameInfo);
        }
        DeoptimizedFrame.RelockObjectData[] relockObjectData = this.relockedObjects == null ? null : this.relockedObjects.toArray(new DeoptimizedFrame.RelockObjectData[this.relockedObjects.size()]);
        boolean rethrowException = FrameInfoDecoder.decodeRethrowException(frameInfo.getEncodedBci());
        DeoptimizedFrame deoptimizedFrame = DeoptimizedFrame.factory(this.targetContentSize, this.sourceChunk.getEncodedFrameSize(), CodeInfoTable.lookupInstalledCode(pc), topFrame, relockObjectData, pc, rethrowException, isEagerDeopt);
        if (isEagerDeopt) {
            this.installDeoptimizedFrame(deoptimizedFrame);
        }
        if (Options.TraceDeoptimization.getValue().booleanValue()) {
            Deoptimizer.printDeoptimizedFrame(Log.log(), this.deoptState.sourceSp, deoptimizedFrame, frameInfo, false);
        }
        Deoptimizer.logDeoptSourceFrameOperation(this.deoptState.sourceSp, deoptimizedFrame, frameInfo);
        return deoptimizedFrame;
    }

    private static void logDeoptSourceFrameOperation(Pointer sp, DeoptimizedFrame deoptimizedFrame, FrameInfoQueryResult frameInfo) {
        StringBuilderLog log = new StringBuilderLog();
        Word deoptimizedFrameAddress = Word.objectToUntrackedPointer((Object)deoptimizedFrame);
        log.string("deoptSourceFrameOperation: DeoptimizedFrame at ").zhex((WordBase)deoptimizedFrameAddress).string(": ");
        Deoptimizer.printDeoptimizedFrame(log, sp, deoptimizedFrame, frameInfo, true);
        recentDeoptimizationEvents.append(log.getResult().toCharArray());
    }

    public static void logRecentDeoptimizationEvents(Log log) {
        log.string("Recent deoptimization events (oldest first):").indent(true);
        recentDeoptimizationEvents.foreach(log, deoptEventsConsumer);
        log.indent(false);
    }

    private DeoptimizedFrame.VirtualFrame constructTargetFrame(CodeInfoQueryResult targetInfo, FrameInfoQueryResult sourceFrame) {
        boolean compatibleState;
        FrameInfoQueryResult targetFrame = targetInfo.getFrameInfo();
        int savedBasePointerSize = Deoptimizer.savedBasePointerSize();
        int targetFrameSize = NumUtil.safeToInt((long)targetInfo.getTotalFrameSize()) - FrameAccess.returnAddressSize() - savedBasePointerSize;
        DeoptimizedFrame.VirtualFrame result = new DeoptimizedFrame.VirtualFrame(targetFrame);
        if (savedBasePointerSize != 0) {
            result.savedBasePointer = new DeoptimizedFrame.SavedBasePointer(this.targetContentSize, this.targetContentSize + targetFrameSize);
            this.targetContentSize += savedBasePointerSize;
        }
        result.returnAddress = new DeoptimizedFrame.ReturnAddress(this.targetContentSize, targetInfo.getIP().rawValue());
        this.targetContentSize += FrameAccess.returnAddressSize();
        boolean bl = compatibleState = sourceFrame.getNumLocals() == targetFrame.getNumLocals() && sourceFrame.getNumStack() == targetFrame.getNumStack() && sourceFrame.getNumLocks() == targetFrame.getNumLocks() && targetFrame.getVirtualObjects().length == 0 && sourceFrame.getValueInfos().length >= targetFrame.getValueInfos().length;
        if (!compatibleState) {
            String message = String.format("Deoptimization is not possible. Please report this error.%nTarget Frame: numLocals-%s, numStack-%s, numLocks-%s, getValueInfos length-%s, virtual objects length-%s%nSource Frame: numLocals-%s, numStack-%s, numLocks-%s, getValueInfos length-%s%n", targetFrame.getNumLocals(), targetFrame.getNumStack(), targetFrame.getNumLocks(), targetFrame.getValueInfos().length, targetFrame.getVirtualObjects().length, sourceFrame.getNumLocals(), sourceFrame.getNumStack(), sourceFrame.getNumLocks(), sourceFrame.getValueInfos().length);
            throw Deoptimizer.fatalDeoptimizationError(message, targetFrame);
        }
        int numValues = targetFrame.getValueInfos().length;
        int newEndOfParams = this.endOfParams;
        block4: for (int idx = 0; idx < numValues; ++idx) {
            FrameInfoQueryResult.ValueInfo targetValue = targetFrame.getValueInfos()[idx];
            if (targetValue.getKind() == JavaKind.Illegal || targetValue.getType() == FrameInfoQueryResult.ValueType.ReservedRegister) continue;
            FrameInfoQueryResult.ValueInfo sourceValue = sourceFrame.getValueInfos()[idx];
            JavaConstant con = this.deoptState.readValue(sourceValue, sourceFrame);
            if (con.getJavaKind() == JavaKind.Illegal) {
                throw Deoptimizer.fatalDeoptimizationError("Found illegal kind in source frame", sourceFrame);
            }
            if (con.getJavaKind().isObject() && SubstrateObjectConstant.isCompressed(con) != targetValue.isCompressedReference()) {
                Object obj = SubstrateObjectConstant.asObject((Constant)con);
                con = SubstrateObjectConstant.forObject(obj, targetValue.isCompressedReference());
            }
            if (sourceValue.isEliminatedMonitor()) {
                this.relockObject(con);
            }
            switch (targetValue.getType()) {
                case StackSlot: {
                    DeoptimizationCounters.counters().stackValueCount.inc();
                    int targetOffset = TypeConversion.asS4((long)targetValue.getData());
                    int totalOffset = this.targetContentSize + targetOffset;
                    if (totalOffset < this.endOfParams || targetOffset < 0 || targetOffset == targetFrameSize || targetOffset == targetFrameSize + savedBasePointerSize) {
                        throw Deoptimizer.fatalDeoptimizationError(String.format("Bad offset values. targetOffset %s, totalOffset %s, endOfParams %s, targetFrameSize %s, savedBasePointerSize %s", targetOffset, totalOffset, this.endOfParams, targetFrameSize, savedBasePointerSize), targetFrame);
                    }
                    if (targetOffset < targetFrameSize) {
                        result.values[idx] = DeoptimizedFrame.ConstantEntry.factory(totalOffset, con, sourceFrame);
                        continue block4;
                    }
                    if (sourceFrame.getCaller() == null) continue block4;
                    result.values[idx] = DeoptimizedFrame.ConstantEntry.factory(totalOffset, con, sourceFrame);
                    int size = targetValue.getKind().isObject() && !targetValue.isCompressedReference() ? FrameAccess.uncompressedReferenceSize() : ConfigurationValues.getObjectLayout().sizeInBytes(con.getJavaKind());
                    int endOffset = totalOffset + size;
                    if (endOffset <= newEndOfParams) continue block4;
                    newEndOfParams = endOffset;
                    continue block4;
                }
                case DefaultConstant: 
                case Constant: {
                    this.verifyConstant(targetFrame, targetValue, con);
                    DeoptimizationCounters.counters().constantValueCount.inc();
                    continue block4;
                }
                default: {
                    throw Deoptimizer.fatalDeoptimizationError("Unknown deopt target value type: " + String.valueOf(targetValue), targetFrame);
                }
            }
        }
        this.targetContentSize += targetFrameSize;
        this.endOfParams = newEndOfParams;
        return result;
    }

    private void relockObject(JavaConstant valueConstant) {
        Object lockedObject = SubstrateObjectConstant.asObject((Constant)valueConstant);
        Object lockData = MonitorSupport.singleton().prepareRelockObject(lockedObject);
        if (this.relockedObjects == null) {
            this.relockedObjects = new ArrayList();
        }
        this.relockedObjects.add(new DeoptimizedFrame.RelockObjectData(lockedObject, lockData));
    }

    private void verifyConstant(FrameInfoQueryResult targetFrame, FrameInfoQueryResult.ValueInfo targetValue, JavaConstant source) {
        JavaConstant target = this.deoptState.readValue(targetValue, targetFrame);
        boolean equal = source.getJavaKind() == JavaKind.Object && target.getJavaKind() == JavaKind.Object ? SubstrateObjectConstant.asObject((Constant)target) == SubstrateObjectConstant.asObject((Constant)source) : source.equals((Object)target);
        if (!equal) {
            throw Deoptimizer.fatalDeoptimizationError(String.format("Constants do not match.%nSource: %s%nTarget: %s", source, target), targetFrame);
        }
    }

    protected static void writeValueInMaterializedObj(Object materializedObj, UnsignedWord offsetInObj, JavaConstant constant, FrameInfoQueryResult frameInfo) {
        if (offsetInObj.equal(0)) {
            throw Deoptimizer.fatalDeoptimizationError("offsetInObj is 0. Materialized value would overwrite hub.", frameInfo);
        }
        switch (constant.getJavaKind()) {
            case Boolean: {
                BarrieredAccess.writeByte((Object)materializedObj, (WordBase)offsetInObj, (byte)(constant.asBoolean() ? (byte)1 : 0));
                break;
            }
            case Byte: {
                BarrieredAccess.writeByte((Object)materializedObj, (WordBase)offsetInObj, (byte)((byte)constant.asInt()));
                break;
            }
            case Char: {
                BarrieredAccess.writeChar((Object)materializedObj, (WordBase)offsetInObj, (char)((char)constant.asInt()));
                break;
            }
            case Short: {
                BarrieredAccess.writeShort((Object)materializedObj, (WordBase)offsetInObj, (short)((short)constant.asInt()));
                break;
            }
            case Int: {
                BarrieredAccess.writeInt((Object)materializedObj, (WordBase)offsetInObj, (int)constant.asInt());
                break;
            }
            case Long: {
                BarrieredAccess.writeLong((Object)materializedObj, (WordBase)offsetInObj, (long)constant.asLong());
                break;
            }
            case Float: {
                BarrieredAccess.writeFloat((Object)materializedObj, (WordBase)offsetInObj, (float)constant.asFloat());
                break;
            }
            case Double: {
                BarrieredAccess.writeDouble((Object)materializedObj, (WordBase)offsetInObj, (double)constant.asDouble());
                break;
            }
            case Object: {
                BarrieredAccess.writeObject((Object)materializedObj, (WordBase)offsetInObj, (Object)SubstrateObjectConstant.asObject((Constant)constant));
                break;
            }
            default: {
                throw Deoptimizer.fatalDeoptimizationError("Unexpected JavaKind " + String.valueOf(constant.getJavaKind()), frameInfo);
            }
        }
    }

    private static void printDeoptimizedFrame(Log log, Pointer sp, DeoptimizedFrame deoptimizedFrame, FrameInfoQueryResult sourceFrameInfo, boolean printOnlyTopFrames) {
        log.string("[Deoptimization of frame (").rational(Isolates.getUptimeMillis(), 1000L, 3L).string("s)").newline();
        SubstrateInstalledCode installedCode = deoptimizedFrame.getSourceInstalledCode();
        if (installedCode != null) {
            log.string("    name: ").string(installedCode.getName()).newline();
        }
        log.string("    sp: ").zhex((WordBase)sp).string("  ip: ").zhex((WordBase)deoptimizedFrame.getSourcePC()).newline();
        if (sourceFrameInfo != null) {
            log.string("    stack trace where execution continues:").newline();
            FrameInfoQueryResult sourceFrame = sourceFrameInfo;
            DeoptimizedFrame.VirtualFrame targetFrame = deoptimizedFrame.getTopFrame();
            int count = 0;
            while (sourceFrame != null) {
                SharedMethod deoptMethod = sourceFrame.getDeoptMethod();
                log.string("        at ");
                if (deoptMethod != null) {
                    StackTraceElement element = deoptMethod.asStackTraceElement(sourceFrame.getBci());
                    if (element.getFileName() != null && element.getLineNumber() >= 0) {
                        log.string(element.toString());
                    } else {
                        log.string(deoptMethod.format("%H.%n(%p)"));
                    }
                } else {
                    log.string("method at ").zhex((WordBase)sourceFrame.getDeoptMethodAddress());
                }
                log.string(" bci ");
                FrameInfoDecoder.logReadableBci(log, sourceFrame.getEncodedBci());
                log.string("  return address ").zhex(targetFrame.returnAddress.returnAddress).newline();
                if (printOnlyTopFrames || Options.TraceDeoptimizationDetails.getValue().booleanValue()) {
                    Deoptimizer.printVirtualFrame(log, targetFrame);
                }
                if (printOnlyTopFrames && ++count >= 4) break;
                sourceFrame = sourceFrame.getCaller();
                targetFrame = targetFrame.getCaller();
            }
        }
        log.string("]").newline();
    }

    private static void printVirtualFrame(Log log, DeoptimizedFrame.VirtualFrame virtualFrame) {
        FrameInfoQueryResult frameInfo = virtualFrame.getFrameInfo();
        String sourceReference = frameInfo.getSourceReference().toString();
        if (sourceReference != null) {
            log.string("            ").string(sourceReference).newline();
        }
        log.string("            bci: ");
        FrameInfoDecoder.logReadableBci(log, frameInfo.getEncodedBci());
        log.string("  deoptMethodOffset: ").signed(frameInfo.getDeoptMethodOffset());
        log.string("  deoptMethod: ").zhex((WordBase)frameInfo.getDeoptMethodAddress());
        log.string("  return address: ").zhex(virtualFrame.returnAddress.returnAddress).string("  offset: ").signed(virtualFrame.returnAddress.offset);
        for (int i = 0; i < frameInfo.getValueInfos().length; ++i) {
            JavaConstant con = virtualFrame.getConstant(i);
            if (con.getJavaKind() == JavaKind.Illegal) continue;
            log.newline().string("            slot ").signed(i);
            log.string("  kind: ").string(con.getJavaKind().toString());
            if (con.getJavaKind() == JavaKind.Object) {
                Object val = SubstrateObjectConstant.asObject((Constant)con);
                if (val == null) {
                    log.string("  null");
                } else {
                    log.string("  value: ").object(val);
                }
            } else {
                log.string("  value: ").string(con.toValueString());
            }
            log.string("  offset: ").signed(virtualFrame.values[i].offset);
        }
        log.newline();
    }

    static RuntimeException fatalDeoptimizationError(String originalMessage, FrameInfoQueryResult frameInfo) {
        throw Deoptimizer.fatalDeoptimizationError0(originalMessage, frameInfo, frameInfo, false);
    }

    static RuntimeException fatalDeoptimizationError(String originalMessage, FrameInfoQueryResult frameInfo, FrameInfoQueryResult topFrame) {
        throw Deoptimizer.fatalDeoptimizationError0(originalMessage, frameInfo, topFrame, true);
    }

    private static RuntimeException fatalDeoptimizationError0(String originalMessage, FrameInfoQueryResult frameInfo, FrameInfoQueryResult topFrame, boolean fullStack) {
        long encodedBci = frameInfo.getEncodedBci();
        String message = String.format("%s%nencodedBci: %s (bci %s)%nMethod info: %s", originalMessage, encodedBci, FrameInfoDecoder.readableBci(encodedBci), frameInfo.getSourceReference());
        StringBuilder sb = new StringBuilder(message);
        if (fullStack) {
            sb.append(System.lineSeparator()).append("Full Deoptimized Stack").append(System.lineSeparator());
        } else {
            sb.append(System.lineSeparator()).append("Partial Deoptimized Stack").append(System.lineSeparator());
        }
        for (FrameInfoQueryResult current = topFrame; current != null; current = current.getCaller()) {
            sb.append(current.getSourceReference()).append(System.lineSeparator());
        }
        throw VMError.shouldNotReachHere(sb.toString());
    }

    static {
        assert (Deoptimizer.checkEncoding());
        testGCinDeoptimizer = false;
        testEagerDeoptInLazyDeoptFatalError = false;
        testLazyDeoptInLazyDeopt = false;
        deoptEventsConsumer = (context, entry) -> {
            Log log = (Log)context;
            int length = Math.min(((char[])entry).length, 1000);
            for (int i = 0; i < length; ++i) {
                char c = entry[i];
                log.character(c);
                if (c != '\n') continue;
                log.spaces(log.getIndentation());
            }
            if (length < ((char[])entry).length) {
                log.string("...").newline();
            }
        };
    }

    public static class Options {
        public static final RuntimeOptionKey<Boolean> TraceDeoptimization = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Boolean> TraceDeoptimizationDetails = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final HostedOptionKey<Boolean> LazyDeoptimization = new HostedOptionKey<Boolean>(true);
    }

    private static class DeoptimizeAllOperation
    extends JavaVMOperation {
        private final IsolateThread requestingThread;

        DeoptimizeAllOperation(IsolateThread requestingThread) {
            super(VMOperationInfos.get(DeoptimizeAllOperation.class, "Deoptimize all", VMOperation.SystemEffect.SAFEPOINT));
            this.requestingThread = requestingThread;
        }

        @Override
        protected void operate() {
            Deoptimizer.deoptimizeInRange((CodePointer)Word.zero(), (CodePointer)Word.zero(), true, this.requestingThread);
        }
    }

    private static class DeoptimizeFrameOperation
    extends JavaVMOperation {
        private final Pointer sourceSp;
        private final boolean ignoreNonDeoptimizable;
        private final SpeculationLog.SpeculationReason speculation;
        private final IsolateThread targetThread;
        private final IsolateThread requestingThread;
        private final boolean deoptEagerly;

        DeoptimizeFrameOperation(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, IsolateThread targetThread, boolean deoptEagerly, IsolateThread requestingThread) {
            super(VMOperationInfos.get(DeoptimizeFrameOperation.class, "Deoptimize frame", VMOperation.SystemEffect.SAFEPOINT));
            this.sourceSp = sourceSp;
            this.ignoreNonDeoptimizable = ignoreNonDeoptimizable;
            this.speculation = speculation;
            this.targetThread = targetThread;
            this.deoptEagerly = deoptEagerly;
            this.requestingThread = requestingThread;
            if (Options.LazyDeoptimization.getValue().booleanValue() && deoptEagerly) {
                VMError.guarantee(targetThread == requestingThread, "With lazy deoptimization enabled, a thread can request eager deoptimization only on itself.");
            }
        }

        @Override
        protected void operate() {
            if (Deoptimizer.checkDeoptimizedThenRegisterSpeculationFailure(this.deoptEagerly, this.targetThread, this.sourceSp, this.speculation)) {
                return;
            }
            if (Deoptimizer.checkLazyDeoptimized(this.targetThread, this.sourceSp)) {
                assert (this.deoptEagerly);
                Deoptimizer.uninstallLazyDeoptStubReturnAddress(this.sourceSp, this.targetThread);
            }
            CodePointer ip = FrameAccess.singleton().readReturnAddress(this.targetThread, this.sourceSp);
            Deoptimizer.deoptimizeFrame(this.targetThread, this.sourceSp, ip, this.ignoreNonDeoptimizable, this.speculation, this.deoptEagerly, this.requestingThread);
        }
    }

    static class TargetContent {
        private final byte[] frameBuffer;
        private static final int sizeofInt = JavaKind.Int.getByteCount();
        private static final int sizeofLong = JavaKind.Long.getByteCount();
        private final int sizeofCompressedReference = ConfigurationValues.getObjectLayout().getReferenceSize();
        private final int sizeofUncompressedReference = FrameAccess.uncompressedReferenceSize();
        private final int arrayBaseOffset = ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte);
        private static final ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException("TargetContent.offsetCheck");

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private void offsetCheck(int offset, int size) {
            if (0 > offset || offset > this.frameBuffer.length - size) {
                throw arrayIndexOutOfBoundsException;
            }
        }

        protected TargetContent(int targetContentSize, ByteOrder byteOrder) {
            if (byteOrder != ByteOrder.nativeOrder()) {
                VMError.unsupportedFeature("TargetContent with non-native byte order.");
            }
            if (FrameAccess.returnAddressSize() != sizeofLong) {
                VMError.unsupportedFeature("TargetContent with returnAddressSize() != sizeof(long).");
            }
            this.frameBuffer = new byte[targetContentSize];
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected int getSize() {
            return this.frameBuffer.length;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void copyToPointer(Pointer p) {
            for (int idx = 0; idx < this.frameBuffer.length; ++idx) {
                p.writeByte(idx, this.frameBuffer[idx]);
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void writeInt(int offset, int value) {
            this.offsetCheck(offset, sizeofInt);
            this.addressOfFrameArray0().writeInt(offset, value);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void writeLong(int offset, long value) {
            this.offsetCheck(offset, sizeofLong);
            this.addressOfFrameArray0().writeLong(offset, value);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void writeWord(int offset, WordBase value) {
            if (FrameAccess.wordSize() == 8) {
                this.writeLong(offset, value.rawValue());
            } else if (FrameAccess.wordSize() == 4) {
                this.writeInt(offset, (int)value.rawValue());
            } else {
                throw VMError.shouldNotReachHere("Unexpected word size: " + FrameAccess.wordSize());
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void writeObject(int offset, Object value, boolean compressed) {
            this.offsetCheck(offset, compressed ? this.sizeofCompressedReference : this.sizeofUncompressedReference);
            Word address = (Word)this.addressOfFrameArray0();
            address = address.add(offset);
            ReferenceAccess.singleton().writeObjectAt((Pointer)address, value, compressed);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private Pointer addressOfFrameArray0() {
            return Word.objectToUntrackedPointer((Object)this.frameBuffer).add(this.arrayBaseOffset);
        }
    }

    private static final class EagerDeoptSourceFrameOperation
    extends JavaVMOperation {
        private final Deoptimizer receiver;
        private final CodePointer pc;
        private final boolean ignoreNonDeoptimizable;
        private DeoptimizedFrame result;

        EagerDeoptSourceFrameOperation(Deoptimizer receiver, CodePointer pc, boolean ignoreNonDeoptimizable) {
            super(VMOperationInfos.get(EagerDeoptSourceFrameOperation.class, "Eagerly deoptimize source frame", VMOperation.SystemEffect.SAFEPOINT));
            this.receiver = receiver;
            this.pc = pc;
            this.ignoreNonDeoptimizable = ignoreNonDeoptimizable;
            this.result = null;
            if (Options.LazyDeoptimization.getValue().booleanValue()) {
                VMError.guarantee(receiver.deoptState.targetThread == receiver.requestingThread, "With lazy deoptimization enabled, a thread can request eager deoptimization only on itself.");
            }
        }

        @Override
        public void operate() {
            this.result = this.receiver.doDeoptSourceFrame(this.pc, this.ignoreNonDeoptimizable, true);
        }

        public DeoptimizedFrame getResult() {
            return this.result;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface DeoptStub {
        public StubType stubType();
    }

    public static enum StubType {
        NoDeoptStub,
        EntryStub,
        ExitStub,
        InterpreterEnterStub,
        InterpreterLeaveStub;


        public boolean isInterpreterStub() {
            return this.equals((Object)InterpreterEnterStub) || this.equals((Object)InterpreterLeaveStub);
        }
    }
}

