/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.NotifyGCRuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.UserError;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.EconomicMap;

public final class SerialAndEpsilonGCOptions {
    public static final RuntimeOptionKey<Integer> MaximumHeapSizePercent = new NotifyGCRuntimeOptionKey<Integer>(Integer.valueOf(80), SerialAndEpsilonGCOptions::validateSerialOrParallelOrEpsilonRuntimeOption, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Integer> MaximumYoungGenerationSizePercent = new NotifyGCRuntimeOptionKey<Integer>(Integer.valueOf(10), SerialAndEpsilonGCOptions::validateSerialOrParallelOrEpsilonRuntimeOption, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Long> AlignedHeapChunkSize = new HostedOptionKey<Long>(Long.valueOf(524288L), SerialAndEpsilonGCOptions::validateSerialOrParallelOrEpsilonHostedOption){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            int multiple = 4096;
            UserError.guarantee(newValue > 0L && newValue % (long)multiple == 0L, "%s value must be a multiple of %d.", this.getName(), multiple);
        }
    };
    public static final HostedOptionKey<Long> LargeArrayThreshold = new HostedOptionKey<Long>(131072L, SerialAndEpsilonGCOptions::validateSerialOrParallelOrEpsilonHostedOption);
    public static final HostedOptionKey<Boolean> ZapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::validateSerialOrParallelOrEpsilonHostedOption);
    public static final HostedOptionKey<Boolean> ZapProducedHeapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::validateSerialOrParallelOrEpsilonHostedOption);
    public static final HostedOptionKey<Boolean> ZapConsumedHeapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::validateSerialOrParallelOrEpsilonHostedOption);
    public static final HostedOptionKey<Integer> HeapChunkHeaderPadding = new HostedOptionKey<Integer>(0, SerialAndEpsilonGCOptions::validateSerialOrParallelOrEpsilonHostedOption);
    public static final RuntimeOptionKey<Long> InitialTLABSize = new RuntimeOptionKey<Long>(Long.valueOf(8192L), SerialAndEpsilonGCOptions::validateSerialOrParallelOrEpsilonRuntimeOption, RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
    public static final HostedOptionKey<Boolean> PrintTLAB = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::validateSerialOrParallelOrEpsilonHostedOption);

    private SerialAndEpsilonGCOptions() {
    }

    public static void validateSerialOrParallelOrEpsilonHostedOption(HostedOptionKey<?> optionKey) {
        if (optionKey.hasBeenSet() && !SubstrateOptions.useSerialGC() && !SubstrateOptions.useEpsilonGC()) {
            throw UserError.abort("The option '" + optionKey.getName() + "' can only be used together with the serial ('--gc=serial'), parallel ('--gc=parallel') or the epsilon garbage collector ('--gc=epsilon').", new Object[0]);
        }
    }

    public static void validateSerialOrParallelOrEpsilonRuntimeOption(RuntimeOptionKey<?> optionKey) {
        if (optionKey.hasBeenSet() && !SubstrateOptions.useSerialGC() && !SubstrateOptions.useEpsilonGC()) {
            throw UserError.abort("The option '" + optionKey.getName() + "' can only be used together with the serial ('--gc=serial'), parallel ('--gc=parallel') or the epsilon garbage collector ('--gc=epsilon').", new Object[0]);
        }
    }
}

