/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.NodeClassMap;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.graphbuilderconf.ParameterPlugin;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.SnippetParameterInfo;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.replacements.ConstantBindingParameterPlugin;
import jdk.graal.compiler.replacements.PEGraphDecoder;
import jdk.graal.compiler.replacements.ReplacementsImpl;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

public class SubstrateReplacements
extends ReplacementsImpl {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Builder builder;
    private InvocationPlugins snippetInvocationPlugins;
    private byte[] snippetEncoding;
    private Object[] snippetObjects;
    private NodeClassMap snippetNodeClasses;
    private Map<ResolvedJavaMethod, Integer> snippetStartOffsets;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateReplacements(Providers providers, BytecodeProvider bytecodeProvider, TargetDescription target, GraphMakerFactory graphMakerFactory) {
        super((DebugHandlersFactory)new GraalDebugHandlersFactory(providers.getSnippetReflection()), providers, bytecodeProvider, target);
        this.builder = new Builder(graphMakerFactory);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerImmutableObjects(Feature.BeforeHeapLayoutAccess access) {
        access.registerAsImmutable((Object)this);
        access.registerAsImmutable((Object)this.snippetEncoding);
        access.registerAsImmutable((Object)this.snippetObjects);
        access.registerAsImmutable((Object)this.snippetNodeClasses);
        access.registerAsImmutable(this.snippetStartOffsets, SubstrateReplacements::isImmutable);
    }

    private static boolean isImmutable(Object o) {
        return !(o instanceof SubstrateForeignCallLinkage) && !(o instanceof SubstrateTargetDescription) && !(o instanceof ImageCodeInfo);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Collection<StructuredGraph> getSnippetGraphs(boolean trackNodeSourcePosition, OptionValues options, Function<Object, Object> objectTransformer) {
        ArrayList<StructuredGraph> result = new ArrayList<StructuredGraph>(this.snippetStartOffsets.size());
        for (ResolvedJavaMethod method : this.snippetStartOffsets.keySet()) {
            result.add(this.getSnippet(method, null, trackNodeSourcePosition, options, objectTransformer));
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public NodeClassMap getSnippetNodeClasses() {
        return this.snippetNodeClasses;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Collection<ResolvedJavaMethod> getSnippetMethods() {
        return this.snippetStartOffsets.keySet();
    }

    public void setGraphBuilderPlugins(GraphBuilderConfiguration.Plugins plugins) {
        GraphBuilderConfiguration.Plugins copy = new GraphBuilderConfiguration.Plugins(plugins);
        copy.clearInlineInvokePlugins();
        for (InlineInvokePlugin plugin : plugins.getInlineInvokePlugins()) {
            copy.appendInlineInvokePlugin((InlineInvokePlugin)(plugin == this ? new SnippetInlineInvokePlugin() : plugin));
        }
        super.setGraphBuilderPlugins(copy);
    }

    public StructuredGraph getSnippet(ResolvedJavaMethod method, ResolvedJavaMethod recursiveEntry, Object[] args, BitSet nonNullParameters, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, OptionValues options) {
        return this.getSnippet(method, args, trackNodeSourcePosition, options, Function.identity());
    }

    public StructuredGraph getSnippet(final ResolvedJavaMethod method, Object[] args, boolean trackNodeSourcePosition, OptionValues options, final Function<Object, Object> objectTransformer) {
        Integer startOffset = this.snippetStartOffsets.get(method);
        if (startOffset == null) {
            throw VMError.shouldNotReachHere("snippet not found: " + method.format("%H.%n(%p)"));
        }
        ConstantBindingParameterPlugin parameterPlugin = null;
        if (args != null) {
            parameterPlugin = new ConstantBindingParameterPlugin(args, this.providers.getMetaAccess(), this.providers.getSnippetReflection());
        }
        OptionValues optionValues = new OptionValues(options, GraalOptions.TraceInlining, GraalOptions.TraceInliningForStubsAndSnippets.getValue(options), new Object[]{DebugOptions.OptimizationLog, null});
        try (DebugContext debug = this.openSnippetDebugContext("SVMSnippet_", method, optionValues);){
            final StructuredGraph result = new StructuredGraph.Builder(optionValues, debug).method(method).trackNodeSourcePosition(trackNodeSourcePosition).recordInlinedMethods(true).setIsSubstitution(true).build();
            final EncodedGraph encodedGraph = new EncodedGraph(this.snippetEncoding, startOffset.intValue(), this.snippetObjects, this.snippetNodeClasses, result);
            PEGraphDecoder graphDecoder = new PEGraphDecoder(this, ConfigurationValues.getTarget().arch, result, (CoreProviders)this.providers, null, this.snippetInvocationPlugins, new InlineInvokePlugin[0], (ParameterPlugin)parameterPlugin, null, null, null, new ConcurrentHashMap(), new ConcurrentHashMap(), true, false){
                private IntrinsicContext intrinsic;
                {
                    super(architecture, graph, providers, loopExplosionPlugin, invocationPlugins, inlineInvokePlugins, parameterPlugin, nodePlugins, peRootForInlining, sourceLanguagePositionProvider, specialCallTargetCache, invocationPluginCache, needsExplicitException, forceLink);
                    this.intrinsic = new IntrinsicContext(method, null, this.providers.getReplacements().getDefaultReplacementBytecodeProvider(), IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, false);
                }

                protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod lookupMethod, BytecodeProvider intrinsicBytecodeProvider) {
                    if (lookupMethod.equals((Object)method)) {
                        assert (!result.trackNodeSourcePosition() || encodedGraph.trackNodeSourcePosition());
                        return encodedGraph;
                    }
                    throw VMError.shouldNotReachHere(method.format("%H.%n(%p)"));
                }

                public IntrinsicContext getIntrinsic() {
                    return this.intrinsic;
                }

                protected Object readObject(GraphDecoder.MethodScope methodScope) {
                    return objectTransformer.apply(super.readObject(methodScope));
                }
            };
            graphDecoder.decode(method);
            assert (result.verify());
            StructuredGraph structuredGraph = result;
            return structuredGraph;
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerSnippet(final ResolvedJavaMethod method, ResolvedJavaMethod original, final Object receiver, final boolean trackNodeSourcePosition, final OptionValues options) {
        assert (AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, Snippet.class)) : "Snippet must be annotated with @" + Snippet.class.getSimpleName() + " " + String.valueOf(method);
        assert (method.hasBytecodes()) : "Snippet must not be abstract or native";
        assert (this.builder.graphs.get(method) == null) : "snippet registered twice: " + method.getName();
        assert (this.builder.registered.add(method)) : "snippet registered twice: " + method.getName();
        Runnable run = new Runnable(){
            final /* synthetic */ SubstrateReplacements this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try (DebugContext debug = this.this$0.openSnippetDebugContext("Snippet_", method, options);){
                    Object[] args = SubstrateReplacements.prepareConstantArguments(receiver);
                    StructuredGraph graph = this.this$0.makeGraph(debug, this.this$0.defaultBytecodeProvider, method, args, SnippetParameterInfo.getNonNullParameters((SnippetParameterInfo)this.this$0.getSnippetParameterInfo(method)), null, trackNodeSourcePosition, null);
                    for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE)) {
                        ResolvedJavaMethod callee = callTarget.targetMethod();
                        if (this.this$0.builder.delayedInvocationPluginMethods.contains(callee)) continue;
                        throw VMError.shouldNotReachHere("method " + callee.format("%h.%n") + " not inlined in snippet " + method.format("%h.%n") + " (maybe not final?)");
                    }
                    this.this$0.builder.graphs.put(method, graph);
                }
            }
        };
        this.builder.deferred.add(run);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Set<ResolvedJavaMethod> getDelayedInvocationPluginMethods() {
        return this.builder.delayedInvocationPluginMethods;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void encodeSnippets(GraphEncoder encoder) {
        while (!this.builder.deferred.isEmpty()) {
            this.builder.deferred.pop().run();
        }
        for (StructuredGraph structuredGraph : this.builder.graphs.values()) {
            encoder.prepare(structuredGraph);
        }
        encoder.finishPrepare();
        this.snippetStartOffsets = new HashMap<ResolvedJavaMethod, Integer>();
        for (Map.Entry entry : this.builder.graphs.entrySet()) {
            this.snippetStartOffsets.put((ResolvedJavaMethod)entry.getKey(), encoder.encode((StructuredGraph)entry.getValue()));
        }
        this.snippetEncoding = encoder.getEncoding();
        this.snippetObjects = encoder.getObjects();
        this.snippetNodeClasses = encoder.getNodeClasses();
        this.snippetInvocationPlugins = SubstrateReplacements.makeInvocationPlugins(this.getGraphBuilderPlugins(), this.builder, Function.identity());
        this.builder.graphs.clear();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static InvocationPlugins makeInvocationPlugins(GraphBuilderConfiguration.Plugins plugins, Builder builder, Function<Object, Object> objectReplacer) {
        HashMap<ResolvedJavaMethod, InvocationPlugin> result = new HashMap<ResolvedJavaMethod, InvocationPlugin>(builder.delayedInvocationPluginMethods.size());
        for (ResolvedJavaMethod method : builder.delayedInvocationPluginMethods) {
            ResolvedJavaMethod replacedMethod = (ResolvedJavaMethod)objectReplacer.apply(method);
            InvocationPlugin plugin = plugins.getInvocationPlugins().lookupInvocation(replacedMethod, HostedOptionValues.singleton());
            assert (plugin != null) : "expected invocation plugin for " + String.valueOf(replacedMethod);
            result.put(replacedMethod, plugin);
        }
        return new InvocationPlugins(result, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void copyFrom(SubstrateReplacements copyFrom, Function<Object, Object> objectReplacer) {
        this.snippetInvocationPlugins = SubstrateReplacements.makeInvocationPlugins(this.getGraphBuilderPlugins(), copyFrom.builder, objectReplacer);
        this.snippetEncoding = Arrays.copyOf(copyFrom.snippetEncoding, copyFrom.snippetEncoding.length);
        this.snippetNodeClasses = copyFrom.snippetNodeClasses;
        this.snippetObjects = new Object[copyFrom.snippetObjects.length];
        for (int i = 0; i < this.snippetObjects.length; ++i) {
            this.snippetObjects[i] = objectReplacer.apply(copyFrom.snippetObjects[i]);
        }
        this.snippetStartOffsets = new HashMap<ResolvedJavaMethod, Integer>(copyFrom.snippetStartOffsets.size());
        for (Map.Entry<ResolvedJavaMethod, Integer> entry : copyFrom.snippetStartOffsets.entrySet()) {
            this.snippetStartOffsets.put((ResolvedJavaMethod)objectReplacer.apply(entry.getKey()), entry.getValue());
        }
    }

    public boolean hasSubstitution(ResolvedJavaMethod method, OptionValues options) {
        return false;
    }

    public StructuredGraph getInlineSubstitution(ResolvedJavaMethod original, int invokeBci, boolean isInOOMETry, Invoke.InlineControl inlineControl, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosiion, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected final ReplacementsImpl.GraphMaker createGraphMaker(ResolvedJavaMethod substitute, ResolvedJavaMethod substitutedMethod) {
        return this.builder.graphMakerFactory.create(this.providers.getMetaAccess(), this, substitute, substitutedMethod);
    }

    private static Object[] prepareConstantArguments(Object receiver) {
        if (receiver != null) {
            return new Object[]{receiver};
        }
        return null;
    }

    public <T> T getInjectedArgument(Class<T> capability) {
        if (capability.isAssignableFrom(WordTypes.class)) {
            return (T)this.providers.getWordTypes();
        }
        return (T)super.getInjectedArgument(capability);
    }

    public Stamp getInjectedStamp(Class<?> type) {
        JavaKind kind = JavaKind.fromJavaClass(type);
        if (kind == JavaKind.Object) {
            ResolvedJavaType returnType = this.providers.getMetaAccess().lookupJavaType(type);
            if (this.providers.getWordTypes().isWord((JavaType)returnType)) {
                return this.providers.getWordTypes().getWordStamp(returnType);
            }
            return StampFactory.object((TypeReference)TypeReference.createWithoutAssumptions((ResolvedJavaType)returnType));
        }
        return StampFactory.forKind((JavaKind)kind);
    }

    public boolean isSnippet(ResolvedJavaMethod method) {
        if (method instanceof SharedMethod) {
            SharedMethod sharedMethod = (SharedMethod)method;
            return sharedMethod.isSnippet();
        }
        return super.isSnippet(method);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected static class Builder {
        protected final GraphMakerFactory graphMakerFactory;
        protected final Map<ResolvedJavaMethod, StructuredGraph> graphs;
        protected final Deque<Runnable> deferred;
        protected final HashSet<ResolvedJavaMethod> registered;
        protected final Set<ResolvedJavaMethod> delayedInvocationPluginMethods;

        protected Builder(GraphMakerFactory graphMakerFactory) {
            this.graphMakerFactory = graphMakerFactory;
            this.graphs = new HashMap<ResolvedJavaMethod, StructuredGraph>();
            this.deferred = new ArrayDeque<Runnable>();
            this.registered = new HashSet();
            this.delayedInvocationPluginMethods = new HashSet<ResolvedJavaMethod>();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static interface GraphMakerFactory {
        public ReplacementsImpl.GraphMaker create(MetaAccessProvider var1, ReplacementsImpl var2, ResolvedJavaMethod var3, ResolvedJavaMethod var4);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected class SnippetInlineInvokePlugin
    implements InlineInvokePlugin {
        protected SnippetInlineInvokePlugin() {
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            assert (b.parsingIntrinsic());
            assert (SubstrateReplacements.this.builder != null);
            Class intrinsifyingPlugin = SubstrateReplacements.this.getIntrinsifyingPlugin(method);
            if (intrinsifyingPlugin != null && GeneratedInvocationPlugin.class.isAssignableFrom(intrinsifyingPlugin)) {
                SubstrateReplacements.this.builder.delayedInvocationPluginMethods.add(method);
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            return InlineInvokePlugin.InlineInfo.createIntrinsicInlineInfo((ResolvedJavaMethod)method, (BytecodeProvider)SubstrateReplacements.this.defaultBytecodeProvider);
        }
    }
}

