/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.InsertStackOverflowCheckPhase;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckImpl;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckSnippets;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.stack.StackOverflowCheck;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.LoweringPhase;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredFeature
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
public final class StackOverflowCheckFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(StackOverflowCheck.class, (Object)new StackOverflowCheckImpl());
    }

    @Override
    public void registerGraalPhases(Providers providers, Suites suites, boolean hosted) {
        ListIterator position = suites.getMidTier().findPhase(LoweringPhase.class);
        position.previous();
        position.add(new InsertStackOverflowCheckPhase());
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(StackOverflowCheckImpl.FOREIGN_CALLS);
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        Predicate<ResolvedJavaMethod> mustNotAllocatePredicate = null;
        if (hosted) {
            mustNotAllocatePredicate = method -> ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate((ResolvedJavaMethod)method);
        }
        new StackOverflowCheckSnippets(options, providers, lowerings, mustNotAllocatePredicate);
    }
}

