/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.container.Container;
import com.oracle.svm.core.container.OperatingSystem;
import com.oracle.svm.core.layeredimagesingleton.InitialLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.EnumSet;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.UnsignedWord;

public class PhysicalMemory {
    private static final UnsignedWord UNSET_SENTINEL;
    private static UnsignedWord cachedSize;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isInitialized() {
        return cachedSize != UNSET_SENTINEL;
    }

    public static void initialize() {
        assert (!PhysicalMemory.isInitialized()) : "Physical memory already initialized.";
        long memoryLimit = IsolateArgumentParser.singleton().getLongOptionValue(IsolateArgumentParser.getOptionIndex(SubstrateOptions.ConcealedOptions.MaxRAM));
        cachedSize = memoryLimit > 0L ? Word.unsigned((long)memoryLimit) : (Container.singleton().isContainerized() ? Container.singleton().getPhysicalMemory() : OperatingSystem.singleton().getPhysicalMemorySize());
    }

    public static long usedSize() {
        if (Platform.includedIn(InternalPlatform.WINDOWS_BASE.class) || Platform.includedIn(Platform.MACOS.class) || Container.singleton().isContainerized() && Container.singleton().getMemoryLimitInBytes() > 0L) {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return osBean.getTotalMemorySize() - osBean.getFreeMemorySize();
        }
        return ((PhysicalMemorySupport)ImageSingletons.lookup(PhysicalMemorySupport.class)).usedSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord size() {
        VMError.guarantee(PhysicalMemory.isInitialized(), "Cached physical memory size is not available");
        return cachedSize;
    }

    static {
        cachedSize = UNSET_SENTINEL = UnsignedUtils.MAX_VALUE;
    }

    public static interface PhysicalMemorySupport
    extends InitialLayerOnlyImageSingleton {
        public UnsignedWord size();

        default public long usedSize() {
            return -1L;
        }

        @Override
        default public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
            return LayeredImageSingletonBuilderFlags.RUNTIME_ACCESS_ONLY;
        }
    }
}

