/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.thread.VMOperation;

public final class VMOperationInfo {
    private final Class<? extends VMOperation> clazz;
    private final int id;
    private final String name;
    private final VMOperation.SystemEffect systemEffect;

    VMOperationInfo(int id, Class<? extends VMOperation> clazz, String name, VMOperation.SystemEffect systemEffect) {
        this.id = id;
        this.clazz = clazz;
        this.name = name;
        this.systemEffect = systemEffect;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getId() {
        return this.id;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Class<? extends VMOperation> getVMOperationClass() {
        return this.clazz;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean getCausesSafepoint() {
        return VMOperation.SystemEffect.getCausesSafepoint(this.systemEffect);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isBlocking() {
        return true;
    }
}

