/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.InstanceReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.heap.PodReferenceMapDecoder;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.hub.HubType;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.util.VMError;
import java.util.function.IntConsumer;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class InteriorObjRefWalker {
    @NeverInline(value="Non-performance critical version")
    @Uninterruptible(reason="Forced inlining (StoredContinuation objects must not move).")
    public static void walkObject(Object obj, ObjectReferenceVisitor visitor) {
        InteriorObjRefWalker.walkObjectInline(obj, visitor);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Forced inlining (StoredContinuation objects must not move).", callerMustBe=true)
    public static void walkObjectInline(Object obj, ObjectReferenceVisitor visitor) {
        DynamicHub objHub = KnownIntrinsics.readHub(obj);
        int hubType = objHub.getHubType();
        if (HubType.isInstance(hubType)) {
            InteriorObjRefWalker.walkInstanceInline(obj, visitor, objHub);
        }
        switch (hubType) {
            case 0: 
            case 5: {
                return;
            }
            case 1: {
                InteriorObjRefWalker.walkReferenceSpecificFieldsInline(obj, visitor);
                return;
            }
            case 2: {
                InteriorObjRefWalker.walkPodArrayPartInline(obj, visitor, objHub);
                return;
            }
            case 3: {
                InteriorObjRefWalker.walkStoredContinuationInline(obj, visitor);
                return;
            }
            case 6: {
                InteriorObjRefWalker.walkObjectArrayInline(obj, visitor, objHub);
                return;
            }
        }
        throw VMError.shouldNotReachHere("Object with invalid hub type.");
    }

    public static void walkInstanceReferenceOffsets(DynamicHub objHub, final IntConsumer offsetConsumer) {
        if (objHub.getHubType() != 0 && objHub.getHubType() != 1) {
            throw new IllegalArgumentException("Unsupported hub type: " + objHub.getHubType());
        }
        InstanceReferenceMapDecoder.InstanceReferenceMap referenceMap = DynamicHubSupport.getInstanceReferenceMap(objHub);
        InstanceReferenceMapDecoder.walkReferences((Pointer)Word.zero(), referenceMap, new ObjectReferenceVisitor(){

            @Override
            public void visitObjectReferences(Pointer firstObjRef, boolean compressed, int referenceSize, Object holderObject, int count) {
                Pointer pos = firstObjRef;
                Pointer end = firstObjRef.add(Word.unsigned((int)count).multiply(referenceSize));
                while (pos.belowThan((UnsignedWord)end)) {
                    this.visitObjectReference(pos);
                    pos = pos.add(referenceSize);
                }
            }

            private void visitObjectReference(Pointer objRef) {
                offsetConsumer.accept((int)objRef.rawValue());
            }
        }, null);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void walkInstanceInline(Object obj, ObjectReferenceVisitor visitor, DynamicHub objHub) {
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        InstanceReferenceMapDecoder.InstanceReferenceMap referenceMap = DynamicHubSupport.getInstanceReferenceMap(objHub);
        InstanceReferenceMapDecoder.walkReferencesInline((Pointer)objPointer, referenceMap, visitor, obj);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void walkReferenceSpecificFieldsInline(Object obj, ObjectReferenceVisitor visitor) {
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        long discoveredOffset = ReferenceInternals.getNextDiscoveredFieldOffset();
        Pointer objRef = objPointer.add(Word.unsigned((long)discoveredOffset));
        InteriorObjRefWalker.callVisitorInline(obj, visitor, objRef, 1);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void walkPodArrayPartInline(Object obj, ObjectReferenceVisitor visitor, DynamicHub objHub) {
        if (!Pod.RuntimeSupport.isPresent()) {
            throw VMError.shouldNotReachHere("Pod objects cannot be in the heap if the pod support is disabled.");
        }
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        PodReferenceMapDecoder.walkOffsetsFromPointer((Pointer)objPointer, objHub.getLayoutEncoding(), visitor, obj);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
    private static void walkStoredContinuationInline(Object obj, ObjectReferenceVisitor visitor) {
        if (!ContinuationSupport.isSupported()) {
            throw VMError.shouldNotReachHere("Stored continuation objects cannot be in the heap if the continuation support is disabled.");
        }
        StoredContinuationAccess.walkReferences((StoredContinuation)obj, visitor);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void walkObjectArrayInline(Object obj, ObjectReferenceVisitor visitor, DynamicHub objHub) {
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        int length = ArrayLengthNode.arrayLength((Object)obj);
        Pointer firstObjRef = objPointer.add(LayoutEncoding.getArrayBaseOffset(objHub.getLayoutEncoding()));
        InteriorObjRefWalker.callVisitorInline(obj, visitor, firstObjRef, length);
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static void callVisitorInline(Object obj, ObjectReferenceVisitor visitor, Pointer firstObjRef, int count) {
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        visitor.visitObjectReferences(firstObjRef, true, referenceSize, obj, count);
    }
}

