/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.interpreter;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.FrameSourceInfo;
import java.util.Objects;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class InterpreterFrameSourceInfo
extends FrameSourceInfo {
    private final ResolvedJavaMethod interpretedMethod;
    private final Object interpreterFrame;

    public InterpreterFrameSourceInfo(Class<?> sourceClass, String sourceMethodName, int sourceLineNumber, int bci, ResolvedJavaMethod interpretedMethod, Object interpreterFrame) {
        super(sourceClass, sourceMethodName, sourceLineNumber, bci);
        this.interpretedMethod = interpretedMethod;
        this.interpreterFrame = interpreterFrame;
        Objects.requireNonNull(sourceClass);
        Objects.requireNonNull(sourceMethodName);
    }

    public Object getInterpreterFrame() {
        return this.interpreterFrame;
    }

    public ResolvedJavaMethod getInterpretedMethod() {
        return this.interpretedMethod;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void fillSourceFieldsIfMissing() {
    }
}

