/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.encoder.SymbolEncoder;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntryBase;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class ResourcesFeature
implements InternalFeature {
    ResourcesFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (ImageLayerBuildingSupport.firstImageBuild()) {
            ImageSingletons.add(Resources.class, (Object)new Resources());
        }
        Resources.currentLayer().setEncoder(SymbolEncoder.singleton());
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        for (ConditionalRuntimeValue<ResourceStorageEntryBase> entry : Resources.currentLayer().resources()) {
            ResourceStorageEntryBase unconditionalEntry = entry.getValueUnconditionally();
            if (!unconditionalEntry.hasData()) continue;
            for (byte[] resource : unconditionalEntry.getData()) {
                access.registerAsImmutable((Object)resource);
            }
        }
    }
}

