/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.graal.nodes.FieldOffsetNode;
import com.oracle.svm.core.jdk.VarHandleSupport;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;

abstract class VarHandleFieldOffsetComputer
implements FieldValueTransformerWithAvailability {
    private final JavaKind kind;

    VarHandleFieldOffsetComputer(JavaKind kind) {
        this.kind = kind;
    }

    @Override
    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    public Object transform(Object receiver, Object originalValue) {
        ResolvedJavaField field = VarHandleSupport.singleton().findVarHandleField(receiver, true);
        int offset = field.getOffset();
        if (offset <= 0) {
            throw VMError.shouldNotReachHere("Field is not marked as unsafe accessed: " + String.valueOf(field));
        }
        switch (this.kind) {
            case Int: {
                return offset;
            }
            case Long: {
                return (long)offset;
            }
        }
        throw VMError.shouldNotReachHere("Invalid kind: " + String.valueOf(this.kind));
    }

    @Override
    public ValueNode intrinsify(CoreProviders providers, JavaConstant receiver) {
        Object varHandle = providers.getSnippetReflection().asObject(Object.class, receiver);
        if (varHandle != null) {
            ResolvedJavaField field = VarHandleSupport.singleton().findVarHandleField(varHandle, false);
            return FieldOffsetNode.create(this.kind, field);
        }
        return null;
    }
}

