/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrSerializer;
import com.oracle.svm.core.jfr.JfrType;
import com.oracle.svm.core.nmt.NmtCategory;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrNmtCategorySerializer
implements JfrSerializer {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrNmtCategorySerializer() {
    }

    @Override
    public void write(JfrChunkWriter writer) {
        writer.writeCompressedLong(JfrType.NMTType.getId());
        NmtCategory[] nmtCategories = NmtCategory.values();
        writer.writeCompressedLong(nmtCategories.length);
        for (NmtCategory nmtCategory : nmtCategories) {
            writer.writeCompressedInt(nmtCategory.ordinal());
            writer.writeString(nmtCategory.getName());
        }
    }
}

