/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jfr.JfrNotAvailableTransformer;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_util_ValueFormatter;
import java.time.LocalDateTime;
import jdk.jfr.Recording;
import org.graalvm.nativeimage.ProcessProperties;

@TargetClass(className="jdk.jfr.internal.JVMSupport")
final class Target_jdk_jfr_internal_JVMSupport {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=JfrNotAvailableTransformer.class, isFinal=true)
    private static boolean notAvailable;

    Target_jdk_jfr_internal_JVMSupport() {
    }

    @Substitute
    public static String makeFilename(Recording recording) {
        long pid = ProcessProperties.getProcessID();
        LocalDateTime now = LocalDateTime.now();
        String date = Target_jdk_jfr_internal_util_ValueFormatter.formatDateTime(now);
        String idText = recording == null ? "" : "-id-" + recording.getId();
        String imageName = SubstrateOptions.Name.getValue();
        return imageName + "-pid-" + pid + idText + "-" + date + ".jfr";
    }
}

