/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.traceid;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.thread.VMOperation;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrTraceIdEpoch {
    private static final long EPOCH_0_BIT = 1L;
    private static final long EPOCH_1_BIT = 2L;
    private long epochId = 1L;

    @Fold
    public static JfrTraceIdEpoch getInstance() {
        return (JfrTraceIdEpoch)ImageSingletons.lookup(JfrTraceIdEpoch.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrTraceIdEpoch() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void changeEpoch() {
        assert (VMOperation.isInProgressAtSafepoint());
        ++this.epochId;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long thisEpochBit() {
        return this.getEpoch() ? 2L : 1L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long previousEpochBit() {
        return this.getEpoch() ? 1L : 2L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean currentEpoch() {
        return this.getEpoch();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean previousEpoch() {
        return !this.getEpoch();
    }

    @Uninterruptible(reason="Prevent epoch from changing.", callerMustBe=true)
    public long currentEpochId() {
        return this.epochId;
    }

    @Uninterruptible(reason="Prevent epoch from changing.", callerMustBe=true)
    private boolean getEpoch() {
        return (this.epochId & 1L) == 0L;
    }
}

