/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import com.oracle.svm.core.jdk.DirectByteBufferUtil;
import com.oracle.svm.core.jvmstat.PerfDirectMemoryEntry;
import com.oracle.svm.core.jvmstat.PerfUnit;
import com.oracle.svm.core.jvmstat.PerfVariability;
import java.nio.ByteBuffer;
import jdk.vm.ci.meta.JavaKind;

public class PerfDirectMemoryString
extends PerfDirectMemoryEntry {
    PerfDirectMemoryString(String name, PerfUnit unit) {
        super(name, unit);
    }

    protected ByteBuffer allocate(PerfVariability variability, byte[] value, int maxLength) {
        assert (value.length <= maxLength);
        int nullTerminatedMaxLength = maxLength + 1;
        this.allocate(variability, JavaKind.Byte, nullTerminatedMaxLength);
        PerfDirectMemoryString.writeNullTerminatedString(this.valuePtr, value, maxLength);
        return DirectByteBufferUtil.allocate(this.valuePtr.rawValue(), nullTerminatedMaxLength);
    }
}

