/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.meta.MethodOffset;
import java.util.Objects;
import jdk.vm.ci.meta.VMConstant;

public class SubstrateMethodOffsetConstant
implements VMConstant {
    private final MethodOffset offset;

    public SubstrateMethodOffsetConstant(MethodOffset offset) {
        this.offset = Objects.requireNonNull(offset);
    }

    public MethodOffset offset() {
        return this.offset;
    }

    public boolean isDefaultForKind() {
        return false;
    }

    public String toValueString() {
        return SubstrateMethodOffsetConstant.class.getSimpleName();
    }

    public String toString() {
        return "method offset: " + this.offset.getMethod().format("%H.%n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SubstrateMethodOffsetConstant)) return false;
        SubstrateMethodOffsetConstant other = (SubstrateMethodOffsetConstant)obj;
        if (!this.offset.getMethod().equals((Object)other.offset.getMethod())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.offset.getMethod());
    }
}

