/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nodes;

import java.util.Objects;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Depends on capture function.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="Depends on capture function.", allowedUsageTypes={InputType.Memory})
public class CFunctionCaptureNode
extends FixedWithNextNode
implements Lowerable,
SingleMemoryKill {
    public static final NodeClass<CFunctionCaptureNode> TYPE = NodeClass.create(CFunctionCaptureNode.class);
    ForeignCallDescriptor captureFunction;
    @Node.Input
    ValueNode statesToCapture;
    @Node.Input
    ValueNode captureBuffer;

    public CFunctionCaptureNode(ForeignCallDescriptor captureFunction, ValueNode statesToCapture, ValueNode captureBuffer) {
        super(TYPE, StampFactory.forVoid());
        this.captureFunction = Objects.requireNonNull(captureFunction);
        this.statesToCapture = Objects.requireNonNull(statesToCapture);
        this.captureBuffer = Objects.requireNonNull(captureBuffer);
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public void lower(LoweringTool tool) {
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return;
        }
        ForeignCallNode call = (ForeignCallNode)this.graph().add((Node)new ForeignCallNode(this.captureFunction, new ValueNode[]{this.statesToCapture, this.captureBuffer}));
        this.graph().replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)call);
    }
}

