/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nodes.foreign;

import com.oracle.svm.core.nodes.ClusterNode;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.util.GraphUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED, allowedUsageTypes={InputType.Association}, nameTemplate="Invoke#{p#type/s}")
public class ScopedMethodNode
extends FixedWithNextNode
implements ClusterNode {
    public static final NodeClass<ScopedMethodNode> TYPE = NodeClass.create(ScopedMethodNode.class);
    @Node.OptionalInput(value=InputType.Association)
    ScopedMethodNode start;
    private final Type type;

    public ScopedMethodNode() {
        super(TYPE, StampFactory.forVoid());
        this.type = Type.START;
    }

    public ScopedMethodNode(ScopedMethodNode start) {
        super(TYPE, StampFactory.forVoid());
        this.type = Type.END;
        this.start = start;
    }

    public ScopedMethodNode getStart() {
        return this.start;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void delete() {
        if (this.type == Type.START) {
            this.replaceAtUsages(null);
        }
        GraphUtil.unlinkFixedNode((FixedWithNextNode)this);
        this.safeDelete();
    }

    public String toString(Verbosity verbosity) {
        Object s = super.toString(verbosity);
        if (verbosity == Verbosity.Long) {
            s = (String)s + "#" + String.valueOf((Object)this.type);
        }
        return s;
    }

    public static enum Type {
        START,
        END;

    }
}

