/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.collections.EnumBitmask;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.SubstrateOptionKey;
import java.util.Objects;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class RuntimeOptionKey<T>
extends OptionKey<T>
implements SubstrateOptionKey<T> {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Consumer<RuntimeOptionKey<T>> buildTimeValidation;
    private final int flags;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeOptionKey(T defaultValue, RuntimeOptionKeyFlag ... flags) {
        this(defaultValue, (Consumer<RuntimeOptionKey<T>>)null, flags);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeOptionKey(T defaultValue, Consumer<RuntimeOptionKey<T>> buildTimeValidation, RuntimeOptionKeyFlag ... flags) {
        super(defaultValue);
        this.buildTimeValidation = buildTimeValidation;
        this.flags = EnumBitmask.computeBitmask(flags);
    }

    @Override
    public T getValue() {
        return (T)this.getValue((OptionValues)RuntimeOptionValues.singleton());
    }

    public void update(T value) {
        RuntimeOptionValues.singleton().update(this, value);
    }

    public void update(EconomicMap<OptionKey<?>, Object> values, Object newValue) {
        if (!SubstrateUtil.HOSTED && this.isImmutable() && !((RuntimeSupport)ImageSingletons.lookup(RuntimeSupport.class)).isUninitialized() && this.isDifferentValue(values, newValue)) {
            Object value = values.get((Object)this);
            throw new IllegalStateException("The runtime option '" + this.getName() + "' is immutable and can only be set during startup. Current value: " + String.valueOf(value) + ", new value: " + String.valueOf(newValue));
        }
        super.update(values, newValue);
    }

    private boolean isDifferentValue(EconomicMap<OptionKey<?>, Object> values, Object newValue) {
        if (!values.containsKey((Object)this) && !Objects.equals(this.getDefaultValue(), newValue)) {
            return true;
        }
        Object value = values.get((Object)this);
        return !Objects.equals(value, newValue);
    }

    @Override
    public boolean hasBeenSet() {
        return this.hasBeenSet((OptionValues)RuntimeOptionValues.singleton());
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void validate() {
        if (this.buildTimeValidation != null) {
            this.buildTimeValidation.accept(this);
        }
    }

    public boolean shouldCopyToCompilationIsolate() {
        return EnumBitmask.hasBit(this.flags, RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
    }

    public boolean isImmutable() {
        return EnumBitmask.hasBit(this.flags, RuntimeOptionKeyFlag.Immutable) || EnumBitmask.hasBit(this.flags, RuntimeOptionKeyFlag.IsolateCreationOnly) || EnumBitmask.hasBit(this.flags, RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
    }

    public boolean isIsolateCreationOnly() {
        return EnumBitmask.hasBit(this.flags, RuntimeOptionKeyFlag.IsolateCreationOnly) || EnumBitmask.hasBit(this.flags, RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
    }

    public boolean shouldRegisterForIsolateArgumentParser() {
        return EnumBitmask.hasBit(this.flags, RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
    }

    @Fold
    public T getHostedValue() {
        return (T)this.getValue((OptionValues)RuntimeOptionValues.singleton());
    }

    public static enum RuntimeOptionKeyFlag {
        RelevantForCompilationIsolates,
        Immutable,
        IsolateCreationOnly,
        RegisterForIsolateArgumentParser;

    }
}

