/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.headers.LibCSupport;
import com.oracle.svm.core.posix.headers.PosixLibC;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

public abstract class PosixLibCSupport
implements LibCSupport {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T memcpy(T dest, PointerBase src, UnsignedWord n) {
        return PosixLibC.memcpy(dest, src, n);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> int memcmp(T s1, T s2, UnsignedWord n) {
        return PosixLibC.memcmp(s1, s2, n);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T memmove(T dest, PointerBase src, UnsignedWord n) {
        return PosixLibC.memmove(dest, src, n);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T memset(T s, SignedWord c, UnsignedWord n) {
        return PosixLibC.memset(s, c, n);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T malloc(UnsignedWord size) {
        return PosixLibC.malloc(size);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T calloc(UnsignedWord nmemb, UnsignedWord size) {
        return PosixLibC.calloc(nmemb, size);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T realloc(PointerBase ptr, UnsignedWord size) {
        return PosixLibC.realloc(ptr, size);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void free(PointerBase ptr) {
        PosixLibC.free(ptr);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void exit(int status) {
        PosixLibC.exit(status);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord strlen(CCharPointer str) {
        return PosixLibC.strlen(str);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CCharPointer strdup(CCharPointer str) {
        return PosixLibC.strdup(str);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int strcmp(CCharPointer s1, CCharPointer s2) {
        return PosixLibC.strcmp((PointerBase)s1, (PointerBase)s2);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int isdigit(int c) {
        return PosixLibC.isdigit(c);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord strtoull(CCharPointer string, CCharPointerPointer endPtr, int base) {
        return PosixLibC.strtoull(string, endPtr, base);
    }
}

