/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.memory.UntrackedNullableNativeMemory;
import com.oracle.svm.core.os.AbstractRawFileOperationSupport;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.posix.PosixStat;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

public class PosixRawFileOperationSupport
extends AbstractRawFileOperationSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PosixRawFileOperationSupport(boolean useNativeByteOrder) {
        super(useNativeByteOrder);
    }

    @Override
    public CCharPointer allocateCPath(String path) {
        byte[] data = path.getBytes();
        CCharPointer filename = (CCharPointer)UntrackedNullableNativeMemory.malloc(Word.unsigned((int)(data.length + 1)));
        if (filename.isNull()) {
            return (CCharPointer)Word.nullPointer();
        }
        for (int i = 0; i < data.length; ++i) {
            filename.write(i, data[i]);
        }
        filename.write(data.length, (byte)0);
        return filename;
    }

    @Override
    public RawFileOperationSupport.RawFileDescriptor create(File file, RawFileOperationSupport.FileCreationMode creationMode, RawFileOperationSupport.FileAccessMode accessMode) {
        String path = file.getPath();
        int flags = PosixRawFileOperationSupport.parseMode(creationMode) | PosixRawFileOperationSupport.parseMode(accessMode);
        return PosixRawFileOperationSupport.open0(path, flags);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public RawFileOperationSupport.RawFileDescriptor create(CCharPointer cPath, RawFileOperationSupport.FileCreationMode creationMode, RawFileOperationSupport.FileAccessMode accessMode) {
        int flags = PosixRawFileOperationSupport.parseMode(creationMode) | PosixRawFileOperationSupport.parseMode(accessMode);
        return PosixRawFileOperationSupport.open0(cPath, flags);
    }

    @Override
    public String getTempDirectory() {
        return SystemPropertiesSupport.singleton().getInitialProperty("java.io.tmpdir");
    }

    @Override
    public RawFileOperationSupport.RawFileDescriptor open(File file, RawFileOperationSupport.FileAccessMode mode) {
        String path = file.getPath();
        int flags = PosixRawFileOperationSupport.parseMode(mode);
        return PosixRawFileOperationSupport.open0(path, flags);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public RawFileOperationSupport.RawFileDescriptor open(CCharPointer cPath, RawFileOperationSupport.FileAccessMode mode) {
        int flags = PosixRawFileOperationSupport.parseMode(mode);
        return PosixRawFileOperationSupport.open0(cPath, flags);
    }

    private static RawFileOperationSupport.RawFileDescriptor open0(String path, int flags) {
        try (CTypeConversion.CCharPointerHolder cPath = CTypeConversion.toCString((CharSequence)path);){
            RawFileOperationSupport.RawFileDescriptor rawFileDescriptor = PosixRawFileOperationSupport.open0(cPath.get(), flags);
            return rawFileDescriptor;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static RawFileOperationSupport.RawFileDescriptor open0(CCharPointer cPath, int flags) {
        int permissions = PosixStat.S_IRUSR() | PosixStat.S_IWUSR();
        return (RawFileOperationSupport.RawFileDescriptor)Word.signed((int)Fcntl.NoTransitions.open(cPath, flags, permissions));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isValid(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return posixFd > 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean close(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        int result = Unistd.NoTransitions.close(posixFd);
        return result == 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long size(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return PosixStat.getSize(posixFd);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long position(RawFileOperationSupport.RawFileDescriptor fd) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return Unistd.NoTransitions.lseek(posixFd, Word.signed((int)0), Unistd.SEEK_CUR()).rawValue();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean seek(RawFileOperationSupport.RawFileDescriptor fd, long position) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        SignedWord newPos = Unistd.NoTransitions.lseek(posixFd, Word.signed((long)position), Unistd.SEEK_SET());
        return position == newPos.rawValue();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean write(RawFileOperationSupport.RawFileDescriptor fd, Pointer data, UnsignedWord size) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return PosixUtils.writeUninterruptibly(posixFd, data, size);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long read(RawFileOperationSupport.RawFileDescriptor fd, Pointer buffer, UnsignedWord bufferSize) {
        int posixFd = PosixRawFileOperationSupport.getPosixFileDescriptor(fd);
        return PosixUtils.readUninterruptibly(posixFd, buffer, bufferSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getPosixFileDescriptor(RawFileOperationSupport.RawFileDescriptor fd) {
        int result = (int)fd.rawValue();
        assert ((long)result == fd.rawValue());
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int parseMode(RawFileOperationSupport.FileCreationMode mode) {
        switch (mode) {
            case CREATE: {
                return Fcntl.O_CREAT() | Fcntl.O_EXCL();
            }
            case CREATE_OR_REPLACE: {
                return Fcntl.O_CREAT() | Fcntl.O_TRUNC();
            }
        }
        throw VMError.shouldNotReachHereUnexpectedInput((Object)mode);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int parseMode(RawFileOperationSupport.FileAccessMode mode) {
        switch (mode) {
            case READ: {
                return Fcntl.O_RDONLY();
            }
            case READ_WRITE: {
                return Fcntl.O_RDWR();
            }
            case WRITE: {
                return Fcntl.O_WRONLY();
            }
        }
        throw VMError.shouldNotReachHereUnexpectedInput((Object)mode);
    }
}

