/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.snippets;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.BooleanPointer;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.JavaFrame;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaFrames;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.nodes.UnreachableNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public abstract class ExceptionUnwind {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor UNWIND_EXCEPTION_WITHOUT_CALLEE_SAVED_REGISTERS = SnippetRuntime.findForeignCall(ExceptionUnwind.class, "unwindExceptionWithoutCalleeSavedRegisters", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor UNWIND_EXCEPTION_WITH_CALLEE_SAVED_REGISTERS = SnippetRuntime.findForeignCall(ExceptionUnwind.class, "unwindExceptionWithCalleeSavedRegisters", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{UNWIND_EXCEPTION_WITHOUT_CALLEE_SAVED_REGISTERS, UNWIND_EXCEPTION_WITH_CALLEE_SAVED_REGISTERS};
    public static final FastThreadLocalObject<Throwable> currentException = FastThreadLocalFactory.createObject(Throwable.class, "ExceptionUnwind.currentException");
    public static final FastThreadLocalBytes<BooleanPointer> lazyDeoptStubShouldReturnToExceptionHandler = FastThreadLocalFactory.createBytes(() -> SizeOf.get(BooleanPointer.class), "ExceptionUnwind.lazyDeoptStubShouldReturnToExceptionHandler");

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setLazyDeoptStubShouldReturnToExceptionHandler(boolean val) {
        lazyDeoptStubShouldReturnToExceptionHandler.getAddress().write(val);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean getLazyDeoptStubShouldReturnToExceptionHandler() {
        return lazyDeoptStubShouldReturnToExceptionHandler.getAddress().read();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean exceptionsAreFatal() {
        return !VMThreads.StatusSupport.isStatusJava();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    @Uninterruptible(reason="Code that is fully uninterruptible may throw and catch exceptions. Therefore, the exception handling must be fully uninterruptible as well.")
    private static void unwindExceptionWithoutCalleeSavedRegisters(Throwable exception, Pointer callerSP) {
        ExceptionUnwind.unwindException(exception, callerSP, false, false);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    @Uninterruptible(reason="Code that is fully uninterruptible may throw and catch exceptions. Therefore, the exception handling must be fully uninterruptible as well.")
    private static void unwindExceptionWithCalleeSavedRegisters(Throwable exception, Pointer callerSP) {
        ExceptionUnwind.unwindException(exception, callerSP, true, false);
    }

    @Uninterruptible(reason="Code that is fully uninterruptible may throw and catch exceptions. Therefore, the exception handling must be fully uninterruptible as well.")
    public static void unwindExceptionSkippingCaller(Throwable exception, Pointer callerSP) {
        ExceptionUnwind.unwindException(exception, callerSP, true, true);
    }

    @Uninterruptible(reason="Code that is fully uninterruptible may throw and catch exceptions. Therefore, the exception handling must be fully uninterruptible as well.")
    private static void unwindException(Throwable exception, Pointer callerSP, boolean fromMethodWithCalleeSavedRegisters, boolean skipCaller) {
        if (currentException.get() != null) {
            ExceptionUnwind.reportRecursiveUnwind(exception);
            return;
        }
        currentException.set(exception);
        if (ExceptionUnwind.exceptionsAreFatal()) {
            ExceptionUnwind.reportFatalUnwind(exception);
            return;
        }
        if (ImageSingletons.contains(ExceptionUnwind.class)) {
            VMError.guarantee(!skipCaller, "Skipping the caller frame is not supported with custom exception unwind");
            ((ExceptionUnwind)ImageSingletons.lookup(ExceptionUnwind.class)).customUnwindException(callerSP);
        } else {
            ExceptionUnwind.defaultUnwindException(callerSP, fromMethodWithCalleeSavedRegisters, skipCaller);
        }
        ExceptionUnwind.reportUnhandledException(exception);
    }

    @Uninterruptible(reason="Does not need to be uninterruptible because it throws a fatal error.", calleeMustBe=false)
    private static void reportRecursiveUnwind(Throwable exception) {
        Log.log().string("Fatal error: recursion in exception handling: ").string(exception.getClass().getName());
        Log.log().string(" thrown while unwinding ").string(currentException.get().getClass().getName()).newline().newline();
        VMError.shouldNotReachHere("Recursion in exception handling");
    }

    @Uninterruptible(reason="Does not need to be uninterruptible because it throws a fatal error.", calleeMustBe=false)
    private static void reportFatalUnwind(Throwable exception) {
        Log.log().string("Fatal error: exception unwind while thread is not in Java state: ");
        Log.log().exception(exception).newline().newline();
        VMError.shouldNotReachHere("Exception unwind while thread is not in Java state");
    }

    @Uninterruptible(reason="Does not need to be uninterruptible because it throws a fatal error.", calleeMustBe=false)
    private static void reportUnhandledException(Throwable exception) {
        Log.log().string("Fatal error: unhandled exception in isolate ").hex((WordBase)CurrentIsolate.getIsolate()).string(": ");
        Log.log().exception(exception).newline().newline();
        VMError.shouldNotReachHere("Unhandled exception");
    }

    @Uninterruptible(reason="Code that is fully uninterruptible may throw and catch exceptions. Therefore, the exception handling must be fully uninterruptible as well.")
    protected abstract void customUnwindException(Pointer var1);

    @Uninterruptible(reason="Code that is fully uninterruptible may throw and catch exceptions. Therefore, the exception handling must be fully uninterruptible as well.")
    private static void defaultUnwindException(Pointer startSP, boolean fromMethodWithCalleeSavedRegisters, boolean skipCaller) {
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        boolean hasCalleeSavedRegisters = fromMethodWithCalleeSavedRegisters;
        boolean skipFrame = skipCaller;
        JavaStackWalk walk = (JavaStackWalk)StackValue.get((int)JavaStackWalker.sizeOfJavaStackWalk());
        JavaStackWalker.initialize(walk, thread, startSP);
        while (JavaStackWalker.advance(walk, thread)) {
            JavaFrame frame = JavaStackWalker.getCurrentFrame(walk);
            VMError.guarantee(!JavaFrames.isUnknownFrame(frame), "Exception unwinding must not encounter unknown frame");
            if (!skipFrame) {
                long exceptionOffset;
                Pointer sp = frame.getSP();
                if (DeoptimizationSupport.enabled()) {
                    long exceptionOffset2;
                    DeoptimizedFrame deoptFrame = Deoptimizer.checkEagerDeoptimized(frame);
                    if (deoptFrame != null) {
                        deoptFrame.takeException();
                        ExceptionUnwind.jumpToHandler(sp, (CodePointer)DeoptimizationSupport.getEagerDeoptStubPointer(), hasCalleeSavedRegisters);
                        UnreachableNode.unreachable();
                        return;
                    }
                    if (Deoptimizer.checkLazyDeoptimized(frame) && (exceptionOffset2 = frame.getExceptionOffset()) != 0L) {
                        ExceptionUnwind.setLazyDeoptStubShouldReturnToExceptionHandler(true);
                        ExceptionUnwind.jumpToHandler(sp, (CodePointer)DeoptimizationSupport.getLazyDeoptStubObjectReturnPointer(), hasCalleeSavedRegisters);
                        UnreachableNode.unreachable();
                        return;
                    }
                }
                if ((exceptionOffset = frame.getExceptionOffset()) != 0L) {
                    CodePointer handlerIP = (CodePointer)((UnsignedWord)frame.getIP()).add((UnsignedWord)Word.signed((long)exceptionOffset));
                    ExceptionUnwind.jumpToHandler(sp, handlerIP, hasCalleeSavedRegisters);
                    UnreachableNode.unreachable();
                    return;
                }
            } else {
                skipFrame = false;
            }
            VMError.guarantee(!JavaFrames.isEntryPoint(frame), "Entry point methods must have an exception handler.");
            hasCalleeSavedRegisters = CodeInfoQueryResult.hasCalleeSavedRegisters(frame.getEncodedFrameSize());
        }
    }

    @Uninterruptible(reason="Code that is fully uninterruptible may throw and catch exceptions. Therefore, the exception handling must be fully uninterruptible as well.")
    private static void jumpToHandler(Pointer sp, CodePointer handlerIP, boolean hasCalleeSavedRegisters) {
        JavaFrameAnchors.verifyTopFrameAnchor(sp);
        Throwable exception = currentException.get();
        currentException.set(null);
        if (hasCalleeSavedRegisters) {
            KnownIntrinsics.farReturn(exception, sp, handlerIP, true);
        } else {
            KnownIntrinsics.farReturn(exception, sp, handlerIP, false);
        }
    }
}

