/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
@Platforms(value={Platform.HOSTED_ONLY.class})
public class HostedStringDeduplication {
    private final ConcurrentMap<String, String> deduplicatedStrings = new ConcurrentHashMap<String, String>();

    public static HostedStringDeduplication singleton() {
        return (HostedStringDeduplication)ImageSingletons.lookup(HostedStringDeduplication.class);
    }

    HostedStringDeduplication() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String deduplicate(String s, boolean unintern) {
        String result;
        String lookup;
        if (s == null) {
            return null;
        }
        if (HostedStringDeduplication.isInternedString(s)) {
            if (!unintern) return s;
            lookup = new String(s);
        } else {
            lookup = s;
        }
        String previous = this.deduplicatedStrings.putIfAbsent(lookup, lookup);
        String string = result = previous != null ? previous : lookup;
        assert (!HostedStringDeduplication.isInternedString(result));
        return result;
    }

    @SuppressFBWarnings(value={"ES"}, justification="Reference equality check needed to detect intern status")
    public static boolean isInternedString(String str) {
        return new String(str).intern() == str;
    }
}

