/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.SnippetIntegerHistogram;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

final class DisableSnippetCountersPlugin
implements NodePlugin {
    private static final String snippetCounterName = "L" + SnippetCounter.class.getName().replace('.', '/') + ";";
    private static final String snippetIntegerHistogramName = "L" + SnippetIntegerHistogram.class.getName().replace('.', '/') + ";";

    DisableSnippetCountersPlugin() {
    }

    public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
        if (field.getName().equals("group") && field.getDeclaringClass().getName().equals(snippetCounterName)) {
            b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.NULL_POINTER, (MetaAccessProvider)b.getMetaAccess()));
            return true;
        }
        if (field.getType().getName().equals(snippetCounterName)) {
            b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject((Object)SnippetCounter.DISABLED_COUNTER), (MetaAccessProvider)b.getMetaAccess()));
            return true;
        }
        if (field.getType().getName().equals(snippetIntegerHistogramName)) {
            b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject((Object)SnippetIntegerHistogram.DISABLED_COUNTER), (MetaAccessProvider)b.getMetaAccess()));
            return true;
        }
        return false;
    }
}

