/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntryBase;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.EmbeddedResourcesInfo;
import com.oracle.svm.util.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.util.json.JsonPrinter;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class EmbeddedResourceExporter {
    public static void printReport(JsonWriter writer) throws IOException {
        JsonPrinter.printCollection((JsonWriter)writer, EmbeddedResourceExporter.getResourceReportEntryList(EmbeddedResourcesInfo.singleton().getRegisteredResources()), Comparator.comparing(ResourceReportEntry::resourceName), EmbeddedResourceExporter::resourceReportElement);
    }

    private static void resourceReportElement(ResourceReportEntry p, JsonWriter w) throws IOException {
        w.appendObjectStart();
        w.appendKeyValue("name", (Object)p.resourceName()).appendSeparator();
        if (p.module() != null) {
            w.appendKeyValue("module", (Object)p.module()).appendSeparator();
        }
        if (p.isDirectory()) {
            w.appendKeyValue("is_directory", (Object)true).appendSeparator();
        }
        if (p.isMissing()) {
            w.appendKeyValue("is_missing", (Object)true).appendSeparator();
        }
        w.quote("entries").appendFieldSeparator();
        JsonPrinter.printCollection((JsonWriter)w, p.entries(), Comparator.comparing(SourceSizePair::source), EmbeddedResourceExporter::sourceElement);
        w.appendObjectEnd();
    }

    private static void sourceElement(SourceSizePair p, JsonWriter w) throws IOException {
        w.appendObjectStart();
        w.appendKeyValue("origin", (Object)p.source()).appendSeparator();
        w.appendKeyValue("registration_origin", p.origin()).appendSeparator();
        w.appendKeyValue("size", (Object)p.size());
        w.appendObjectEnd();
    }

    public static List<ResourceReportEntry> getResourceReportEntryList(ConcurrentHashMap<Resources.ModuleResourceKey, List<EmbeddedResourcesInfo.SourceAndOrigin>> collection) {
        if (collection.isEmpty()) {
            LogUtils.warning((String)"Attempting to write information about resources without data being collected. Either the GenerateEmbeddedResourcesFile hosted option is disabled or the application doesn't have any resource registered");
            return Collections.emptyList();
        }
        ArrayList<ResourceReportEntry> resourceInfoList = new ArrayList<ResourceReportEntry>();
        Resources.currentLayer().forEachResource((key, value) -> {
            String module = key.getModuleName();
            String resourceName = key.resource();
            ResourceStorageEntryBase storageEntry = (ResourceStorageEntryBase)value.getValueUnconditionally();
            List registeredEntrySources = (List)collection.get(key);
            if (registeredEntrySources == null && storageEntry != Resources.NEGATIVE_QUERY_MARKER) {
                throw VMError.shouldNotReachHere("Resource: " + resourceName + " from module: " + module + " wasn't register from ResourcesFeature. It should never happen except for NEGATIVE_QUERIES in some cases");
            }
            if (storageEntry == Resources.NEGATIVE_QUERY_MARKER) {
                resourceInfoList.add(new ResourceReportEntry(module, resourceName, new ArrayList<SourceSizePair>(), false, true));
                return;
            }
            ArrayList<SourceSizePair> sources = new ArrayList<SourceSizePair>();
            for (int i = 0; i < registeredEntrySources.size(); ++i) {
                EmbeddedResourcesInfo.SourceAndOrigin sourceAndOrigin = (EmbeddedResourcesInfo.SourceAndOrigin)registeredEntrySources.get(i);
                int size = storageEntry.getData().get(i).length;
                sources.add(new SourceSizePair(sourceAndOrigin.source(), sourceAndOrigin.origin(), size));
            }
            boolean isDirectory = storageEntry.isDirectory();
            resourceInfoList.add(new ResourceReportEntry(module, resourceName, sources, isDirectory, false));
        });
        return resourceInfoList;
    }

    public record ResourceReportEntry(String module, String resourceName, List<SourceSizePair> entries, boolean isDirectory, boolean isMissing) {
    }

    public record SourceSizePair(String source, Object origin, int size) {
    }
}

