/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.NativeImageClassLoaderOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.DynamicAccessDetectionFeature;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageGeneratorRunner;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.driver.IncludeOptionsSupport;
import com.oracle.svm.hosted.image.PreserveOptionsSupport;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.option.HostedOptionParser;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.FindException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.internal.module.Modules;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.impl.AnnotationExtractor;
import org.graalvm.nativeimage.libgraal.hosted.LibGraalLoader;

public final class NativeImageClassLoaderSupport {
    public static final String ALL_UNNAMED = "ALL-UNNAMED";
    private final List<Path> imagecp;
    private final List<Path> buildcp;
    private final List<Path> imagemp;
    private final List<Path> buildmp;
    private final EconomicMap<URI, EconomicSet<String>> classes;
    private final EconomicMap<URI, EconomicSet<String>> packages;
    private final EconomicSet<String> emptySet;
    private final EconomicSet<URI> builderURILocations;
    private final ConcurrentHashMap<String, LinkedHashSet<String>> serviceProviders;
    private final NativeImageClassLoader classLoader;
    public final ModuleFinder upgradeAndSystemModuleFinder;
    public final ModuleLayer moduleLayerForImageBuild;
    public final ModuleFinder modulepathModuleFinder;
    public final AnnotationExtractor annotationExtractor;
    private Path layerFile;
    private final IncludeSelectors layerSelectors = new IncludeSelectors(SubstrateOptions.LayerCreate);
    private final IncludeSelectors preserveSelectors = new IncludeSelectors(SubstrateOptions.Preserve);
    private final IncludeSelectors dynamicAccessSelectors = new IncludeSelectors(SubstrateOptions.TrackDynamicAccess);
    private boolean includeConfigSealed;
    private LocatableMultiOptionValue.ValueWithOrigin<String> preserveAllOrigin;
    private final Set<Class<?>> classesToPreserve = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> classNamesToPreserve = Collections.newSetFromMap(new ConcurrentHashMap());
    private LoadClassHandler loadClassHandler;
    private Optional<LibGraalLoader> libGraalLoader;
    private List<ClassLoader> classLoaders;
    private final Set<Class<?>> classesToIncludeUnconditionally = ConcurrentHashMap.newKeySet();
    private final Set<String> includedJavaPackages = ConcurrentHashMap.newKeySet();
    private final Method implAddReadsAllUnnamed = ReflectionUtil.lookupMethod(Module.class, (String)"implAddReadsAllUnnamed", (Class[])new Class[0]);
    private final Method implAddEnableNativeAccess = ReflectionUtil.lookupMethod(Module.class, (String)"implAddEnableNativeAccess", (Class[])new Class[0]);
    private final Method implAddEnableNativeAccessToAllUnnamed = ReflectionUtil.lookupMethod(Module.class, (String)"implAddEnableNativeAccessToAllUnnamed", (Class[])new Class[0]);
    private HostedOptionParser hostedOptionParser;
    private OptionValues parsedHostedOptions;
    private List<String> remainingArguments;

    public void clearPreserveSelectors() {
        this.preserveSelectors.clear();
        this.preserveAllOrigin = null;
    }

    public void clearDynamicAccessSelectors() {
        this.dynamicAccessSelectors.clear();
    }

    public boolean isPreserveMode() {
        return !this.preserveSelectors.classpathEntries.isEmpty() || !this.preserveSelectors.moduleNames.isEmpty() || !this.preserveSelectors.packages.isEmpty() || this.isPreserveAll();
    }

    public boolean isPreserveAll() {
        return this.preserveAllOrigin().isPresent();
    }

    public Optional<LocatableMultiOptionValue.ValueWithOrigin<?>> preserveAllOrigin() {
        return Optional.ofNullable(this.preserveAllOrigin);
    }

    public Optional<LocatableMultiOptionValue.ValueWithOrigin<?>> preserveClassPathOrigin() {
        return Optional.ofNullable(this.preserveSelectors.preserveClassPathOrigin);
    }

    public IncludeSelectors getPreserveSelectors() {
        return this.preserveSelectors;
    }

    public IncludeSelectors getLayerSelectors() {
        return this.layerSelectors;
    }

    public IncludeSelectors getDynamicAccessSelectors() {
        return this.dynamicAccessSelectors;
    }

    public boolean dynamicAccessSelectorsEmpty() {
        return this.dynamicAccessSelectors.classpathEntries().isEmpty() && this.dynamicAccessSelectors.moduleNames().isEmpty() && this.dynamicAccessSelectors.packages().isEmpty();
    }

    protected NativeImageClassLoaderSupport(ClassLoader defaultSystemClassLoader, String[] classpath, String[] modulePath) {
        String[] builderClassPathEntries;
        this.classes = EconomicMap.create();
        this.packages = EconomicMap.create();
        this.emptySet = EconomicSet.create();
        this.builderURILocations = EconomicSet.create();
        this.serviceProviders = new ConcurrentHashMap();
        this.imagecp = Arrays.stream(classpath).map(x$0 -> Path.of(x$0, new String[0])).flatMap(NativeImageClassLoaderSupport::toRealPath).toList();
        String builderClassPathString = System.getProperty("java.class.path");
        String[] stringArray = builderClassPathEntries = builderClassPathString.isEmpty() ? new String[]{} : builderClassPathString.split(File.pathSeparator);
        if (Arrays.asList(builderClassPathEntries).contains(".")) {
            VMError.shouldNotReachHere("The classpath of " + NativeImageGeneratorRunner.class.getName() + " must not contain \".\". This can happen implicitly if the builder runs exclusively on the --module-path but specifies the " + NativeImageGeneratorRunner.class.getName() + " main class without --module.");
        }
        this.buildcp = Arrays.stream(builderClassPathEntries).map(x$0 -> Path.of(x$0, new String[0])).flatMap(NativeImageClassLoaderSupport::toRealPath).toList();
        this.buildcp.stream().map(Path::toUri).forEach(arg_0 -> this.builderURILocations.add(arg_0));
        this.imagemp = Arrays.stream(modulePath).map(x$0 -> Path.of(x$0, new String[0])).flatMap(NativeImageClassLoaderSupport::toRealPath).toList();
        this.buildmp = Optional.ofNullable(System.getProperty("jdk.module.path")).stream().flatMap(s -> Arrays.stream(s.split(File.pathSeparator))).map(x$0 -> Path.of(x$0, new String[0])).flatMap(NativeImageClassLoaderSupport::toRealPath).toList();
        this.upgradeAndSystemModuleFinder = NativeImageClassLoaderSupport.createUpgradeAndSystemModuleFinder();
        ModuleFinder modulePathsFinder = this.getModulePathsFinder();
        Set<String> moduleNames = modulePathsFinder.findAll().stream().map(moduleReference -> moduleReference.descriptor().name()).collect(Collectors.toSet());
        Configuration configuration = ModuleLayer.boot().configuration().resolve(modulePathsFinder, this.upgradeAndSystemModuleFinder, moduleNames);
        this.classLoader = new NativeImageClassLoader(this.imagecp, configuration, defaultSystemClassLoader);
        ModuleLayer moduleLayer = ModuleLayer.defineModules(configuration, List.of(ModuleLayer.boot()), ignored -> this.classLoader).layer();
        NativeImageClassLoaderSupport.adjustBootLayerQualifiedExports(moduleLayer);
        this.moduleLayerForImageBuild = moduleLayer;
        NativeImageClassLoaderSupport.allLayers(this.moduleLayerForImageBuild).stream().flatMap(layer -> layer.modules().stream()).forEach(this::registerModulePathServiceProviders);
        this.modulepathModuleFinder = ModuleFinder.of((Path[])this.modulepath().toArray(Path[]::new));
        this.annotationExtractor = new SubstrateAnnotationExtractor();
        this.includeConfigSealed = false;
    }

    private static Stream<Path> toRealPath(Path p) {
        try {
            return Stream.of(p.toRealPath(new LinkOption[0]));
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }

    List<Path> classpath() {
        return Stream.concat(this.imagecp.stream(), this.buildcp.stream()).distinct().collect(Collectors.toList());
    }

    List<Path> applicationClassPath() {
        return this.imagecp;
    }

    public NativeImageClassLoader getClassLoader() {
        return this.classLoader;
    }

    public LibGraalLoader getLibGraalLoader() {
        VMError.guarantee(this.libGraalLoader != null, "Invalid access to libGraalLoader before getting set up");
        return this.libGraalLoader.orElse(null);
    }

    public List<ClassLoader> getClassLoaders() {
        VMError.guarantee(this.classLoaders != null, "Invalid access to classLoaders before getting set up");
        return this.classLoaders;
    }

    private ModuleFinder getModulePathsFinder() {
        return ModuleFinder.of((Path[])this.imagemp.toArray(Path[]::new));
    }

    public void loadAllClasses(ForkJoinPool executor, ImageClassLoader imageClassLoader) {
        VMError.guarantee(!this.includeConfigSealed, "This method should be executed only once.");
        if (this.isPreserveAll()) {
            String msg = "This image build includes all classes from the classpath and the JDK via the %s option. This will lead to noticeably bigger images and increased startup times.\nIf you notice '--initialize-at-build-time' related errors during the build, this is because unanticipated types ended up in the image heap. The cause is one of the libraries on the classpath does not handle correctly when all elements are included in the image.\nIf this happens, please open an issue for the library whose field was containing forbidden types and correct the '--initialize-at-build-time' configuration for your build.\n".replaceAll("\n", System.lineSeparator()).formatted(SubstrateOptionsParser.commandArgument(SubstrateOptions.Preserve, "all"));
            LogUtils.warning((String)msg);
            IncludeOptionsSupport.ExtendedOptionWithOrigin origin = new IncludeOptionsSupport.ExtendedOptionWithOrigin(new IncludeOptionsSupport.ExtendedOption("", "all"), this.preserveAllOrigin);
            this.getModulePathsFinder().findAll().forEach(m -> this.preserveSelectors.addModule(m.descriptor().name(), origin));
            PreserveOptionsSupport.JDK_MODULES_TO_PRESERVE.forEach(moduleName -> this.preserveSelectors.addModule((String)moduleName, origin));
            this.preserveSelectors.addModule(ALL_UNNAMED, origin);
        }
        this.layerSelectors.verifyAndResolve();
        this.preserveSelectors.verifyAndResolve();
        this.dynamicAccessSelectors.verifyAndResolve();
        this.includeConfigSealed = true;
        this.loadClassHandler = new LoadClassHandler(executor, imageClassLoader);
        this.loadClassHandler.run();
        LibGraalLoader loader = this.getLibGraalLoader();
        if (loader != null) {
            for (String fqn : loader.getClassModuleMap().keySet()) {
                try {
                    Class<?> clazz = ((ClassLoader)loader).loadClass(fqn);
                    imageClassLoader.handleClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    throw GraalError.shouldNotReachHere((Throwable)e, (String)(String.valueOf(loader) + " could not load class " + fqn));
                }
            }
        }
    }

    private String createOptionStr(HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> option) {
        LocatableMultiOptionValue.ValueWithOrigin layerCreateValue = ((AccumulatingLocatableMultiOptionValue.Strings)option.getValue(this.getParsedHostedOptions())).lastValueWithOrigin().orElseThrow();
        String layerCreateArgument = SubstrateOptionsParser.commandArgument(option, (String)layerCreateValue.value());
        return "specified with '%s' from %s".formatted(layerCreateArgument, layerCreateValue.origin());
    }

    public void setupHostedOptionParser(List<String> arguments) {
        this.hostedOptionParser = new HostedOptionParser(this.getClassLoader(), arguments);
        SubstrateOptions.Optimize.update(this.hostedOptionParser.getHostedValues(), SubstrateOptions.Optimize.getDefaultValue());
        this.remainingArguments = Collections.unmodifiableList(this.hostedOptionParser.parse());
        EconomicMap<OptionKey<?>, Object> hostedValues = this.hostedOptionParser.getHostedValues();
        HostedImageLayerBuildingSupport.processLayerOptions(hostedValues, this);
        PreserveOptionsSupport.parsePreserveOption(hostedValues, this);
        DynamicAccessDetectionFeature.parseDynamicAccessOptions(hostedValues, this);
        this.parsedHostedOptions = new OptionValues(hostedValues);
    }

    public HostedOptionParser getHostedOptionParser() {
        return this.hostedOptionParser;
    }

    public List<String> getRemainingArguments() {
        return this.remainingArguments;
    }

    public OptionValues getParsedHostedOptions() {
        return this.parsedHostedOptions;
    }

    public EconomicSet<String> classes(URI container) {
        return (EconomicSet)this.classes.get((Object)container, this.emptySet);
    }

    public EconomicSet<String> packages(URI container) {
        return (EconomicSet)this.packages.get((Object)container, this.emptySet);
    }

    public boolean noEntryForURI(EconomicSet<String> set) {
        return set == this.emptySet;
    }

    private static ModuleFinder createUpgradeAndSystemModuleFinder() {
        ModuleFinder finder = ModuleFinder.ofSystem();
        ModuleFinder upgradeModulePath = NativeImageClassLoaderSupport.finderFor("jdk.module.upgrade.path");
        if (upgradeModulePath != null) {
            finder = ModuleFinder.compose(upgradeModulePath, finder);
        }
        return finder;
    }

    static ModuleFinder finderFor(String prop) {
        String s = System.getProperty(prop);
        if (s == null || s.isEmpty()) {
            return null;
        }
        String[] dirs = s.split(File.pathSeparator);
        Path[] paths = new Path[dirs.length];
        int i = 0;
        for (String dir : dirs) {
            paths[i++] = Path.of(dir, new String[0]);
        }
        return ModuleFinder.of(paths);
    }

    private static void adjustBootLayerQualifiedExports(ModuleLayer layer) {
        for (Module module : ModuleLayer.boot().modules()) {
            for (ModuleDescriptor.Exports export : module.getDescriptor().exports()) {
                for (String target : export.targets()) {
                    Optional<Module> optExportTargetModule = layer.findModule(target);
                    if (optExportTargetModule.isEmpty()) continue;
                    Module exportTargetModule = optExportTargetModule.get();
                    if (module.isExported(export.source(), exportTargetModule)) continue;
                    Modules.addExports(module, export.source(), exportTargetModule);
                }
            }
        }
    }

    private void registerModulePathServiceProviders(Module module) {
        ModuleDescriptor descriptor = module.getDescriptor();
        for (ModuleDescriptor.Provides provides : descriptor.provides()) {
            this.serviceProviders(provides.service()).addAll(provides.providers());
        }
    }

    private LinkedHashSet<String> serviceProviders(String serviceName) {
        return this.serviceProviders.computeIfAbsent(serviceName, unused -> new LinkedHashSet());
    }

    void serviceProvidersForEach(BiConsumer<String, Collection<String>> action) {
        this.serviceProviders.forEach((key, val) -> action.accept((String)key, Collections.unmodifiableCollection(val)));
    }

    protected List<Path> modulepath() {
        return Stream.concat(this.imagemp.stream(), this.buildmp.stream()).toList();
    }

    protected List<Path> applicationModulePath() {
        return this.imagemp;
    }

    public Optional<Module> findModule(String moduleName) {
        return this.moduleLayerForImageBuild.findModule(moduleName);
    }

    void processClassLoaderOptions() {
        if (((Boolean)NativeImageClassLoaderOptions.ListModules.getValue(this.parsedHostedOptions)).booleanValue()) {
            NativeImageClassLoaderSupport.processListModulesOption(this.moduleLayerForImageBuild);
        }
        this.processOption(NativeImageClassLoaderOptions.AddExports).forEach(val -> {
            if (val.module.getPackages().contains(val.packageName)) {
                if (val.targetModules.isEmpty()) {
                    Modules.addExportsToAllUnnamed(val.module, val.packageName);
                } else {
                    for (Module targetModule : val.targetModules) {
                        Modules.addExports(val.module, val.packageName, targetModule);
                    }
                }
            } else {
                NativeImageClassLoaderSupport.warn("package " + val.packageName + " not in " + val.module.getName());
            }
        });
        this.processOption(NativeImageClassLoaderOptions.AddOpens).forEach(val -> {
            if (val.module.getPackages().contains(val.packageName)) {
                if (val.targetModules.isEmpty()) {
                    Modules.addOpensToAllUnnamed(val.module, val.packageName);
                } else {
                    for (Module targetModule : val.targetModules) {
                        Modules.addOpens(val.module, val.packageName, targetModule);
                    }
                }
            } else {
                NativeImageClassLoaderSupport.warn("package " + val.packageName + " not in " + val.module.getName());
            }
        });
        this.processOption(NativeImageClassLoaderOptions.AddReads).forEach(val -> {
            if (val.targetModules.isEmpty()) {
                ReflectionUtil.invokeMethod((Method)this.implAddReadsAllUnnamed, (Object)val.module, (Object[])new Object[0]);
            } else {
                for (Module targetModule : val.targetModules) {
                    Modules.addReads(val.module, targetModule);
                }
            }
        });
        ((AccumulatingLocatableMultiOptionValue.Strings)NativeImageClassLoaderOptions.EnableNativeAccess.getValue(this.parsedHostedOptions)).values().stream().flatMap(m -> Arrays.stream(SubstrateUtil.split(m, ","))).forEach(moduleName -> {
            if (ALL_UNNAMED.equals(moduleName)) {
                ReflectionUtil.invokeMethod((Method)this.implAddEnableNativeAccessToAllUnnamed, null, (Object[])new Object[0]);
            } else {
                Module module = this.findModule((String)moduleName).orElseThrow(() -> NativeImageClassLoaderSupport.userWarningModuleNotFound(NativeImageClassLoaderOptions.EnableNativeAccess, moduleName));
                ReflectionUtil.invokeMethod((Method)this.implAddEnableNativeAccess, (Object)module, (Object[])new Object[0]);
            }
        });
    }

    private static void warn(String message) {
        System.err.println("WARNING: " + message);
    }

    private static void processListModulesOption(ModuleLayer layer) {
        Class launcherHelperClass = ReflectionUtil.lookupClass((boolean)false, (String)"sun.launcher.LauncherHelper");
        Method initOutputMethod = ReflectionUtil.lookupMethod((Class)launcherHelperClass, (String)"initOutput", (Class[])new Class[]{Boolean.TYPE});
        Method showModuleMethod = ReflectionUtil.lookupMethod((Class)launcherHelperClass, (String)"showModule", (Class[])new Class[]{ModuleReference.class});
        boolean first = true;
        for (ModuleLayer moduleLayer : NativeImageClassLoaderSupport.allLayers(layer)) {
            List<ResolvedModule> resolvedModules = moduleLayer.configuration().modules().stream().sorted(Comparator.comparing(ResolvedModule::name)).toList();
            if (first) {
                try {
                    initOutputMethod.invoke(null, false);
                }
                catch (ReflectiveOperationException e) {
                    throw VMError.shouldNotReachHere("Unable to use " + String.valueOf(initOutputMethod) + " to set printing with " + String.valueOf(showModuleMethod) + " to System.out.", e);
                }
                first = false;
            } else if (!resolvedModules.isEmpty()) {
                System.out.println();
            }
            for (ResolvedModule resolvedModule : resolvedModules) {
                try {
                    showModuleMethod.invoke(null, resolvedModule.reference());
                }
                catch (ReflectiveOperationException e) {
                    throw VMError.shouldNotReachHere("Unable to use " + String.valueOf(showModuleMethod) + " for printing list of modules.", e);
                }
            }
        }
        throw new InterruptImageBuilding("");
    }

    public void propagateQualifiedExports(String fromTargetModule, String toTargetModule) {
        Optional<Module> optFromTarget = this.moduleLayerForImageBuild.findModule(fromTargetModule);
        Optional<Module> optToTarget = this.moduleLayerForImageBuild.findModule(toTargetModule);
        VMError.guarantee(optFromTarget.isPresent() && optToTarget.isPresent());
        Module toTarget = optToTarget.get();
        Module fromTarget = optFromTarget.get();
        NativeImageClassLoaderSupport.allLayers(this.moduleLayerForImageBuild).stream().flatMap(layer -> layer.modules().stream()).forEach(m -> {
            if (!m.equals(toTarget)) {
                for (String p : m.getPackages()) {
                    if (m.isExported(p, fromTarget)) {
                        Modules.addExports(m, p, toTarget);
                    }
                    if (!m.isOpen(p, fromTarget)) continue;
                    Modules.addOpens(m, p, toTarget);
                }
            }
        });
    }

    public static List<ModuleLayer> allLayers(ModuleLayer moduleLayer) {
        ArrayList<ModuleLayer> allLayers = new ArrayList<ModuleLayer>();
        HashSet<ModuleLayer> visited = new HashSet<ModuleLayer>();
        ArrayDeque<ModuleLayer> stack = new ArrayDeque<ModuleLayer>();
        visited.add(moduleLayer);
        stack.push(moduleLayer);
        while (!stack.isEmpty()) {
            ModuleLayer layer = (ModuleLayer)stack.pop();
            allLayers.add(layer);
            for (int i = layer.parents().size() - 1; i >= 0; --i) {
                ModuleLayer parent = layer.parents().get(i);
                if (visited.contains(parent)) continue;
                visited.add(parent);
                stack.push(parent);
            }
        }
        return allLayers;
    }

    private Stream<AddExportsAndOpensAndReadsFormatValue> processOption(OptionKey<AccumulatingLocatableMultiOptionValue.Strings> specificOption) {
        Stream<LocatableMultiOptionValue.ValueWithOrigin<LocatableMultiOptionValue.ValueWithOrigin>> valuesWithOrigins = ((AccumulatingLocatableMultiOptionValue.Strings)specificOption.getValue(this.parsedHostedOptions)).getValuesWithOrigins();
        return valuesWithOrigins.flatMap(valWithOrig -> {
            try {
                return Stream.of(this.asAddExportsAndOpensAndReadsFormatValue(specificOption, (LocatableMultiOptionValue.ValueWithOrigin<String>)valWithOrig));
            }
            catch (FindException e) {
                NativeImageClassLoaderSupport.warn(e.getMessage());
                return Stream.empty();
            }
        });
    }

    public void setupLibGraalClassLoader() {
        String className = (String)SubstrateOptions.LibGraalClassLoader.getValue(this.parsedHostedOptions);
        if (!className.isEmpty()) {
            String nameOption = SubstrateOptionsParser.commandArgument(SubstrateOptions.LibGraalClassLoader, className);
            try {
                Class<?> loaderClass = Class.forName(className, true, this.classLoader);
                if (!LibGraalLoader.class.isAssignableFrom(loaderClass)) {
                    throw VMError.shouldNotReachHere("Class named by " + nameOption + " does not implement " + String.valueOf(LibGraalLoader.class) + ".");
                }
                this.libGraalLoader = Optional.of((LibGraalLoader)ReflectionUtil.newInstance(loaderClass));
                this.classLoaders = List.of((ClassLoader)this.libGraalLoader.get(), this.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw VMError.shouldNotReachHere("Class named by " + nameOption + " could not be found.", e);
            }
        } else {
            this.libGraalLoader = Optional.empty();
            this.classLoaders = List.of(this.getClassLoader());
        }
    }

    public void allClassesLoaded() {
        if (this.loadClassHandler != null) {
            this.loadClassHandler.validatePackageInclusionRequests(this.loadClassHandler.includePackages, SubstrateOptions.LayerCreate);
            this.loadClassHandler.validatePackageInclusionRequests(this.loadClassHandler.preservePackages, SubstrateOptions.Preserve);
            this.loadClassHandler = null;
        }
        this.reportBuilderClassesInApplication();
    }

    public Path getLayerFile() {
        return this.layerFile;
    }

    public void setLayerFile(Path layerFile) {
        this.layerFile = layerFile;
    }

    private AddExportsAndOpensAndReadsFormatValue asAddExportsAndOpensAndReadsFormatValue(OptionKey<?> option, LocatableMultiOptionValue.ValueWithOrigin<String> valueOrigin) {
        String packageName;
        String moduleName;
        OptionOrigin optionOrigin = valueOrigin.origin();
        String optionValue = valueOrigin.value();
        boolean reads = option.equals(NativeImageClassLoaderOptions.AddReads);
        String format = reads ? "<module>=<target-module>(,<target-module>)*" : "<module>/<package>=<target-module>(,<target-module>)*";
        String syntaxErrorMessage = " Allowed value format: " + format;
        int equalsPos = optionValue.indexOf("=");
        if (equalsPos <= 0) {
            throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
        }
        String modulePackage = optionValue.substring(0, equalsPos);
        String targetModuleNames = optionValue.substring(equalsPos + 1);
        if (targetModuleNames.isEmpty()) {
            throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
        }
        ArrayList<String> targetModuleNamesList = new ArrayList<String>();
        for (String s : targetModuleNames.split(",")) {
            if (s.isEmpty()) continue;
            targetModuleNamesList.add(s);
        }
        if (targetModuleNamesList.isEmpty()) {
            throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
        }
        if (reads) {
            moduleName = modulePackage;
            packageName = null;
        } else {
            String[] moduleAndPackage = modulePackage.split("/");
            if (moduleAndPackage.length != 2) {
                throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
            }
            moduleName = moduleAndPackage[0];
            packageName = moduleAndPackage[1];
            if (moduleName.isEmpty() || packageName.isEmpty()) {
                throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
            }
        }
        Module module = this.findModule(moduleName).orElseThrow(() -> {
            throw NativeImageClassLoaderSupport.userWarningModuleNotFound(option, moduleName);
        });
        List<Module> targetModules = targetModuleNamesList.contains(ALL_UNNAMED) ? Collections.emptyList() : targetModuleNamesList.stream().map(mn -> this.findModule((String)mn).orElseThrow(() -> NativeImageClassLoaderSupport.userWarningModuleNotFound(option, mn))).collect(Collectors.toList());
        return new AddExportsAndOpensAndReadsFormatValue(module, packageName, targetModules);
    }

    private static UserError.UserException userErrorAddExportsAndOpensAndReads(OptionKey<?> option, OptionOrigin origin, String value, String detailMessage) {
        Objects.requireNonNull(detailMessage, "missing detailMessage");
        return UserError.abort("Invalid option %s provided by %s.%s", SubstrateOptionsParser.commandArgument(option, value), origin, detailMessage);
    }

    private static FindException userWarningModuleNotFound(OptionKey<?> option, String moduleName) {
        String optionName = SubstrateOptionsParser.commandArgument(option, "");
        return new FindException("Unknown module: " + moduleName + " specified to " + optionName);
    }

    Class<?> loadClassFromModule(Module module, String className) {
        assert (NativeImageClassLoaderSupport.isModuleClassLoader(this.classLoader, module.getClassLoader())) : "Argument `module` is java.lang.Module from unknown ClassLoader";
        return Class.forName(module, className);
    }

    private static boolean isModuleClassLoader(ClassLoader loader, ClassLoader moduleClassLoader) {
        if (moduleClassLoader == loader) {
            return true;
        }
        if (loader == null) {
            return false;
        }
        return NativeImageClassLoaderSupport.isModuleClassLoader(loader.getParent(), moduleClassLoader);
    }

    static Optional<String> getMainClassFromModule(Object module) {
        assert (module instanceof Module) : "Argument `module` is not an instance of java.lang.Module";
        return ((Module)module).getDescriptor().mainClass();
    }

    private static String packageName(String className) {
        int packageSep = className.lastIndexOf(46);
        return packageSep > 0 ? className.substring(0, packageSep) : "";
    }

    public void reportBuilderClassesInApplication() {
        EconomicMap builderClasses = EconomicMap.create();
        EconomicMap applicationClasses = EconomicMap.create();
        MapCursor classesEntries = this.classes.getEntries();
        while (classesEntries.advance()) {
            EconomicMap destinationMap = this.builderURILocations.contains((Object)((URI)classesEntries.getKey())) ? builderClasses : applicationClasses;
            destinationMap.put((Object)((URI)classesEntries.getKey()), (Object)((EconomicSet)classesEntries.getValue()));
        }
        boolean tolerateViolations = (Boolean)SubstrateOptions.AllowDeprecatedBuilderClassesOnImageClasspath.getValue(this.parsedHostedOptions);
        MapCursor applicationClassesEntries = applicationClasses.getEntries();
        while (applicationClassesEntries.advance()) {
            URI applicationClassContainer = (URI)applicationClassesEntries.getKey();
            for (String applicationClass : (EconomicSet)applicationClassesEntries.getValue()) {
                MapCursor builderClassesEntries = builderClasses.getEntries();
                while (builderClassesEntries.advance()) {
                    URI builderClassContainer = (URI)builderClassesEntries.getKey();
                    if (!((EconomicSet)builderClassesEntries.getValue()).contains((Object)applicationClass)) continue;
                    String message = String.format("Class-path entry %s contains class %s. This class is part of the image builder itself (in %s) and must not be passed via -cp.", applicationClassContainer, applicationClass, builderClassContainer);
                    if (!tolerateViolations) {
                        String errorMessage = String.join((CharSequence)" ", message, "This can be caused by a fat-jar that illegally includes svm.jar (or graal-sdk.jar) due to its build-time dependency on it.", "As a workaround, %s allows turning this error into a warning. Note that this option is deprecated and will be removed in a future version.");
                        throw UserError.abort(errorMessage, SubstrateOptionsParser.commandArgument(SubstrateOptions.AllowDeprecatedBuilderClassesOnImageClasspath, "+"));
                    }
                    LogUtils.warning((String)message);
                }
            }
        }
    }

    public Set<String> getJavaModuleNamesToInclude() {
        return this.layerSelectors.moduleNames();
    }

    public Set<String> getJavaModuleNamesToPreserve() {
        return this.preserveSelectors.moduleNames();
    }

    public Set<Path> getJavaPathsToInclude() {
        return this.layerSelectors.classpathEntries();
    }

    public Set<Path> getClassPathEntriesToPreserve() {
        return this.preserveSelectors.classpathEntries();
    }

    public Set<String> getClassNamesToPreserve() {
        return Collections.unmodifiableSet(this.classNamesToPreserve);
    }

    public void setPreserveAll(LocatableMultiOptionValue.ValueWithOrigin<String> valueWithOrigin) {
        this.preserveAllOrigin = valueWithOrigin;
    }

    public void setTrackAllDynamicAccess(LocatableMultiOptionValue.ValueWithOrigin<String> valueWithOrigin) {
        IncludeOptionsSupport.ExtendedOptionWithOrigin origin = new IncludeOptionsSupport.ExtendedOptionWithOrigin(new IncludeOptionsSupport.ExtendedOption("", "all"), valueWithOrigin);
        this.getModulePathsFinder().findAll().forEach(m -> this.dynamicAccessSelectors.addModule(m.descriptor().name(), origin));
        this.dynamicAccessSelectors.addModule(ALL_UNNAMED, origin);
    }

    public Stream<Class<?>> getClassesToIncludeUnconditionally() {
        return this.classesToIncludeUnconditionally.stream().sorted(Comparator.comparing(Class::getTypeName));
    }

    public Stream<Class<?>> getClassesToPreserve() {
        return this.classesToPreserve.stream().sorted(Comparator.comparing(Class::getTypeName));
    }

    public class IncludeSelectors {
        private static final String CLASS_INCLUSION_SEALED_MSG = "Class inclusion configuration is already sealed.";
        private LocatableMultiOptionValue.ValueWithOrigin<?> preserveClassPathOrigin;
        private final Map<String, IncludeOptionsSupport.ExtendedOptionWithOrigin> moduleNames = new LinkedHashMap<String, IncludeOptionsSupport.ExtendedOptionWithOrigin>();
        private final Map<IncludeOptionsSupport.PackageOptionValue, IncludeOptionsSupport.ExtendedOptionWithOrigin> packages = new LinkedHashMap<IncludeOptionsSupport.PackageOptionValue, IncludeOptionsSupport.ExtendedOptionWithOrigin>();
        private final Map<Path, IncludeOptionsSupport.ExtendedOptionWithOrigin> classpathEntries = new LinkedHashMap<Path, IncludeOptionsSupport.ExtendedOptionWithOrigin>();
        private final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> option;

        public IncludeSelectors(HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> option) {
            this.option = option;
        }

        public void verifyAndResolve() {
            this.verifyAllRequestedModulesPresent();
            this.verifyClasspathEntriesPresentAndResolve();
        }

        private void verifyClasspathEntriesPresentAndResolve() {
            HashSet resolvedJavaPathsToInclude = new HashSet();
            ArrayList missingClassPathEntries = new ArrayList();
            this.classpathEntries.keySet().forEach(requestedCPEntry -> {
                Optional<Path> optResolvedEntry = NativeImageClassLoaderSupport.toRealPath(requestedCPEntry).findAny();
                if (optResolvedEntry.isPresent()) {
                    Path resolvedEntry = optResolvedEntry.get();
                    if (NativeImageClassLoaderSupport.this.applicationClassPath().contains(resolvedEntry)) {
                        resolvedJavaPathsToInclude.add(resolvedEntry);
                        return;
                    }
                }
                missingClassPathEntries.add(requestedCPEntry.toString());
            });
            if (!missingClassPathEntries.isEmpty()) {
                boolean plural = missingClassPathEntries.size() > 1;
                String pluralS = plural ? "s" : "";
                String pluralEntries = plural ? "entries" : "entry";
                Object msg = String.format("Class-path entry request%s (path=...) %s do not match the application class-path %s. Provide a class-path that contains the %s or remove %s from option.", pluralS, String.join((CharSequence)", ", missingClassPathEntries), pluralEntries, pluralEntries, pluralEntries);
                String listOfOptions = missingClassPathEntries.stream().map(x$0 -> Path.of(x$0, new String[0])).map(this.classpathEntries::get).map(this::originatingOptionString).distinct().collect(IncludeSelectors.singleOrMultiLine(plural));
                msg = (String)msg + String.format(" The missing classpath entries were requested in the following option%s: %s", pluralS, listOfOptions);
                throw UserError.abort((String)msg, new Object[0]);
            }
            this.classpathEntries.clear();
            for (Path path : resolvedJavaPathsToInclude) {
                this.classpathEntries.put(path, null);
            }
        }

        private static Collector<CharSequence, ?, String> singleOrMultiLine(boolean plural) {
            if (plural) {
                String indentation = "  ";
                return Collectors.joining(System.lineSeparator() + indentation, System.lineSeparator() + indentation, "");
            }
            return Collectors.joining(", ");
        }

        private void verifyAllRequestedModulesPresent() {
            List<Map.Entry> missingModules = this.moduleNames.entrySet().stream().filter(e -> NativeImageClassLoaderSupport.this.findModule((String)e.getKey()).isEmpty()).toList();
            if (!missingModules.isEmpty()) {
                boolean plural = missingModules.size() > 1;
                String pluralS = plural ? "s" : "";
                String listOfModules = missingModules.stream().map(Map.Entry::getKey).collect(Collectors.joining(", "));
                Object msg = String.format("Module request%s (module=...) %s could not find requested module%s. Provide a module-path that contains the specified module%s or remove %s from option.", pluralS, listOfModules, pluralS, pluralS, plural ? "entries" : "entry");
                String listOfOptions = missingModules.stream().map(Map.Entry::getValue).map(this::originatingOptionString).distinct().collect(IncludeSelectors.singleOrMultiLine(plural));
                msg = (String)msg + String.format(" The missing modules were requested in the following option%s: %s", pluralS, listOfOptions);
                throw UserError.abort((String)msg, new Object[0]);
            }
        }

        private String originatingOptionString(IncludeOptionsSupport.ExtendedOptionWithOrigin v) {
            return SubstrateOptionsParser.commandArgument(this.option, v.valueWithOrigin().value().toString()) + " from " + String.valueOf(v.valueWithOrigin().origin());
        }

        public void addModule(String moduleName, IncludeOptionsSupport.ExtendedOptionWithOrigin extendedOptionWithOrigin) {
            VMError.guarantee(!NativeImageClassLoaderSupport.this.includeConfigSealed, CLASS_INCLUSION_SEALED_MSG);
            if (moduleName.equals(NativeImageClassLoaderSupport.ALL_UNNAMED)) {
                this.preserveClassPathOrigin = extendedOptionWithOrigin.valueWithOrigin();
                IncludeOptionsSupport.ExtendedOptionWithOrigin includeOptionsSupport = new IncludeOptionsSupport.ExtendedOptionWithOrigin(extendedOptionWithOrigin.option(), extendedOptionWithOrigin.valueWithOrigin());
                for (Path path : NativeImageClassLoaderSupport.this.applicationClassPath()) {
                    this.classpathEntries.put(path, includeOptionsSupport);
                }
            } else {
                this.moduleNames.put(moduleName, extendedOptionWithOrigin);
            }
        }

        public void addPackage(IncludeOptionsSupport.PackageOptionValue packageOptionValue) {
            VMError.guarantee(!NativeImageClassLoaderSupport.this.includeConfigSealed, CLASS_INCLUSION_SEALED_MSG);
            this.packages.put(packageOptionValue, null);
        }

        public void addClassPathEntry(String cpEntry, IncludeOptionsSupport.ExtendedOptionWithOrigin extendedOptionWithOrigin) {
            VMError.guarantee(!NativeImageClassLoaderSupport.this.includeConfigSealed, CLASS_INCLUSION_SEALED_MSG);
            this.classpathEntries.put(Path.of(cpEntry, new String[0]), extendedOptionWithOrigin);
        }

        public void clear() {
            this.packages.clear();
            this.moduleNames.clear();
            this.classpathEntries.clear();
            this.preserveClassPathOrigin = null;
        }

        public Set<Path> classpathEntries() {
            return this.classpathEntries.keySet();
        }

        public Set<String> moduleNames() {
            return this.moduleNames.keySet();
        }

        public Set<IncludeOptionsSupport.PackageOptionValue> packages() {
            return this.packages.keySet();
        }
    }

    private final class LoadClassHandler {
        private final ForkJoinPool executor;
        private final ImageClassLoader imageClassLoader;
        LongAdder entriesProcessed;
        volatile String currentlyProcessedEntry;
        boolean initialReport;
        PackageRequest includePackages;
        PackageRequest preservePackages;
        private static final String CLASS_EXTENSION = ".class";
        private static final String SERVICE_PREFIX = "META-INF/services/";
        private static final String SERVICE_PREFIX_VARIANT = File.separatorChar == '/' ? null : "META-INF/services/".replace('/', File.separatorChar);

        private LoadClassHandler(ForkJoinPool executor, ImageClassLoader imageClassLoader) {
            this.executor = executor;
            this.imageClassLoader = imageClassLoader;
            this.entriesProcessed = new LongAdder();
            this.currentlyProcessedEntry = "Unknown Entry";
            this.initialReport = true;
            this.includePackages = PackageRequest.create(NativeImageClassLoaderSupport.this.layerSelectors.packages.keySet());
            this.preservePackages = PackageRequest.create(NativeImageClassLoaderSupport.this.preserveSelectors.packages.keySet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            try {
                scheduledExecutor.scheduleAtFixedRate(() -> {
                    if (this.initialReport) {
                        this.initialReport = false;
                        System.out.println("Loading classes is taking a long time. This can be caused by class- or module-path entries that point to large directory structures.");
                    }
                    System.out.println("Total processed entries: " + this.entriesProcessed.longValue() + ", current entry: " + this.currentlyProcessedEntry);
                }, 5L, 1L, TimeUnit.MINUTES);
                HashSet<String> requiresInit = new HashSet<String>(List.of("jdk.internal.vm.ci", "jdk.graal.compiler", "com.oracle.graal.graal_enterprise", "org.graalvm.nativeimage", "org.graalvm.truffle", "org.graalvm.truffle.runtime", "org.graalvm.truffle.compiler", "com.oracle.truffle.enterprise", "org.graalvm.jniutils", "org.graalvm.nativebridge"));
                Set additionalSystemModules = NativeImageClassLoaderSupport.this.upgradeAndSystemModuleFinder.findAll().stream().map(v -> v.descriptor().name()).filter(n -> NativeImageClassLoaderSupport.this.getJavaModuleNamesToInclude().contains(n) || NativeImageClassLoaderSupport.this.getJavaModuleNamesToPreserve().contains(n)).collect(Collectors.toSet());
                requiresInit.addAll(additionalSystemModules);
                Set explicitlyAddedModules = ModuleSupport.parseModuleSetModifierProperty((String)"svm.modulesupport.addedModules");
                for (ModuleReference moduleReference : NativeImageClassLoaderSupport.this.upgradeAndSystemModuleFinder.findAll()) {
                    String moduleName = moduleReference.descriptor().name();
                    boolean moduleRequiresInit = requiresInit.contains(moduleName);
                    if (!moduleRequiresInit && !explicitlyAddedModules.contains(moduleName)) continue;
                    this.initModule(moduleReference, moduleRequiresInit);
                }
                for (ModuleReference moduleReference : NativeImageClassLoaderSupport.this.modulepathModuleFinder.findAll()) {
                    this.initModule(moduleReference, true);
                }
                NativeImageClassLoaderSupport.this.classpath().forEach(this::loadClassesFromPath);
            }
            finally {
                scheduledExecutor.shutdown();
            }
        }

        void validatePackageInclusionRequests(PackageRequest request, HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> optionString) {
            ArrayList<IncludeOptionsSupport.PackageOptionValue> unusedRequests = new ArrayList<IncludeOptionsSupport.PackageOptionValue>();
            for (String string : request.requestedPackages) {
                if (NativeImageClassLoaderSupport.this.includedJavaPackages.contains(string)) continue;
                unusedRequests.add(new IncludeOptionsSupport.PackageOptionValue(string, false));
            }
            LinkedHashSet<IncludeOptionsSupport.PackageOptionValue> unusedWildcardRequests = new LinkedHashSet<IncludeOptionsSupport.PackageOptionValue>(request.requestedPackageWildcards);
            if (!unusedWildcardRequests.isEmpty()) {
                for (String includedPackage : NativeImageClassLoaderSupport.this.includedJavaPackages) {
                    unusedWildcardRequests.removeIf(wildcardRequest -> includedPackage.startsWith(wildcardRequest.name()));
                }
            }
            if (!unusedRequests.isEmpty() || !unusedWildcardRequests.isEmpty()) {
                List<String> list = Stream.concat(unusedRequests.stream(), unusedWildcardRequests.stream()).map(packageOptionValue -> "'" + packageOptionValue.toString() + "'").toList();
                boolean plural = list.size() > 1;
                String pluralS = plural ? "s" : "";
                throw UserError.abort("Package request%s (package=...) %s %s could not find requested package%s. Provide a class/module-path that contains the package%s or remove %s from option.", pluralS, String.join((CharSequence)", ", list), NativeImageClassLoaderSupport.this.createOptionStr(optionString), pluralS, pluralS, plural ? "entries" : "entry");
            }
        }

        private void initModule(ModuleReference moduleReference, boolean moduleRequiresInit) {
            String moduleReferenceLocation;
            this.currentlyProcessedEntry = moduleReferenceLocation = moduleReference.location().map(URI::toString).orElse("UnknownModuleReferenceLocation");
            Optional<Module> optionalModule = NativeImageClassLoaderSupport.this.findModule(moduleReference.descriptor().name());
            if (optionalModule.isEmpty()) {
                return;
            }
            try (ModuleReader moduleReader = moduleReference.open();){
                Module module = optionalModule.get();
                boolean includeUnconditionally = NativeImageClassLoaderSupport.this.layerSelectors.moduleNames().contains(module.getName());
                boolean preserveModule = NativeImageClassLoaderSupport.this.preserveSelectors.moduleNames().contains(module.getName());
                URI container = moduleReference.location().orElseThrow();
                if (ModuleLayer.boot().equals(module.getLayer())) {
                    NativeImageClassLoaderSupport.this.builderURILocations.add((Object)container);
                }
                moduleReader.list().forEach(moduleResource -> {
                    char fileSystemSeparatorChar = '/';
                    String className = this.extractClassName((String)moduleResource, fileSystemSeparatorChar);
                    if (className != null) {
                        this.currentlyProcessedEntry = moduleReferenceLocation + fileSystemSeparatorChar + moduleResource;
                        this.executor.execute(() -> this.handleClassFileName(container, module, className, includeUnconditionally, moduleRequiresInit, preserveModule));
                    }
                    this.entriesProcessed.increment();
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Unable get list of resources in module" + moduleReference.descriptor().name(), e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void loadClassesFromPath(Path path) {
            boolean includeUnconditionally = NativeImageClassLoaderSupport.this.layerSelectors.classpathEntries().contains(path);
            boolean includeAllMetadata = NativeImageClassLoaderSupport.this.preserveSelectors.classpathEntries().contains(path);
            if (ClasspathUtils.isJar(path)) {
                try {
                    FileSystem probeJarFileSystem;
                    URI container = path.toAbsolutePath().toUri();
                    URI jarURI = new URI("jar:" + String.valueOf(container));
                    try {
                        probeJarFileSystem = FileSystems.newFileSystem(jarURI, Collections.emptyMap());
                    }
                    catch (UnsupportedOperationException e) {
                        return;
                    }
                    if (probeJarFileSystem == null) return;
                    try (FileSystem jarFileSystem = probeJarFileSystem;){
                        this.loadClassesFromPath(container, jarFileSystem.getPath("/", new String[0]), null, Collections.emptySet(), includeUnconditionally, includeAllMetadata);
                        return;
                    }
                }
                catch (ClosedByInterruptException ignored) {
                    throw new InterruptImageBuilding();
                }
                catch (IOException | URISyntaxException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            URI container = path.toUri();
            this.loadClassesFromPath(container, path, ClassUtil.CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES_ROOT, ClassUtil.CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES, includeUnconditionally, includeAllMetadata);
        }

        private void loadClassesFromPath(final URI container, final Path root, Path excludeRoot, final Set<Path> excludes, final boolean includeUnconditionally, final boolean includeAllMetadata) {
            final boolean useFilter = root.equals(excludeRoot);
            if (useFilter) {
                String excludesStr = excludes.stream().map(Path::toString).collect(Collectors.joining(", "));
                LogUtils.warning((String)"Using directory %s on classpath is discouraged. Reading classes/resources from directories %s will be suppressed.", (Object[])new Object[]{excludeRoot, excludesStr});
            }
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(this){
                private final char fileSystemSeparatorChar;
                final /* synthetic */ LoadClassHandler this$1;
                {
                    this.this$1 = this$1;
                    this.fileSystemSeparatorChar = root.getFileSystem().getSeparator().charAt(0);
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    this.this$1.currentlyProcessedEntry = dir.toUri().toString();
                    if (useFilter && excludes.contains(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    assert (!excludes.contains(file.getParent())) : "Visiting file '" + String.valueOf(file) + "' with excluded parent directory";
                    String fileName = root.relativize(file).toString();
                    this.this$1.registerClassPathServiceProviders(fileName, file);
                    String className = this.this$1.extractClassName(fileName, this.fileSystemSeparatorChar);
                    if (className != null) {
                        this.this$1.currentlyProcessedEntry = file.toUri().toString();
                        this.this$1.executor.execute(() -> this.this$1.handleClassFileName(container, null, className, includeUnconditionally, true, includeAllMetadata));
                    }
                    this.this$1.entriesProcessed.increment();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerClassPathServiceProviders(String fileName, Path serviceRegistrationFile) {
            boolean found;
            boolean bl = found = fileName.startsWith(SERVICE_PREFIX) || SERVICE_PREFIX_VARIANT != null && fileName.startsWith(SERVICE_PREFIX_VARIANT);
            if (!found) {
                return;
            }
            Path serviceFileName = serviceRegistrationFile.getFileName();
            if (serviceFileName == null) {
                return;
            }
            String serviceName = serviceFileName.toString();
            if (!serviceName.isEmpty()) {
                ArrayList providerNames = new ArrayList();
                try (Stream<String> serviceConfig = Files.lines(serviceRegistrationFile);){
                    serviceConfig.forEach(ln -> {
                        int ci = ln.indexOf(35);
                        String providerName = (ci >= 0 ? ln.substring(0, ci) : ln).trim();
                        if (!providerName.isEmpty()) {
                            providerNames.add(providerName);
                        }
                    });
                }
                catch (Exception e) {
                    LogUtils.warning((String)("Image builder cannot read service configuration file " + fileName));
                }
                if (!providerNames.isEmpty()) {
                    LinkedHashSet<String> providersForService;
                    LinkedHashSet<String> linkedHashSet = providersForService = NativeImageClassLoaderSupport.this.serviceProviders(serviceName);
                    synchronized (linkedHashSet) {
                        providersForService.addAll(providerNames);
                    }
                }
            }
        }

        private String extractClassName(String fileName, char fileSystemSeparatorChar) {
            String strippedClassFileName;
            int versionedSuffixIndex;
            if (!fileName.endsWith(CLASS_EXTENSION)) {
                return null;
            }
            String versionedPrefix = "META-INF/versions/";
            String versionedSuffix = "/";
            String result = fileName;
            if (fileName.startsWith(versionedPrefix) && (versionedSuffixIndex = fileName.indexOf(versionedSuffix, versionedPrefix.length())) >= 0) {
                result = fileName.substring(versionedSuffixIndex + versionedSuffix.length());
            }
            return (strippedClassFileName = result.substring(0, result.length() - CLASS_EXTENSION.length())).equals("module-info") ? null : strippedClassFileName.replace(fileSystemSeparatorChar, '.');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleClassFileName(URI container, Module module, String className, boolean includeUnconditionally, boolean classRequiresInit, boolean preserveReflectionMetadata) {
            if (classRequiresInit) {
                EconomicMap<URI, EconomicSet<String>> economicMap = NativeImageClassLoaderSupport.this.classes;
                synchronized (economicMap) {
                    EconomicSet classNames = (EconomicSet)NativeImageClassLoaderSupport.this.classes.get((Object)container);
                    if (classNames == null) {
                        classNames = EconomicSet.create();
                        NativeImageClassLoaderSupport.this.classes.put((Object)container, (Object)classNames);
                    }
                    classNames.add((Object)className);
                }
                economicMap = NativeImageClassLoaderSupport.this.packages;
                synchronized (economicMap) {
                    EconomicSet packageNames = (EconomicSet)NativeImageClassLoaderSupport.this.packages.get((Object)container);
                    if (packageNames == null) {
                        packageNames = EconomicSet.create();
                        NativeImageClassLoaderSupport.this.packages.put((Object)container, (Object)packageNames);
                    }
                    packageNames.add((Object)NativeImageClassLoaderSupport.packageName(className));
                }
            }
            Class<?> clazz = null;
            try {
                clazz = this.imageClassLoader.forName(className, module);
            }
            catch (AssertionError error) {
                VMError.shouldNotReachHere((Throwable)((Object)error));
            }
            catch (Throwable t) {
                if (preserveReflectionMetadata) {
                    NativeImageClassLoaderSupport.this.classNamesToPreserve.add(className);
                }
                ImageClassLoader.handleClassLoadingError(t);
            }
            if (clazz != null) {
                String packageName = clazz.getPackageName();
                NativeImageClassLoaderSupport.this.includedJavaPackages.add(packageName);
                if (includeUnconditionally || this.includePackages.shouldInclude(packageName)) {
                    NativeImageClassLoaderSupport.this.classesToIncludeUnconditionally.add(clazz);
                }
                if (classRequiresInit) {
                    this.imageClassLoader.handleClass(clazz);
                }
                if (preserveReflectionMetadata || this.preservePackages.shouldInclude(packageName)) {
                    NativeImageClassLoaderSupport.this.classesToPreserve.add(clazz);
                }
            }
            this.imageClassLoader.watchdog.recordActivity();
        }

        record PackageRequest(Set<String> requestedPackages, List<IncludeOptionsSupport.PackageOptionValue> requestedPackageWildcards) {
            public static PackageRequest create(Set<IncludeOptionsSupport.PackageOptionValue> javaPackagesToInclude) {
                LinkedHashSet<String> tempRequestedPackages = new LinkedHashSet<String>();
                ArrayList<IncludeOptionsSupport.PackageOptionValue> tempRequestedPackageWildcards = new ArrayList<IncludeOptionsSupport.PackageOptionValue>();
                for (IncludeOptionsSupport.PackageOptionValue value : javaPackagesToInclude) {
                    if (value.isWildcard()) {
                        tempRequestedPackageWildcards.add(value);
                        continue;
                    }
                    tempRequestedPackages.add(value.name());
                }
                return new PackageRequest(Collections.unmodifiableSet(tempRequestedPackages), List.copyOf(tempRequestedPackageWildcards));
            }

            public boolean shouldInclude(String packageName) {
                if (this.requestedPackages.contains(packageName)) {
                    return true;
                }
                for (IncludeOptionsSupport.PackageOptionValue requestedPackageWildcard : this.requestedPackageWildcards) {
                    if (!packageName.startsWith(requestedPackageWildcard.name())) continue;
                    return true;
                }
                return false;
            }
        }
    }

    private record AddExportsAndOpensAndReadsFormatValue(Module module, String packageName, List<Module> targetModules) {
    }
}

