/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerLoader;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.shaded.org.capnproto.PrimitiveList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import jdk.graal.compiler.debug.Assertions;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class OpenTypeWorldFeature
implements InternalFeature {
    private final Set<AnalysisType> triggeredTypes = new HashSet<AnalysisType>();
    private final Set<AnalysisMethod> triggeredMethods = new HashSet<AnalysisMethod>();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !SubstrateOptions.useClosedTypeWorldHubLayout();
    }

    public void beforeUniverseBuilding(Feature.BeforeUniverseBuildingAccess access) {
        if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            ImageSingletons.add(LayerTypeCheckInfo.class, (Object)new LayerTypeCheckInfo(0));
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl config = (FeatureImpl.DuringAnalysisAccessImpl)access;
        for (AnalysisType aType : config.getUniverse().getTypes()) {
            if (!this.triggeredTypes.add(aType)) continue;
            aType.getOrCalculateOpenTypeWorldDispatchTableMethods();
            config.requireAnalysisIteration();
        }
        for (AnalysisMethod aMethod : config.getUniverse().getMethods()) {
            if (!this.triggeredMethods.add(aMethod) || aMethod.isStatic()) continue;
            aMethod.getIndirectCallTarget();
            config.requireAnalysisIteration();
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FeatureImpl.BeforeCompilationAccessImpl impl = (FeatureImpl.BeforeCompilationAccessImpl)access;
        for (HostedType type : impl.getUniverse().getTypes()) {
            DynamicHub hub = type.getHub();
            impl.registerAsImmutable(hub.getOpenTypeWorldTypeCheckSlots());
        }
    }

    public static int loadTypeInfo(Collection<HostedType> types) {
        if (ImageLayerBuildingSupport.buildingExtensionLayer()) {
            return ((LayerTypeCheckInfo)ImageSingletons.lookup(LayerTypeCheckInfo.class)).loadTypeID(types);
        }
        return 0;
    }

    public static boolean validateTypeInfo(Collection<HostedType> types) {
        if (ImageLayerBuildingSupport.buildingExtensionLayer()) {
            SVMImageLayerLoader loader = HostedImageLayerBuildingSupport.singleton().getLoader();
            for (HostedType type : types) {
                TypeCheckInfo priorInfo;
                if (!type.getWrapped().isInBaseLayer() || !(priorInfo = OpenTypeWorldFeature.getTypecheckInfo(loader, type)).installed()) continue;
                int typeID = type.getTypeID();
                int numClassTypes = type.getNumClassTypes();
                int numInterfaceTypes = type.getNumInterfaceTypes();
                int[] typecheckSlots = type.getOpenTypeWorldTypeCheckSlots();
                boolean matches = typeID == priorInfo.typeID && numClassTypes == priorInfo.numClassTypes && numInterfaceTypes == priorInfo.numInterfaceTypes && Arrays.equals(typecheckSlots, priorInfo.typecheckSlots);
                if (matches) continue;
                TypeCheckInfo typeInfo = new TypeCheckInfo(true, typeID, numClassTypes, numInterfaceTypes, typecheckSlots);
                assert (false) : Assertions.errorMessage((Object[])new Object[]{"Mismatch for ", type, priorInfo, typeInfo, Arrays.toString(priorInfo.typecheckSlots), Arrays.toString(typeInfo.typecheckSlots)});
            }
        }
        return true;
    }

    static TypeCheckInfo getTypecheckInfo(SVMImageLayerLoader loader, HostedType hType) {
        if (hType.getWrapped().isInBaseLayer()) {
            SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Reader hubInfo = loader.getDynamicHubInfo(hType.getWrapped());
            PrimitiveList.Int.Reader valuesReader = hubInfo.getTypecheckSlotValues();
            int[] typecheckSlots = new int[valuesReader.size()];
            for (int i = 0; i < typecheckSlots.length; ++i) {
                typecheckSlots[i] = valuesReader.get(i);
            }
            return new TypeCheckInfo(hubInfo.getInstalled(), hubInfo.getTypecheckId(), hubInfo.getNumClassTypes(), hubInfo.getNumInterfaceTypes(), typecheckSlots);
        }
        return null;
    }

    private static final class LayerTypeCheckInfo
    implements LayeredImageSingleton {
        final int maxTypeID;

        LayerTypeCheckInfo(int maxTypeID) {
            this.maxTypeID = maxTypeID;
        }

        public int loadTypeID(Collection<HostedType> types) {
            SVMImageLayerLoader loader = HostedImageLayerBuildingSupport.singleton().getLoader();
            for (HostedType type : types) {
                TypeCheckInfo info = OpenTypeWorldFeature.getTypecheckInfo(loader, type);
                if (info == null) continue;
                type.loadTypeID(info.typeID);
            }
            return this.maxTypeID;
        }

        @Override
        public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
            return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
        }

        @Override
        public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
            writer.writeInt("maxTypeID", DynamicHubSupport.currentLayer().getMaxTypeId());
            return LayeredImageSingleton.PersistFlags.CREATE;
        }

        public static Object createFromLoader(ImageSingletonLoader loader) {
            return new LayerTypeCheckInfo(loader.readInt("maxTypeID"));
        }
    }

    record TypeCheckInfo(boolean installed, int typeID, int numClassTypes, int numInterfaceTypes, int[] typecheckSlots) {
    }
}

