/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.graal.compiler.util.json.JsonWriter;

public class ProgressReporterJsonHelper {
    protected static final long UNAVAILABLE_METRIC = -1L;
    private static final String ANALYSIS_RESULTS_KEY = "analysis_results";
    private static final String GENERAL_INFO_KEY = "general_info";
    private static final String IMAGE_DETAILS_KEY = "image_details";
    private static final String RESOURCE_USAGE_KEY = "resource_usage";
    private final Map<String, Object> statsHolder = new HashMap<String, Object>();

    private static List<String> buildKeys(String ... keys) {
        return Arrays.stream(keys).filter(Objects::nonNull).toList();
    }

    private static Map<String, Object> getMap(Map<String, Object> object, String key) {
        Objects.requireNonNull(key, "JSON keys must not be 'null'");
        return (Map)object.get(key);
    }

    private Object getValue(List<String> keys) {
        assert (!keys.isEmpty());
        Map<String, Object> currentLevel = this.statsHolder;
        for (int i = 0; i < keys.size() - 1; ++i) {
            if ((currentLevel = ProgressReporterJsonHelper.getMap(currentLevel, keys.get(i))) != null) continue;
            return null;
        }
        return currentLevel.get(keys.getLast());
    }

    public Object getAnalysisResults(AnalysisResults key) {
        return this.getValue(ProgressReporterJsonHelper.buildKeys(ANALYSIS_RESULTS_KEY, key.bucket, key.key));
    }

    public Object getGeneralInfo(GeneralInfo info) {
        return this.getValue(ProgressReporterJsonHelper.buildKeys(GENERAL_INFO_KEY, info.bucket, info.key));
    }

    public Object getImageDetails(ImageDetailKey key) {
        return this.getValue(ProgressReporterJsonHelper.buildKeys(IMAGE_DETAILS_KEY, key.bucket, key.subBucket, key.jsonKey));
    }

    public Object getResourceUsage(ResourceUsageKey key) {
        return this.getValue(ProgressReporterJsonHelper.buildKeys(RESOURCE_USAGE_KEY, key.bucket, key.jsonKey));
    }

    private boolean containsValue(List<String> keys) {
        return this.getValue(keys) != null;
    }

    public boolean containsAnalysisResults(AnalysisResults key) {
        return this.containsValue(ProgressReporterJsonHelper.buildKeys(ANALYSIS_RESULTS_KEY, key.bucket, key.key));
    }

    public boolean containsGeneralInfo(GeneralInfo info) {
        return this.containsValue(ProgressReporterJsonHelper.buildKeys(GENERAL_INFO_KEY, info.bucket, info.key));
    }

    public boolean containsImageDetails(ImageDetailKey key) {
        return this.containsValue(ProgressReporterJsonHelper.buildKeys(IMAGE_DETAILS_KEY, key.bucket, key.subBucket, key.jsonKey));
    }

    public boolean containsResourceUsage(ResourceUsageKey key) {
        return this.containsValue(ProgressReporterJsonHelper.buildKeys(RESOURCE_USAGE_KEY, key.bucket, key.jsonKey));
    }

    private static Map<String, Object> getOrCreateMap(Map<String, Object> object, String key) {
        Objects.requireNonNull(key, "JSON keys must not be 'null'");
        return (Map)object.computeIfAbsent(key, k -> new HashMap());
    }

    private void putValue(List<String> keys, Object value) {
        assert (!keys.isEmpty());
        Map<String, Object> currentLevel = this.statsHolder;
        for (int i = 0; i < keys.size() - 1; ++i) {
            currentLevel = ProgressReporterJsonHelper.getOrCreateMap(currentLevel, keys.get(i));
        }
        currentLevel.put(keys.getLast(), value);
    }

    public void putAnalysisResults(AnalysisResults key, long value) {
        this.putValue(ProgressReporterJsonHelper.buildKeys(ANALYSIS_RESULTS_KEY, key.bucket, key.key), value);
    }

    public void putGeneralInfo(GeneralInfo info, Object value) {
        this.putValue(ProgressReporterJsonHelper.buildKeys(GENERAL_INFO_KEY, info.bucket, info.key), value);
    }

    private void putImageDetails(ImageDetailKey key, Object value) {
        this.putValue(ProgressReporterJsonHelper.buildKeys(IMAGE_DETAILS_KEY, key.bucket, key.subBucket, key.jsonKey), value);
    }

    private void putResourceUsage(ResourceUsageKey key, Object value) {
        this.putValue(ProgressReporterJsonHelper.buildKeys(RESOURCE_USAGE_KEY, key.bucket, key.jsonKey), value);
    }

    public void print(JsonWriter writer) throws IOException {
        writer.print(this.statsHolder);
    }

    public static enum AnalysisResults implements JsonMetric
    {
        TYPES_REACHABLE("types", "reachable"),
        TYPES_JNI("types", "jni"),
        TYPES_REFLECT("types", "reflection"),
        METHOD_REACHABLE("methods", "reachable"),
        METHOD_JNI("methods", "jni"),
        METHOD_REFLECT("methods", "reflection"),
        FIELD_REACHABLE("fields", "reachable"),
        FIELD_JNI("fields", "jni"),
        FIELD_REFLECT("fields", "reflection"),
        FOREIGN_DOWNCALLS("methods", "foreign_downcalls"),
        FOREIGN_UPCALLS("methods", "foreign_upcalls"),
        DEPRECATED_TYPES_TOTAL("types", "total"),
        DEPRECATED_METHOD_TOTAL("methods", "total"),
        DEPRECATED_FIELD_TOTAL("fields", "total");

        private final String key;
        private final String bucket;

        private AnalysisResults(String bucket, String key) {
            this.key = key;
            this.bucket = bucket;
        }

        public String jsonKey() {
            return this.key;
        }

        public String bucket() {
            return this.bucket;
        }

        @Override
        public Object getValue(ProgressReporterJsonHelper helper) {
            return helper.getAnalysisResults(this);
        }

        @Override
        public boolean containsValue(ProgressReporterJsonHelper helper) {
            return helper.containsAnalysisResults(this);
        }

        @Override
        public void record(ProgressReporterJsonHelper helper, Object value) {
            if (value instanceof Integer) {
                Integer v = (Integer)value;
                helper.putAnalysisResults(this, v.intValue());
            } else if (value instanceof Long) {
                Long v = (Long)value;
                helper.putAnalysisResults(this, v);
            } else {
                VMError.shouldNotReachHere("Imcompatible type of 'value': " + String.valueOf(value.getClass()));
            }
        }
    }

    public static enum GeneralInfo implements JsonMetric
    {
        NAME("name", null),
        JAVA_VERSION("java_version", null),
        VENDOR_VERSION("vendor_version", null),
        GRAALVM_VERSION("graalvm_version", null),
        GRAAL_COMPILER_OPTIMIZATION_LEVEL("optimization_level", "graal_compiler"),
        GRAAL_COMPILER_MARCH("march", "graal_compiler"),
        GRAAL_COMPILER_PGO("pgo", "graal_compiler"),
        GC("garbage_collector", null),
        CC("c_compiler", null);

        private final String key;
        private final String bucket;

        private GeneralInfo(String key, String bucket) {
            this.key = key;
            this.bucket = bucket;
        }

        public String jsonKey() {
            return this.key;
        }

        @Override
        public Object getValue(ProgressReporterJsonHelper helper) {
            return helper.getGeneralInfo(this);
        }

        @Override
        public boolean containsValue(ProgressReporterJsonHelper helper) {
            return helper.containsGeneralInfo(this);
        }

        @Override
        public void record(ProgressReporterJsonHelper helper, Object value) {
            if (value instanceof String || value instanceof Boolean || value instanceof List || value == null) {
                helper.putGeneralInfo(this, value);
            } else {
                VMError.shouldNotReachHere("Imcompatible type of 'value': " + String.valueOf(value.getClass()));
            }
        }
    }

    public static enum ImageDetailKey implements JsonMetric
    {
        TOTAL_SIZE(null, null, "total_bytes"),
        CODE_AREA_SIZE("code_area", null, "bytes"),
        NUM_COMP_UNITS("code_area", null, "compilation_units"),
        IMAGE_HEAP_SIZE("image_heap", null, "bytes"),
        IMAGE_HEAP_OBJECT_COUNT("image_heap", "objects", "count"),
        DEBUG_INFO_SIZE("debug_info", null, "bytes"),
        IMAGE_HEAP_RESOURCE_COUNT("image_heap", "resources", "count"),
        RESOURCE_SIZE_BYTES("image_heap", "resources", "bytes"),
        RUNTIME_COMPILED_METHODS_COUNT("runtime_compiled_methods", null, "count"),
        GRAPH_ENCODING_SIZE("runtime_compiled_methods", null, "graph_encoding_bytes");

        private final String bucket;
        private final String jsonKey;
        private final String subBucket;

        private ImageDetailKey(String bucket, String subBucket, String key) {
            this.bucket = bucket;
            this.jsonKey = key;
            this.subBucket = subBucket;
        }

        @Override
        public Object getValue(ProgressReporterJsonHelper helper) {
            return helper.getImageDetails(this);
        }

        @Override
        public boolean containsValue(ProgressReporterJsonHelper helper) {
            return helper.containsImageDetails(this);
        }

        @Override
        public void record(ProgressReporterJsonHelper helper, Object value) {
            helper.putImageDetails(this, value);
        }
    }

    public static enum ResourceUsageKey implements JsonMetric
    {
        CPU_LOAD("cpu", "load"),
        CPU_CORES_TOTAL("cpu", "total_cores"),
        GC_COUNT("garbage_collection", "count"),
        GC_MAX_HEAP("garbage_collection", "max_heap"),
        GC_SECS("garbage_collection", "total_secs"),
        PARALLELISM("cpu", "parallelism"),
        PEAK_RSS("memory", "peak_rss_bytes"),
        MEMORY_TOTAL("memory", "system_total"),
        TOTAL_SECS(null, "total_secs");

        private final String bucket;
        private final String jsonKey;

        private ResourceUsageKey(String bucket, String key) {
            this.bucket = bucket;
            this.jsonKey = key;
        }

        @Override
        public Object getValue(ProgressReporterJsonHelper helper) {
            return helper.getResourceUsage(this);
        }

        @Override
        public boolean containsValue(ProgressReporterJsonHelper helper) {
            return helper.containsResourceUsage(this);
        }

        @Override
        public void record(ProgressReporterJsonHelper helper, Object value) {
            helper.putResourceUsage(this, value);
        }
    }

    public static interface JsonMetric {
        public Object getValue(ProgressReporterJsonHelper var1);

        public boolean containsValue(ProgressReporterJsonHelper var1);

        public void record(ProgressReporterJsonHelper var1, Object var2);
    }
}

