/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.svm.hosted.dashboard.DashboardOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class DashboardOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(DashboardOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "DashboardAll": {
                return OptionDescriptor.create((String)"DashboardAll", (OptionType)OptionType.Expert, Boolean.class, (String)"In the dashboard dump, include all available information about the native image (this takes precedence over more specific flags).", (Object)this.getContainer(), DashboardOptions.DashboardAll, (String)"DashboardAll", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DashboardBgv": {
                return OptionDescriptor.create((String)"DashboardBgv", (OptionType)OptionType.Expert, Boolean.class, (String)"Set dashboard to use BGV format for dump.", (Object)this.getContainer(), DashboardOptions.DashboardBgv, (String)"DashboardBgv", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DashboardCode": {
                return OptionDescriptor.create((String)"DashboardCode", (OptionType)OptionType.Expert, Boolean.class, (String)"In the dashboard dump, include the breakdown of the code size across different packages.", (Object)this.getContainer(), DashboardOptions.DashboardCode, (String)"DashboardCode", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DashboardDump": {
                return OptionDescriptor.create((String)"DashboardDump", (OptionType)OptionType.Expert, String.class, (String)"Enable dashboard dumps to the specified file.", (Object)this.getContainer(), DashboardOptions.DashboardDump, (String)"DashboardDump", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DashboardHeap": {
                return OptionDescriptor.create((String)"DashboardHeap", (OptionType)OptionType.Expert, Boolean.class, (String)"In the dashboard dump, include the breakdown of the object sizes in the heap across different classes.", (Object)this.getContainer(), DashboardOptions.DashboardHeap, (String)"DashboardHeap", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DashboardJson": {
                return OptionDescriptor.create((String)"DashboardJson", (OptionType)OptionType.Expert, Boolean.class, (String)"Set dashboard to use JSON format for dump.", (Object)this.getContainer(), DashboardOptions.DashboardJson, (String)"DashboardJson", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DashboardPointsTo": {
                return OptionDescriptor.create((String)"DashboardPointsTo", (OptionType)OptionType.Expert, Boolean.class, (String)"In the dashboard dump, include the information about the points-to analysis.", (Object)this.getContainer(), DashboardOptions.DashboardPointsTo, (String)"DashboardPointsTo", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DashboardPretty": {
                return OptionDescriptor.create((String)"DashboardPretty", (OptionType)OptionType.Expert, Boolean.class, (String)"Set dashboard to use pretty print in JSON format.", (Object)this.getContainer(), DashboardOptions.DashboardPretty, (String)"DashboardPretty", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 8;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return DashboardOptions_OptionDescriptors.this.get("DashboardAll");
                    }
                    case 1: {
                        return DashboardOptions_OptionDescriptors.this.get("DashboardBgv");
                    }
                    case 2: {
                        return DashboardOptions_OptionDescriptors.this.get("DashboardCode");
                    }
                    case 3: {
                        return DashboardOptions_OptionDescriptors.this.get("DashboardDump");
                    }
                    case 4: {
                        return DashboardOptions_OptionDescriptors.this.get("DashboardHeap");
                    }
                    case 5: {
                        return DashboardOptions_OptionDescriptors.this.get("DashboardJson");
                    }
                    case 6: {
                        return DashboardOptions_OptionDescriptors.this.get("DashboardPointsTo");
                    }
                    case 7: {
                        return DashboardOptions_OptionDescriptors.this.get("DashboardPretty");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

