/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.fieldfolding.MarkStaticFinalFieldInitializedNode;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingFeature;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingSingleton;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.StateSplitProxyNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaField;

final class StaticFinalFieldFoldingNodePlugin
implements NodePlugin {
    private final FieldValueInterceptionSupport fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();

    StaticFinalFieldFoldingNodePlugin() {
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField field) {
        AnalysisMethod definingClassInitializer;
        assert (field.isStatic());
        if (!field.isFinal()) {
            return false;
        }
        if (!StaticFinalFieldFoldingFeature.isAllowedTargetMethod(b.getMethod())) {
            return false;
        }
        AnalysisField aField = StaticFinalFieldFoldingSingleton.toAnalysisField(field);
        if (!StaticFinalFieldFoldingFeature.isOptimizationCandidate(aField, definingClassInitializer = aField.getDeclaringClass().getClassInitializer(), this.fieldValueInterceptionSupport)) {
            return false;
        }
        LoadFieldNode loadFieldNode = (LoadFieldNode)b.append((Node)LoadFieldNode.create((Assumptions)b.getAssumptions(), null, (ResolvedJavaField)field));
        StateSplitProxyNode readProxy = (StateSplitProxyNode)b.addPush(field.getJavaKind(), (ValueNode)new StateSplitProxyNode((ValueNode)loadFieldNode));
        assert (readProxy.stateAfter() != null);
        return true;
    }

    public boolean handleStoreStaticField(GraphBuilderContext b, ResolvedJavaField field, ValueNode value) {
        assert (field.isStatic());
        if (!field.isFinal()) {
            return false;
        }
        if (SubstrateCompilationDirectives.isDeoptTarget(b.getMethod())) {
            return false;
        }
        b.add((Node)new MarkStaticFinalFieldInitializedNode(field));
        return false;
    }
}

