/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.substitute.InjectedFieldsType;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import com.oracle.svm.hosted.substitute.SubstitutionType;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.WordBase;

public abstract class NativeImageDebugInfoProviderBase {
    protected final NativeImageHeap heap;
    protected final NativeImageCodeCache codeCache;
    protected final NativeLibraries nativeLibs;
    protected final RuntimeConfiguration runtimeConfiguration;
    protected final boolean useHeapBase;
    protected final int compressionShift;
    protected final int referenceSize;
    protected final int pointerSize;
    protected final int objectAlignment;
    protected final int primitiveStartOffset;
    protected final int referenceStartOffset;
    protected final int reservedHubBitsMask;
    protected final HostedType hubType;
    protected final HostedType wordBaseType;
    final HashMap<JavaKind, HostedType> javaKindToHostedType;
    private final Path cachePath = SubstrateOptions.getDebugInfoSourceCacheRoot();

    public NativeImageDebugInfoProviderBase(NativeImageCodeCache codeCache, NativeImageHeap heap, NativeLibraries nativeLibs, HostedMetaAccess metaAccess, RuntimeConfiguration runtimeConfiguration) {
        this.heap = heap;
        this.codeCache = codeCache;
        this.nativeLibs = nativeLibs;
        this.runtimeConfiguration = runtimeConfiguration;
        this.hubType = metaAccess.lookupJavaType((Class)Class.class);
        this.wordBaseType = metaAccess.lookupJavaType((Class)WordBase.class);
        this.pointerSize = ConfigurationValues.getTarget().wordSize;
        ObjectHeader objectHeader = Heap.getHeap().getObjectHeader();
        NativeImageHeap.ObjectInfo primitiveFields = heap.getObjectInfo(StaticFieldsSupport.getCurrentLayerStaticPrimitiveFields());
        NativeImageHeap.ObjectInfo objectFields = heap.getObjectInfo(StaticFieldsSupport.getCurrentLayerStaticObjectFields());
        this.reservedHubBitsMask = objectHeader.getReservedHubBitsMask();
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CompressEncoding compressEncoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
            this.useHeapBase = compressEncoding.hasBase();
            this.compressionShift = compressEncoding.hasShift() ? compressEncoding.getShift() : 0;
        } else {
            this.useHeapBase = false;
            this.compressionShift = 0;
        }
        this.referenceSize = NativeImageDebugInfoProviderBase.getObjectLayout().getReferenceSize();
        this.objectAlignment = NativeImageDebugInfoProviderBase.getObjectLayout().getAlignment();
        this.primitiveStartOffset = (int)primitiveFields.getOffset();
        this.referenceStartOffset = (int)objectFields.getOffset();
        this.javaKindToHostedType = NativeImageDebugInfoProviderBase.initJavaKindToHostedTypes(metaAccess);
    }

    protected static ResolvedJavaType getDeclaringClass(HostedType hostedType, boolean wantOriginal) {
        if (wantOriginal) {
            return NativeImageDebugInfoProviderBase.getOriginal(hostedType);
        }
        return hostedType.getWrapped().getWrapped();
    }

    protected static ResolvedJavaType getDeclaringClass(HostedMethod hostedMethod, boolean wantOriginal) {
        if (wantOriginal) {
            return NativeImageDebugInfoProviderBase.getOriginal(hostedMethod.getDeclaringClass());
        }
        ResolvedJavaMethod javaMethod = NativeImageDebugInfoProviderBase.getAnnotatedOrOriginal(hostedMethod);
        return javaMethod.getDeclaringClass();
    }

    protected static ResolvedJavaType getDeclaringClass(HostedField hostedField, boolean wantOriginal) {
        return NativeImageDebugInfoProviderBase.getOriginal(hostedField.getDeclaringClass());
    }

    protected static ResolvedJavaType getOriginal(HostedType hostedType) {
        ResolvedJavaType javaType = hostedType.getWrapped().getWrapped();
        if (javaType instanceof SubstitutionType) {
            return ((SubstitutionType)javaType).getOriginal();
        }
        if (javaType instanceof InjectedFieldsType) {
            return ((InjectedFieldsType)javaType).getOriginal();
        }
        return javaType;
    }

    private static ResolvedJavaMethod getAnnotatedOrOriginal(HostedMethod hostedMethod) {
        ResolvedJavaMethod javaMethod = hostedMethod.getWrapped().getWrapped();
        if (javaMethod instanceof SubstitutionMethod) {
            SubstitutionMethod substitutionMethod = (SubstitutionMethod)javaMethod;
            javaMethod = substitutionMethod.getAnnotated();
        }
        return javaMethod;
    }

    protected static int getOriginalModifiers(HostedMethod hostedMethod) {
        return NativeImageDebugInfoProviderBase.getAnnotatedOrOriginal(hostedMethod).getModifiers();
    }

    protected boolean isForeignWordType(JavaType type, ResolvedJavaType accessingType) {
        HostedType resolvedJavaType = (HostedType)type.resolve(accessingType);
        return this.isForeignWordType(resolvedJavaType);
    }

    protected boolean isForeignWordType(HostedType hostedType) {
        return this.nativeLibs.isWordBase((ResolvedJavaType)hostedType.getWrapped());
    }

    protected boolean isForeignPointerType(HostedType hostedType) {
        return this.nativeLibs.isPointerBase((ResolvedJavaType)hostedType.getWrapped());
    }

    protected static boolean isTypedField(ElementInfo elementInfo) {
        if (elementInfo instanceof StructFieldInfo) {
            for (ElementInfo child : elementInfo.getChildren()) {
                if (!(child instanceof AccessorInfo)) continue;
                switch (((AccessorInfo)child).getAccessorKind()) {
                    case GETTER: 
                    case SETTER: 
                    case ADDRESS: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected HostedType getFieldType(StructFieldInfo field) {
        AccessorInfo accessorInfo;
        for (ElementInfo elt : field.getChildren()) {
            if (!(elt instanceof AccessorInfo) || (accessorInfo = (AccessorInfo)elt).getAccessorKind() != AccessorInfo.AccessorKind.GETTER) continue;
            return this.heap.hUniverse.lookup((JavaType)accessorInfo.getReturnType());
        }
        for (ElementInfo elt : field.getChildren()) {
            if (!(elt instanceof AccessorInfo) || (accessorInfo = (AccessorInfo)elt).getAccessorKind() != AccessorInfo.AccessorKind.SETTER) continue;
            return this.heap.hUniverse.lookup((JavaType)accessorInfo.getParameterType(0));
        }
        for (ElementInfo elt : field.getChildren()) {
            if (!(elt instanceof AccessorInfo) || (accessorInfo = (AccessorInfo)elt).getAccessorKind() != AccessorInfo.AccessorKind.ADDRESS) continue;
            return this.heap.hUniverse.lookup((JavaType)accessorInfo.getReturnType());
        }
        assert (false) : "Field %s must have a GETTER, SETTER, ADDRESS or OFFSET accessor".formatted(field);
        return this.heap.hUniverse.lookup((JavaType)this.wordBaseType);
    }

    protected static boolean fieldTypeIsEmbedded(StructFieldInfo field) {
        AccessorInfo accessorInfo;
        for (ElementInfo elt : field.getChildren()) {
            if (!(elt instanceof AccessorInfo) || (accessorInfo = (AccessorInfo)elt).getAccessorKind() != AccessorInfo.AccessorKind.GETTER) continue;
            return false;
        }
        for (ElementInfo elt : field.getChildren()) {
            if (!(elt instanceof AccessorInfo) || (accessorInfo = (AccessorInfo)elt).getAccessorKind() != AccessorInfo.AccessorKind.SETTER) continue;
            return false;
        }
        for (ElementInfo elt : field.getChildren()) {
            if (!(elt instanceof AccessorInfo) || (accessorInfo = (AccessorInfo)elt).getAccessorKind() != AccessorInfo.AccessorKind.ADDRESS) continue;
            return true;
        }
        throw VMError.shouldNotReachHere("Field %s must have a GETTER, SETTER, ADDRESS or OFFSET accessor".formatted(field));
    }

    protected static int elementSize(ElementInfo elementInfo) {
        StructInfo structInfo;
        if (!(elementInfo instanceof SizableInfo) || elementInfo instanceof StructInfo && (structInfo = (StructInfo)elementInfo).isIncomplete()) {
            return 0;
        }
        Integer size = ((SizableInfo)elementInfo).getSizeInBytes();
        assert (size != null);
        return size;
    }

    protected static String elementName(ElementInfo elementInfo) {
        if (elementInfo == null) {
            return "";
        }
        return elementInfo.getName();
    }

    protected static SizableInfo.ElementKind elementKind(SizableInfo sizableInfo) {
        return sizableInfo.getKind();
    }

    static ObjectLayout getObjectLayout() {
        return ConfigurationValues.getObjectLayout();
    }

    public boolean useHeapBase() {
        return this.useHeapBase;
    }

    public int compressionShift() {
        return this.compressionShift;
    }

    public int referenceSize() {
        return this.referenceSize;
    }

    public int pointerSize() {
        return this.pointerSize;
    }

    public int objectAlignment() {
        return this.objectAlignment;
    }

    public int reservedHubBitsMask() {
        return this.reservedHubBitsMask;
    }

    public int compiledCodeMax() {
        return this.codeCache.getCodeCacheSize();
    }

    public long objectOffset(JavaConstant constant) {
        assert (constant.getJavaKind() == JavaKind.Object && !constant.isNull()) : "invalid constant for object offset lookup";
        NativeImageHeap.ObjectInfo objectInfo = this.heap.getConstantInfo(constant);
        if (objectInfo != null) {
            return objectInfo.getOffset();
        }
        return -1L;
    }

    protected HostedType hostedTypeForKind(JavaKind kind) {
        return this.javaKindToHostedType.get(kind);
    }

    private static HashMap<JavaKind, HostedType> initJavaKindToHostedTypes(HostedMetaAccess metaAccess) {
        HashMap<JavaKind, HostedType> map = new HashMap<JavaKind, HostedType>();
        for (JavaKind kind : JavaKind.values()) {
            Class clazz = switch (kind) {
                case JavaKind.Illegal -> null;
                case JavaKind.Object -> Object.class;
                default -> kind.toJavaClass();
            };
            ResolvedJavaType javaType = clazz != null ? metaAccess.lookupJavaType(clazz) : null;
            map.put(kind, (HostedType)javaType);
        }
        return map;
    }

    protected SubstrateCallingConvention getCallingConvention(HostedMethod method) {
        SubstrateCallingConventionKind callingConventionKind = method.getCallingConventionKind();
        HostedType declaringClass = method.getDeclaringClass();
        HostedType receiverType = method.isStatic() ? null : declaringClass;
        ResolvedSignature<HostedType> signature = method.getSignature();
        SubstrateCallingConventionType type = callingConventionKind.isCustom() ? method.getCustomCallingConventionType() : callingConventionKind.toType(false);
        SubstrateBackend backend = this.runtimeConfiguration.lookupBackend(method);
        RegisterConfig registerConfig = backend.getCodeCache().getRegisterConfig();
        assert (registerConfig instanceof SubstrateRegisterConfig);
        return (SubstrateCallingConvention)registerConfig.getCallingConvention((CallingConvention.Type)type, (JavaType)signature.getReturnType(), signature.toParameterTypes((JavaType)receiverType), (ValueKindFactory)backend);
    }

    protected static Path fullFilePathFromClassName(HostedType hostedInstanceClass) {
        String[] elements = hostedInstanceClass.toJavaName().split("\\.");
        int count = elements.length;
        String name = elements[count - 1];
        while (name.startsWith("$")) {
            name = name.substring(1);
        }
        if (name.contains("$")) {
            name = name.substring(0, name.indexOf(36));
        }
        if (name.equals("")) {
            name = "_nofile_";
        }
        elements[count - 1] = name + ".java";
        return FileSystems.getDefault().getPath("", elements);
    }

    public Path getCachePath() {
        return this.cachePath;
    }
}

