/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.imagelayer.LoadImageSingletonFactory;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.imagelayer.CrossLayerSingletonMappingInfo;
import com.oracle.svm.hosted.imagelayer.LoadImageSingletonFeature;
import com.oracle.svm.hosted.imagelayer.SlotRecordKind;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;

class LoadImageSingletonDataImpl
implements LoadImageSingletonFactory.LoadImageSingletonData {
    private final Class<?> key;
    private final SlotRecordKind kind;
    private boolean applicationLayerConstant;

    LoadImageSingletonDataImpl(Class<?> key, SlotRecordKind kind) {
        this.key = key;
        this.kind = kind;
    }

    public Class<?> getKey() {
        return this.key;
    }

    public SlotRecordKind getKind() {
        return this.kind;
    }

    @Override
    public Class<?> getLoadType() {
        return this.kind == SlotRecordKind.APPLICATION_LAYER_SINGLETON ? this.key : this.key.arrayType();
    }

    @Override
    public LoadImageSingletonFactory.SingletonAccessInfo getAccessInfo() {
        VMError.guarantee(!this.applicationLayerConstant, "this node should instead be constant folded");
        CrossLayerSingletonMappingInfo singleton = LoadImageSingletonFeature.getCrossLayerSingletonMappingInfo();
        assert (singleton.singletonTableStart != null);
        CGlobalDataInfo cglobal = CGlobalDataFeature.singleton().registerAsAccessedOrGet(singleton.singletonTableStart);
        int slotNum = singleton.currentKeyToSlotInfoMap.get(this.key).slotNum();
        return new LoadImageSingletonFactory.SingletonAccessInfo(cglobal, slotNum * singleton.referenceSize);
    }

    void setApplicationLayerConstant() {
        this.applicationLayerConstant = true;
    }

    @Override
    public boolean isApplicationLayerConstant() {
        return this.applicationLayerConstant;
    }

    @Override
    public ConstantNode asApplicationLayerConstant(MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflectionProvider) {
        VMError.guarantee(this.isApplicationLayerConstant());
        return switch (this.kind) {
            default -> throw new MatchException(null, null);
            case SlotRecordKind.APPLICATION_LAYER_SINGLETON -> {
                Object singleton = LayeredImageSingletonSupport.singleton().lookup(this.key, true, false);
                LayeredImageSingletonBuilderFlags.validateRuntimeLookup(singleton);
                yield ConstantNode.forConstant((JavaConstant)snippetReflectionProvider.forObject(singleton), (MetaAccessProvider)metaAccess);
            }
            case SlotRecordKind.MULTI_LAYERED_SINGLETON -> {
                JavaConstant multiLayerArray = ((LoadImageSingletonFeature)ImageSingletons.lookup(LoadImageSingletonFeature.class)).getMultiLayerConstant(this.key, metaAccess, snippetReflectionProvider);
                yield ConstantNode.forConstant((JavaConstant)multiLayerArray, (int)1, (boolean)true, (MetaAccessProvider)metaAccess);
            }
        };
    }
}

