/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import org.graalvm.nativeimage.ImageSingletons;

final class ComputeInterfaceTypeID
implements FieldValueTransformerWithAvailability {
    ComputeInterfaceTypeID() {
    }

    @Override
    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    public Object transform(Object receiver, Object originalValue) {
        SubstrateMethodAccessor accessor = (SubstrateMethodAccessor)receiver;
        VMError.guarantee(accessor.getInterfaceTypeID() == -559087615);
        if (SubstrateOptions.useClosedTypeWorldHubLayout()) {
            return -3;
        }
        HostedMethod member = ((ReflectionFeature)ImageSingletons.lookup(ReflectionFeature.class)).hostedMetaAccess().lookupJavaMethod(accessor.getMember());
        if (member.getDeclaringClass().isInterface()) {
            return member.getDeclaringClass().getTypeID();
        }
        return -1;
    }
}

