/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedType;
import jdk.vm.ci.meta.ResolvedJavaField;

@AutomaticallyRegisteredImageSingleton(value={StaticFieldsSupport.StaticFieldValidator.class})
public class StaticFieldValidatorImpl
implements StaticFieldsSupport.StaticFieldValidator {
    @Override
    public void hostedCheckFieldOffsetAllowed(ResolvedJavaField field) {
        boolean wordType;
        if (field instanceof AnalysisField) {
            AnalysisField aField = (AnalysisField)field;
            wordType = aField.getType().isWordType();
        } else {
            SharedField sField = (SharedField)field;
            wordType = ((SharedType)sField.getType()).isWordType();
        }
        AnalysisError.guarantee((!wordType ? 1 : 0) != 0, (String)"static Word field offsets cannot be queried %s", (Object[])new Object[]{field});
    }
}

