/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect.serialize;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.configure.ConfigurationFile;
import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.SerializationConfigurationParser;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.lambda.LambdaParser;
import com.oracle.svm.hosted.reflect.NativeImageConditionResolver;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import com.oracle.svm.hosted.reflect.proxy.DynamicProxyFeature;
import com.oracle.svm.hosted.reflect.proxy.ProxyRegistry;
import com.oracle.svm.hosted.reflect.serialize.SerializationBuilder;
import com.oracle.svm.hosted.reflect.serialize.SerializationDenyRegistry;
import com.oracle.svm.util.ReflectionUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

@AutomaticallyRegisteredFeature
public class SerializationFeature
implements InternalFeature {
    final Set<Class<?>> capturingClasses = ConcurrentHashMap.newKeySet();
    private SerializationBuilder serializationBuilder;
    private SerializationDenyRegistry serializationDenyRegistry;
    private int loadedConfigurations;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(ReflectionFeature.class, DynamicProxyFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        ConfigurationTypeResolver typeResolver = new ConfigurationTypeResolver("serialization configuration", imageClassLoader);
        this.serializationDenyRegistry = new SerializationDenyRegistry(typeResolver);
        this.serializationBuilder = new SerializationBuilder(this.serializationDenyRegistry, access, typeResolver, (ProxyRegistry)ImageSingletons.lookup(ProxyRegistry.class));
        ImageSingletons.add(RuntimeSerializationSupport.class, (Object)this.serializationBuilder);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        NativeImageConditionResolver conditionResolver = new NativeImageConditionResolver(imageClassLoader, ClassInitializationSupport.singleton());
        EnumSet<ConfigurationParserOption> parserOptions = ConfigurationFiles.Options.getConfigurationParserOptions();
        SerializationConfigurationParser parser = SerializationConfigurationParser.create((boolean)true, (ConfigurationConditionResolver)conditionResolver, (RuntimeSerializationSupport)this.serializationBuilder, parserOptions);
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurationsFromCombinedFile((ConfigurationParser)parser, imageClassLoader, "serialization");
        SerializationConfigurationParser denyCollectorParser = SerializationConfigurationParser.create((boolean)false, (ConfigurationConditionResolver)conditionResolver, (RuntimeSerializationSupport)this.serializationDenyRegistry, parserOptions);
        ConfigurationParserUtils.parseAndRegisterConfigurations((ConfigurationParser)denyCollectorParser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationDenyConfigurationFiles, ConfigurationFiles.Options.SerializationDenyConfigurationResources, ConfigurationFile.SERIALIZATION_DENY.getFileName());
        SerializationConfigurationParser legacyParser = SerializationConfigurationParser.create((boolean)false, (ConfigurationConditionResolver)conditionResolver, (RuntimeSerializationSupport)this.serializationBuilder, parserOptions);
        this.loadedConfigurations += ConfigurationParserUtils.parseAndRegisterConfigurations((ConfigurationParser)legacyParser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationConfigurationFiles, ConfigurationFiles.Options.SerializationConfigurationResources, ConfigurationFile.SERIALIZATION.getFileName());
    }

    private static void registerLambdasFromConstantNodesInGraph(StructuredGraph graph, SerializationBuilder serializationBuilder) {
        NodeIterable constantNodes = ConstantNode.getConstantNodes((StructuredGraph)graph);
        for (ConstantNode cNode : constantNodes) {
            Class<?> lambdaClass = LambdaParser.getLambdaClassFromConstantNode(cNode);
            if (lambdaClass == null || !Serializable.class.isAssignableFrom(lambdaClass)) continue;
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(lambdaClass, (String)"writeReplace", (Class[])new Class[0])});
            SerializationBuilder.registerSerializationUIDElements(lambdaClass, false);
            serializationBuilder.serializationSupport.registerSerializationTargetClass(ConfigurationCondition.alwaysTrue(), serializationBuilder.getHostVM().dynamicHub(lambdaClass));
        }
    }

    private static void registerLambdasFromMethod(ResolvedJavaMethod method, SerializationBuilder serializationBuilder, OptionValues options) {
        StructuredGraph graph = LambdaParser.createMethodGraph(method, options);
        SerializationFeature.registerLambdasFromConstantNodesInGraph(graph, serializationBuilder);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.serializationBuilder.beforeAnalysis(access);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl impl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        OptionValues options = impl.getBigBang().getOptions();
        MetaAccessProvider metaAccess = GraalAccess.getOriginalProviders().getMetaAccess();
        this.capturingClasses.parallelStream().map(arg_0 -> ((MetaAccessProvider)metaAccess).lookupJavaType(arg_0)).flatMap(LambdaParser::allExecutablesDeclaredInClass).filter(m -> m.getCode() != null).forEach(m -> SerializationFeature.registerLambdasFromMethod(m, this.serializationBuilder, options));
        this.capturingClasses.clear();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.serializationBuilder.afterAnalysis();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FallbackFeature.FallbackImageRequest serializationFallback;
        if (ImageSingletons.contains(FallbackFeature.class) && (serializationFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).serializationFallback) != null && this.loadedConfigurations == 0) {
            throw serializationFallback;
        }
        this.serializationBuilder.serializationSupport.replaceHubKeyWithTypeID();
    }

    public static Object getConstructorAccessor(Constructor<?> constructor) {
        return SerializationBuilder.getConstructorAccessor(constructor);
    }
}

