/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.debug;

import com.oracle.svm.interpreter.debug.EventHandler;
import com.oracle.svm.interpreter.debug.EventKind;
import com.oracle.svm.interpreter.debug.Location;
import com.oracle.svm.interpreter.debug.SteppingControl;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public interface DebuggerEvents {
    public void setEventEnabled(Thread var1, EventKind var2, boolean var3);

    public boolean isEventEnabled(Thread var1, EventKind var2);

    public void toggleBreakpoint(ResolvedJavaMethod var1, int var2, boolean var3);

    public void toggleMethodEnterEvent(ResolvedJavaType var1, boolean var2);

    public void toggleMethodExitEvent(ResolvedJavaType var1, boolean var2);

    public void setSteppingFromLocation(Thread var1, int var2, int var3, Location var4);

    default public void setStepping(Thread thread, int depth, int size) {
        this.setSteppingFromLocation(thread, depth, size, null);
    }

    public void clearStepping(Thread var1);

    public void setEventHandler(EventHandler var1);

    public EventHandler getEventHandler();

    public SteppingControl getSteppingControl(Thread var1);

    public static DebuggerEvents singleton() {
        return MetadataUtil.requireNonNull((DebuggerEvents)ImageSingletons.lookup(DebuggerEvents.class));
    }
}

