/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.StackFrame;
import com.oracle.svm.jdwp.bridge.UnmodifiablePacket;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryInput;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryMarshaller;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryOutput;
import com.oracle.svm.jdwp.bridge.nativebridge.ForeignException;
import com.oracle.svm.jdwp.bridge.nativebridge.JNIConfig;
import com.oracle.svm.jdwp.bridge.nativebridge.MarshalledException;

public class JDWPJNIConfig {
    private static final JNIConfig INSTANCE = JDWPJNIConfig.createJNIConfig();

    public static JNIConfig getInstance() {
        return INSTANCE;
    }

    private static JNIConfig createJNIConfig() {
        JNIConfig.Builder builder = JNIConfig.newBuilder();
        builder.setAttachThreadAction(JDWPJNIConfig::attachCurrentThread);
        builder.registerMarshaller(Packet.class, new PacketMarshaller());
        EnumMarshaller<ErrorCode> errorCodeMarshaller = new EnumMarshaller<ErrorCode>(ErrorCode.class);
        CustomThrowableMarshaller throwableMarshaller = new CustomThrowableMarshaller(new JDWPExceptionMarshaller(errorCodeMarshaller), new DefaultThrowableMarshaller());
        builder.registerMarshaller(Throwable.class, throwableMarshaller);
        builder.registerMarshaller(StackFrame.class, new StackFrameMarshaller());
        return builder.build();
    }

    public static native long attachCurrentThread(long var0);

    private static final class PacketMarshaller
    implements BinaryMarshaller<Packet> {
        private PacketMarshaller() {
        }

        @Override
        public void write(BinaryOutput output, Packet object) {
            byte[] bytes = object.toByteArray();
            output.writeInt(bytes.length);
            output.write(bytes, 0, bytes.length);
        }

        @Override
        public Packet read(BinaryInput input) {
            int length = input.readInt();
            byte[] bytes = new byte[length];
            input.read(bytes, 0, bytes.length);
            return UnmodifiablePacket.parseAndWrap(bytes);
        }
    }

    private static final class EnumMarshaller<E extends Enum<E>>
    implements BinaryMarshaller<E> {
        private final E[] values;

        EnumMarshaller(Class<E> enumClass) {
            this.values = (Enum[])enumClass.getEnumConstants();
            if (this.values.length > 127) {
                throw new IllegalArgumentException("Only 127 enum constants are supported.");
            }
        }

        @Override
        public E read(BinaryInput input) {
            return this.values[input.readByte()];
        }

        @Override
        public void write(BinaryOutput output, E object) {
            output.writeByte(((Enum)object).ordinal());
        }

        @Override
        public int inferSize(E object) {
            return 1;
        }
    }

    static final class CustomThrowableMarshaller
    implements BinaryMarshaller<Throwable> {
        private final BinaryMarshaller<JDWPException> jdwpExceptionMarshaller;
        private final BinaryMarshaller<Throwable> fallbackThrowableMarshaller;

        private CustomThrowableMarshaller(BinaryMarshaller<JDWPException> jdwpExceptionMarshaller, BinaryMarshaller<Throwable> fallbackThrowableMarshaller) {
            this.jdwpExceptionMarshaller = jdwpExceptionMarshaller;
            this.fallbackThrowableMarshaller = fallbackThrowableMarshaller;
        }

        @Override
        public void write(BinaryOutput output, Throwable object) {
            boolean isJDWPException = object instanceof JDWPException;
            output.writeBoolean(isJDWPException);
            if (isJDWPException) {
                this.jdwpExceptionMarshaller.write(output, (JDWPException)object);
            } else {
                this.fallbackThrowableMarshaller.write(output, object);
            }
        }

        @Override
        public Throwable read(BinaryInput input) {
            boolean isJDWPException = input.readBoolean();
            if (isJDWPException) {
                return this.jdwpExceptionMarshaller.read(input);
            }
            return this.fallbackThrowableMarshaller.read(input);
        }

        @Override
        public int inferSize(Throwable object) {
            if (object instanceof JDWPException) {
                JDWPException jdwpException = (JDWPException)object;
                return this.jdwpExceptionMarshaller.inferSize(jdwpException) + 1;
            }
            return this.fallbackThrowableMarshaller.inferSize(object) + 1;
        }
    }

    private static final class JDWPExceptionMarshaller
    implements BinaryMarshaller<JDWPException> {
        private final BinaryMarshaller<StackTraceElement[]> stackTraceMarshaller;
        private final BinaryMarshaller<ErrorCode> errorCodeMarshaller;

        private JDWPExceptionMarshaller(BinaryMarshaller<ErrorCode> errorCodeMarshaller) {
            this.errorCodeMarshaller = errorCodeMarshaller;
            this.stackTraceMarshaller = JNIConfig.Builder.defaultStackTraceMarshaller();
        }

        @Override
        public void write(BinaryOutput output, JDWPException object) {
            this.errorCodeMarshaller.write(output, object.getError());
            this.stackTraceMarshaller.write(output, object.getStackTrace());
        }

        @Override
        public JDWPException read(BinaryInput input) {
            ErrorCode error = this.errorCodeMarshaller.read(input);
            StackTraceElement[] stackTraceElements = this.stackTraceMarshaller.read(input);
            JDWPException jdwpException = new JDWPException(error);
            jdwpException.setStackTrace(stackTraceElements);
            return jdwpException;
        }

        @Override
        public int inferSize(JDWPException object) {
            return this.errorCodeMarshaller.inferSize(object.getError()) + this.stackTraceMarshaller.inferSize(object.getStackTrace());
        }
    }

    static final class DefaultThrowableMarshaller
    implements BinaryMarshaller<Throwable> {
        private static final int THROWABLE_SIZE_ESTIMATE = 1024;
        private final BinaryMarshaller<StackTraceElement[]> stackTraceMarshaller = JNIConfig.Builder.defaultStackTraceMarshaller();

        DefaultThrowableMarshaller() {
        }

        @Override
        public Throwable read(BinaryInput in) {
            String foreignExceptionClassName = in.readUTF();
            String foreignExceptionMessage = (String)in.readTypedValue();
            StackTraceElement[] foreignExceptionStack = this.stackTraceMarshaller.read(in);
            return new MarshalledException(foreignExceptionClassName, foreignExceptionMessage, ForeignException.mergeStackTrace(foreignExceptionStack));
        }

        @Override
        public void write(BinaryOutput out, Throwable object) {
            out.writeUTF(object instanceof MarshalledException ? ((MarshalledException)object).getForeignExceptionClassName() : object.getClass().getName());
            out.writeTypedValue(object.getMessage());
            this.stackTraceMarshaller.write(out, object.getStackTrace());
        }

        @Override
        public int inferSize(Throwable object) {
            return 1024;
        }
    }

    private static final class StackFrameMarshaller
    implements BinaryMarshaller<StackFrame> {
        private static final int SIZE_OF_STACK_FRAME = 25;

        private StackFrameMarshaller() {
        }

        @Override
        public void write(BinaryOutput output, StackFrame frame) {
            output.writeByte(frame.typeTag());
            output.writeLong(frame.classId());
            output.writeLong(frame.methodId());
            output.writeInt(frame.bci());
            output.writeInt(frame.frameDepth());
        }

        @Override
        public StackFrame read(BinaryInput input) {
            byte typeTag = input.readByte();
            long classId = input.readLong();
            long methodId = input.readLong();
            int bci = input.readInt();
            int frameDepth = input.readInt();
            return new StackFrame(typeTag, classId, methodId, bci, frameDepth);
        }

        @Override
        public int inferSize(StackFrame frame) {
            return 25;
        }
    }
}

