/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.PacketWriterBuffer;
import com.oracle.svm.jdwp.bridge.PacketWriterBufferImpl;

public final class WritablePacket
implements Packet {
    private int id;
    private byte flags;
    private short errorCode;
    private byte commandSet;
    private byte command;
    private PacketWriterBuffer dataWriter = new PacketWriterBufferImpl();

    @Override
    public int id() {
        return this.id;
    }

    public WritablePacket id(int newId) {
        this.id = newId;
        return this;
    }

    @Override
    public byte flags() {
        return this.flags;
    }

    public WritablePacket flags(byte newFlags) {
        this.flags = newFlags;
        return this;
    }

    @Override
    public short errorCode() {
        return this.errorCode;
    }

    public WritablePacket errorCode(short newErrorCode) {
        this.errorCode = newErrorCode;
        return this;
    }

    public WritablePacket errorCode(ErrorCode newErrorCode) {
        this.errorCode = (short)newErrorCode.value();
        return this;
    }

    @Override
    public byte commandSet() {
        return this.commandSet;
    }

    public WritablePacket commandSet(byte newCommandSet) {
        this.commandSet = newCommandSet;
        return this;
    }

    @Override
    public byte command() {
        return this.command;
    }

    public WritablePacket command(byte newCommand) {
        this.command = newCommand;
        return this;
    }

    @Override
    public int dataSize() {
        return this.dataWriter.size();
    }

    @Override
    public byte data(int index) {
        return this.dataWriter.byteAt(index);
    }

    public Packet.Writer dataWriter() {
        return this.dataWriter;
    }

    public WritablePacket dataWriter(PacketWriterBuffer newDataWriter) {
        this.dataWriter = newDataWriter;
        return this;
    }

    public static WritablePacket newReplyTo(Packet pkt) {
        return new WritablePacket().id(pkt.id()).flags((byte)-128).errorCode((short)0);
    }

    public static WritablePacket commandPacket() {
        return new WritablePacket().commandSet((byte)64).command((byte)100);
    }
}

