/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident;

import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.interpreter.InterpreterFrameSourceInfo;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.ThreadSuspendSupport;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.DebuggerSupport;
import com.oracle.svm.interpreter.debug.DebuggerEvents;
import com.oracle.svm.interpreter.debug.EventKind;
import com.oracle.svm.interpreter.debug.Location;
import com.oracle.svm.interpreter.metadata.InterpreterUniverse;
import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.JDWP;
import com.oracle.svm.jdwp.bridge.JDWPBridge;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.StackFrame;
import com.oracle.svm.jdwp.bridge.TypeTag;
import com.oracle.svm.jdwp.resident.ClassUtils;
import com.oracle.svm.jdwp.resident.DebuggingOnDemandHandler;
import com.oracle.svm.jdwp.resident.JDWPThreadStatus;
import com.oracle.svm.jdwp.resident.ObjectIdMap;
import com.oracle.svm.jdwp.resident.ThreadStartDeathSupport;
import com.oracle.svm.jdwp.resident.impl.AllJavaFramesVisitor;
import com.oracle.svm.jdwp.resident.impl.ResidentJDWP;
import com.oracle.svm.jdwp.resident.impl.SafeStackWalker;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.IsolateThread;

public final class JDWPBridgeImpl
implements JDWPBridge {
    JDWP impl = new ResidentJDWP();
    private static final ObjectIdMap IDS = new ObjectIdMap();

    public static ObjectIdMap getIds() {
        return IDS;
    }

    @Override
    public void setEventEnabled(long threadId, int eventKind, boolean enable) {
        DebuggerEvents.singleton().setEventEnabled(JDWPBridgeImpl.getIds().toObject(threadId, Thread.class), EventKind.fromOrdinal(eventKind), enable);
    }

    @Override
    public boolean isEventEnabled(long threadId, int eventKind) {
        return DebuggerEvents.singleton().isEventEnabled(JDWPBridgeImpl.getIds().toObject(threadId, Thread.class), EventKind.fromOrdinal(eventKind));
    }

    @Override
    public void toggleBreakpoint(long methodId, int bci, boolean enable) {
        DebuggerEvents.singleton().toggleBreakpoint(JDWPBridgeImpl.getIds().toObject(methodId, ResolvedJavaMethod.class), bci, enable);
    }

    @Override
    public void toggleMethodEnterEvent(long clazzId, boolean enable) {
        DebuggerEvents.singleton().toggleMethodEnterEvent(JDWPBridgeImpl.getIds().toObject(clazzId, ResolvedJavaType.class), enable);
    }

    @Override
    public void toggleMethodExitEvent(long clazzId, boolean enable) {
        DebuggerEvents.singleton().toggleMethodExitEvent(JDWPBridgeImpl.getIds().toObject(clazzId, ResolvedJavaType.class), enable);
    }

    @Override
    public void setSteppingFromLocation(long threadId, int depth, int size, long methodId, int bci, int lineNumber) {
        DebuggerEvents.singleton().setSteppingFromLocation(JDWPBridgeImpl.getIds().toObject(threadId, Thread.class), depth, size, Location.create(JDWPBridgeImpl.getIds().toObject(methodId, ResolvedJavaMethod.class), bci, lineNumber));
    }

    @Override
    public void clearStepping(long threadId) {
        DebuggerEvents.singleton().clearStepping(JDWPBridgeImpl.getIds().toObject(threadId, Thread.class));
    }

    @Override
    public Packet dispatch(Packet packet) throws JDWPException {
        return this.impl.dispatch(packet);
    }

    @Override
    public int getThreadStatus(long threadId) {
        Thread thread = ResidentJDWP.getThread(threadId);
        return JDWPThreadStatus.getThreadStatus(thread);
    }

    @Override
    public long threadSuspend(long threadId) {
        return JDWPBridgeImpl.threadSuspendOrResume(true, threadId);
    }

    @Override
    public long threadResume(long threadId) {
        return JDWPBridgeImpl.threadSuspendOrResume(false, threadId);
    }

    private static long threadSuspendOrResume(boolean suspend, long threadId) {
        Thread thread = ResidentJDWP.getThread(threadId);
        if (!thread.isAlive()) {
            return -1L;
        }
        if (suspend) {
            ThreadSuspendSupport.suspend(thread);
        } else {
            ThreadSuspendSupport.resume(thread);
        }
        return 1L;
    }

    @Override
    public void setThreadRequest(boolean start, boolean enable) {
        ThreadStartDeathSupport.get().setListeningOn(start, enable);
    }

    @Override
    public long[] vmSuspend(long[] ignoredThreadIds) {
        SuspendAllOperation operation = new SuspendAllOperation(ignoredThreadIds);
        operation.enqueue();
        return operation.getSuspendedThreadIds();
    }

    @Override
    public void vmResume(long[] resumeThreadIds) {
        if (!DebuggingOnDemandHandler.suspendDoneOnShellSide()) {
            ResumeAllOperation operation = new ResumeAllOperation(resumeThreadIds);
            operation.enqueue();
        }
    }

    @Override
    public String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    @Override
    public long typeRefIndexToId(int typeRefIndex) {
        ResolvedJavaType typeAtIndex = DebuggerSupport.singleton().getUniverse().getTypeAtIndex(typeRefIndex);
        return JDWPBridgeImpl.getIds().getIdOrCreateWeak(typeAtIndex);
    }

    @Override
    public long fieldRefIndexToId(int fieldRefIndex) {
        ResolvedJavaField fieldAtIndex = DebuggerSupport.singleton().getUniverse().getFieldAtIndex(fieldRefIndex);
        return JDWPBridgeImpl.getIds().getIdOrCreateWeak(fieldAtIndex);
    }

    @Override
    public long methodRefIndexToId(int methodRefIndex) {
        ResolvedJavaMethod methodAtIndex = DebuggerSupport.singleton().getUniverse().getMethodAtIndex(methodRefIndex);
        return JDWPBridgeImpl.getIds().getIdOrCreateWeak(methodAtIndex);
    }

    @Override
    public int typeRefIdToIndex(long typeRefId) {
        ResolvedJavaType resolvedJavaType = null;
        try {
            resolvedJavaType = JDWPBridgeImpl.getIds().toObject(typeRefId, ResolvedJavaType.class);
        }
        catch (ClassCastException e) {
            throw JDWPException.raise(ErrorCode.INVALID_CLASS);
        }
        if (resolvedJavaType == null) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        OptionalInt methodRefIndex = DebuggerSupport.singleton().getUniverse().getTypeIndexFor(resolvedJavaType);
        return methodRefIndex.orElseThrow(() -> JDWPException.raise(ErrorCode.INVALID_CLASS));
    }

    @Override
    public int fieldRefIdToIndex(long fieldRefId) {
        ResolvedJavaField resolvedJavaField = null;
        try {
            resolvedJavaField = JDWPBridgeImpl.getIds().toObject(fieldRefId, ResolvedJavaField.class);
        }
        catch (ClassCastException e) {
            throw JDWPException.raise(ErrorCode.INVALID_FIELDID);
        }
        if (resolvedJavaField == null) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        OptionalInt typeRefIndex = DebuggerSupport.singleton().getUniverse().getFieldIndexFor(resolvedJavaField);
        return typeRefIndex.orElseThrow(() -> JDWPException.raise(ErrorCode.INVALID_FIELDID));
    }

    @Override
    public int methodRefIdToIndex(long methodRefId) {
        ResolvedJavaMethod resolvedJavaMethod = null;
        try {
            resolvedJavaMethod = JDWPBridgeImpl.getIds().toObject(methodRefId, ResolvedJavaMethod.class);
        }
        catch (ClassCastException e) {
            throw JDWPException.raise(ErrorCode.INVALID_METHODID);
        }
        if (resolvedJavaMethod == null) {
            throw JDWPException.raise(ErrorCode.INVALID_OBJECT);
        }
        OptionalInt methodRefIndex = DebuggerSupport.singleton().getUniverse().getMethodIndexFor(resolvedJavaMethod);
        return methodRefIndex.orElseThrow(() -> JDWPException.raise(ErrorCode.INVALID_METHODID));
    }

    @Override
    public String currentWorkingDirectory() {
        return Path.of("", new String[0]).toAbsolutePath().toString();
    }

    @Override
    public int[] typeStatus(long ... typeIds) {
        int[] result = new int[typeIds.length];
        for (int i = 0; i < typeIds.length; ++i) {
            ResolvedJavaType resolvedJavaType;
            long typeId = typeIds[i];
            Object type = JDWPBridgeImpl.getIds().getObject(typeId);
            if (type instanceof ResolvedJavaType) {
                resolvedJavaType = (ResolvedJavaType)type;
                OptionalInt typeIndex = DebuggerSupport.singleton().getUniverse().getTypeIndexFor(resolvedJavaType);
                if (typeIndex.isEmpty()) {
                    throw JDWPException.raise(ErrorCode.INVALID_CLASS);
                }
            } else {
                throw JDWPException.raise(ErrorCode.INVALID_CLASS);
            }
            result[i] = ClassUtils.getStatus(resolvedJavaType);
        }
        return result;
    }

    @Override
    public StackFrame[] getThreadFrames(long threadId) {
        Thread targetThread = JDWPBridgeImpl.getIds().toObject(threadId, Thread.class);
        AllJavaFramesVisitor getAllFrames = new AllJavaFramesVisitor(true);
        SafeStackWalker.safeStackWalk(targetThread, getAllFrames);
        List<FrameSourceInfo> frames = getAllFrames.getFrames();
        StackFrame[] stackFrames = new StackFrame[frames.size()];
        for (int i = 0; i < stackFrames.length; ++i) {
            FrameSourceInfo frameInfo = frames.get(i);
            Class<?> sourceClass = frameInfo.getSourceClass();
            ResolvedJavaType sourceType = DebuggerSupport.singleton().getUniverse().lookupType(sourceClass);
            ResolvedJavaMethod sourceMethod = JDWPBridgeImpl.findSourceMethod(sourceType, frameInfo);
            byte typeTag = TypeTag.getKind(sourceType);
            long classId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(sourceType);
            long methodId = JDWPBridgeImpl.getIds().getIdOrCreateWeak(sourceMethod);
            int bci = frameInfo.getBci();
            if (!sourceMethod.hasBytecodes()) {
                bci = -1;
            }
            int frameDepth = i;
            stackFrames[i] = new StackFrame(typeTag, classId, methodId, bci, frameDepth);
        }
        return stackFrames;
    }

    @Override
    public long getCurrentThis() {
        Object thisObject = ResidentJDWP.getThis(Thread.currentThread(), 0);
        return JDWPBridgeImpl.getIds().getIdOrCreateWeak(thisObject);
    }

    @Override
    public boolean isCurrentThreadVirtual() {
        return Thread.currentThread().isVirtual();
    }

    public static ResolvedJavaMethod findSourceMethod(ResolvedJavaType sourceType, FrameSourceInfo frameInfo) {
        InterpreterUniverse universe;
        ResolvedJavaMethod interpreterMethod;
        FrameInfoQueryResult compiledFrameInfo;
        int sourceMethodId;
        if (frameInfo instanceof InterpreterFrameSourceInfo) {
            InterpreterFrameSourceInfo interpreterFrameSourceInfo = (InterpreterFrameSourceInfo)frameInfo;
            assert (sourceType.equals((Object)interpreterFrameSourceInfo.getInterpretedMethod().getDeclaringClass()));
            return interpreterFrameSourceInfo.getInterpretedMethod();
        }
        if (frameInfo instanceof FrameInfoQueryResult && (sourceMethodId = (compiledFrameInfo = (FrameInfoQueryResult)frameInfo).getSourceMethodId()) != 0 && (interpreterMethod = (universe = DebuggerSupport.singleton().getUniverse()).getMethodFromMethodId(sourceMethodId)) != null) {
            assert (sourceType.equals((Object)interpreterMethod.getDeclaringClass()));
            assert (interpreterMethod.getName().equals(frameInfo.getSourceMethodName()));
            return interpreterMethod;
        }
        throw VMError.shouldNotReachHere("Cannot find method " + frameInfo.getSourceMethodName() + " in class " + frameInfo.getSourceClassName() + " at line " + frameInfo.getSourceLineNumber());
    }

    private static class SuspendAllOperation
    extends JavaVMOperation {
        private final Thread[] ignoredThreads;
        private Thread[] suspendedThreads;
        private int suspendedThreadsCount;

        SuspendAllOperation(long[] ignoredThreadIds) {
            super(VMOperationInfos.get(SuspendAllOperation.class, "All Threads Suspend", VMOperation.SystemEffect.SAFEPOINT));
            this.ignoredThreads = new Thread[ignoredThreadIds.length];
            for (int i = 0; i < ignoredThreadIds.length; ++i) {
                this.ignoredThreads[i] = JDWPBridgeImpl.getIds().toObject(ignoredThreadIds[i], Thread.class);
            }
        }

        @Override
        protected void operate() {
            Thread[] threads = new Thread[10];
            int i = 0;
            IsolateThread thread = VMThreads.firstThreadUnsafe();
            while (thread.isNonNull()) {
                block5: {
                    Thread t = ThreadStartDeathSupport.get().filterAppThread(thread);
                    if (t != null && PlatformThreads.getThreadStatus(t) != 2) {
                        for (Thread ignoredThread : this.ignoredThreads) {
                            if (ignoredThread != t) {
                                continue;
                            }
                            break block5;
                        }
                        ThreadSuspendSupport.suspend(t);
                        if (i >= threads.length) {
                            threads = Arrays.copyOf(threads, i + i / 2);
                        }
                        threads[i++] = t;
                    }
                }
                thread = VMThreads.nextThread(thread);
            }
            this.suspendedThreads = threads;
            this.suspendedThreadsCount = i;
        }

        long[] getSuspendedThreadIds() {
            long[] ids = new long[this.suspendedThreadsCount];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = JDWPBridgeImpl.getIds().getIdOrCreateWeak(this.suspendedThreads[i]);
            }
            return ids;
        }
    }

    private static class ResumeAllOperation
    extends JavaVMOperation {
        private final Thread[] resumeThreads;

        ResumeAllOperation(long[] resumeThreadIds) {
            super(VMOperationInfos.get(ResumeAllOperation.class, "All Threads Resume", VMOperation.SystemEffect.SAFEPOINT));
            this.resumeThreads = new Thread[resumeThreadIds.length];
            for (int i = 0; i < resumeThreadIds.length; ++i) {
                this.resumeThreads[i] = JDWPBridgeImpl.getIds().toObject(resumeThreadIds[i], Thread.class);
            }
        }

        @Override
        protected void operate() {
            for (Thread thread : this.resumeThreads) {
                if (thread == null) continue;
                ThreadSuspendSupport.resume(thread);
            }
        }
    }
}

