/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.invoke.MethodHandle;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeForeignAccessSupport;

public interface StronglyTypedRuntimeForeignAccessSupport
extends RuntimeForeignAccessSupport {
    private static FunctionDescriptor castDesc(Object descO) {
        if (descO instanceof FunctionDescriptor) {
            FunctionDescriptor desc = (FunctionDescriptor)descO;
            return desc;
        }
        throw new IllegalArgumentException("Desc must be an instance of " + String.valueOf(FunctionDescriptor.class) + "; was " + String.valueOf(descO.getClass()));
    }

    private static Linker.Option[] castOptions(Object ... optionsO) {
        Linker.Option[] options = new Linker.Option[optionsO.length];
        for (int i = 0; i < optionsO.length; ++i) {
            if (!(optionsO[i] instanceof Linker.Option)) {
                throw new IllegalArgumentException("Option at position " + i + " must be an instance of " + String.valueOf(Linker.Option.class));
            }
            options[i] = (Linker.Option)optionsO[i];
        }
        return options;
    }

    public static StronglyTypedRuntimeForeignAccessSupport make(final Recorder forDowncalls, final Recorder forUpcalls, final DirectUpcallRecorder forDirectUpcalls) {
        return new StronglyTypedRuntimeForeignAccessSupport(){

            @Override
            public void registerForDowncall(ConfigurationCondition condition, FunctionDescriptor desc, Linker.Option ... options) {
                forDowncalls.apply(condition, desc, options);
            }

            @Override
            public void registerForUpcall(ConfigurationCondition condition, FunctionDescriptor desc, Linker.Option ... options) {
                forUpcalls.apply(condition, desc, options);
            }

            @Override
            public void registerForDirectUpcall(ConfigurationCondition condition, MethodHandle target, FunctionDescriptor fd, Linker.Option ... options) {
                forDirectUpcalls.apply(condition, target, fd, options);
            }
        };
    }

    default public void registerForDowncall(ConfigurationCondition condition, Object descO, Object ... optionsO) {
        this.registerForDowncall(condition, StronglyTypedRuntimeForeignAccessSupport.castDesc(descO), StronglyTypedRuntimeForeignAccessSupport.castOptions(optionsO));
    }

    public void registerForDowncall(ConfigurationCondition var1, FunctionDescriptor var2, Linker.Option ... var3);

    default public void registerForUpcall(ConfigurationCondition condition, Object descO, Object ... optionsO) {
        this.registerForUpcall(condition, StronglyTypedRuntimeForeignAccessSupport.castDesc(descO), StronglyTypedRuntimeForeignAccessSupport.castOptions(optionsO));
    }

    public void registerForUpcall(ConfigurationCondition var1, FunctionDescriptor var2, Linker.Option ... var3);

    default public void registerForDirectUpcall(ConfigurationCondition condition, MethodHandle target, Object desc, Object ... options) {
        this.registerForDirectUpcall(condition, target, StronglyTypedRuntimeForeignAccessSupport.castDesc(desc), StronglyTypedRuntimeForeignAccessSupport.castOptions(options));
    }

    public void registerForDirectUpcall(ConfigurationCondition var1, MethodHandle var2, FunctionDescriptor var3, Linker.Option ... var4);

    @FunctionalInterface
    public static interface Recorder {
        public void apply(ConfigurationCondition var1, FunctionDescriptor var2, Linker.Option ... var3);
    }

    @FunctionalInterface
    public static interface DirectUpcallRecorder {
        public void apply(ConfigurationCondition var1, MethodHandle var2, FunctionDescriptor var3, Linker.Option ... var4);
    }
}

