/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config.conditional;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.ConfigurationFile;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.conditional.ConditionalConfigurationPredicate;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.configure.config.conditional.MethodCallNode;
import com.oracle.svm.configure.config.conditional.MethodInfo;
import com.oracle.svm.configure.filters.ComplexFilter;
import com.oracle.svm.util.TypeResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConditionalConfigurationComputer {
    private final MethodCallNode rootNode;
    private final ComplexFilter userCodeFilter;
    private final ConditionalConfigurationPredicate configurationFilter;

    public ConditionalConfigurationComputer(MethodCallNode rootNode, ComplexFilter userCodeFilter, ConditionalConfigurationPredicate configurationFilter) {
        this.rootNode = rootNode;
        this.userCodeFilter = userCodeFilter;
        this.configurationFilter = configurationFilter;
    }

    public ConfigurationSet computeConditionalConfiguration() {
        this.retainOnlyUserCodeMethodCallNodes();
        Map<MethodInfo, List<MethodCallNode>> methodCallNodes = this.mapMethodsToCallNodes();
        ConditionalConfigurationComputer.propagateConfiguration(methodCallNodes);
        return this.inferConditionalConfiguration(methodCallNodes);
    }

    private void retainOnlyUserCodeMethodCallNodes() {
        this.retainOnlyUserCodeMethodCallNodes(this.rootNode);
    }

    private void retainOnlyUserCodeMethodCallNodes(MethodCallNode node) {
        ArrayList<MethodCallNode> calledMethods = new ArrayList<MethodCallNode>(node.calledMethods.values());
        for (MethodCallNode child2 : calledMethods) {
            this.retainOnlyUserCodeMethodCallNodes(child2);
        }
        node.calledMethods.values().removeIf(child -> {
            if (!this.userCodeFilter.includes(child.methodInfo.getJavaDeclaringClassName())) {
                child.parent.mergeSubTree((MethodCallNode)child, child.parent != this.rootNode);
                return true;
            }
            return false;
        });
    }

    private Map<MethodInfo, List<MethodCallNode>> mapMethodsToCallNodes() {
        HashMap<MethodInfo, List<MethodCallNode>> methodCallNodes = new HashMap<MethodInfo, List<MethodCallNode>>();
        ConfigurationSet emptyConfigurationSet = new ConfigurationSet();
        this.rootNode.visitPostOrder(node -> {
            if (node.configuration == null) {
                node.configuration = emptyConfigurationSet;
            }
            List callNodes = methodCallNodes.computeIfAbsent(node.methodInfo, info -> new ArrayList());
            callNodes.add(node);
        });
        return methodCallNodes;
    }

    private static Set<MethodInfo> maybePropagateConfiguration(List<MethodCallNode> callNodes) {
        if (callNodes.size() <= 1) {
            return Collections.emptySet();
        }
        ConfigurationSet commonConfig = ConditionalConfigurationComputer.findCommonConfigurationForMethod(callNodes);
        boolean commonConfigIsEmpty = commonConfig.isEmpty();
        ConfigurationSet[] configsToPropagate = new ConfigurationSet[callNodes.size()];
        boolean configsToPropagateAllEmpty = true;
        for (int i = 0; i < callNodes.size(); ++i) {
            configsToPropagate[i] = commonConfigIsEmpty ? callNodes.get((int)i).configuration : callNodes.get((int)i).configuration.copyAndSubtract(commonConfig);
            configsToPropagateAllEmpty = configsToPropagateAllEmpty && configsToPropagate[i].isEmpty();
        }
        if (configsToPropagateAllEmpty) {
            return Collections.emptySet();
        }
        HashSet<MethodInfo> nodesWithPropagatedConfig = new HashSet<MethodInfo>();
        for (int i = 0; i < callNodes.size(); ++i) {
            if (configsToPropagate[i].isEmpty()) continue;
            MethodCallNode node = callNodes.get(i);
            MethodCallNode nodeToUpdate = ConditionalConfigurationComputer.getFirstDifferingAncestor(node);
            node.configuration = new ConfigurationSet(commonConfig);
            nodeToUpdate.configuration = nodeToUpdate.configuration.copyAndMerge(configsToPropagate[i]);
            nodesWithPropagatedConfig.add(nodeToUpdate.methodInfo);
        }
        return nodesWithPropagatedConfig;
    }

    private static MethodCallNode getFirstDifferingAncestor(MethodCallNode method) {
        assert (method.methodInfo != null);
        MethodCallNode current = method;
        do {
            current = current.parent;
        } while (method.methodInfo.equals(current.methodInfo));
        return current;
    }

    private static ConfigurationSet findCommonConfigurationForMethod(List<MethodCallNode> callNodes) {
        ConfigurationSet config = null;
        for (MethodCallNode node : callNodes) {
            if (config == null) {
                config = node.configuration;
                continue;
            }
            config = config.copyAndIntersectWith(node.configuration);
        }
        return config;
    }

    private ConfigurationSet inferConditionalConfiguration(Map<MethodInfo, List<MethodCallNode>> methodCallNodes) {
        ConfigurationSet configurationSet = new ConfigurationSet();
        MethodCallNode rootCallNode = methodCallNodes.remove(null).getFirst();
        ConditionalConfigurationComputer.addConfigurationWithCondition(configurationSet, rootCallNode.configuration, UnresolvedConfigurationCondition.alwaysTrue());
        for (List<MethodCallNode> list : methodCallNodes.values()) {
            ConfigurationSet configurationToAdd = list.getFirst().configuration;
            assert (list.stream().allMatch(node -> node.configuration.equals(configurationToAdd))) : "The ";
            for (MethodCallNode node2 : list) {
                String className = node2.methodInfo.getJavaDeclaringClassName();
                UnresolvedConfigurationCondition condition = UnresolvedConfigurationCondition.create(NamedConfigurationTypeDescriptor.fromJSONName(className));
                TypeResult<UnresolvedConfigurationCondition> resolvedCondition = ConfigurationConditionResolver.identityResolver().resolveCondition(condition);
                ConditionalConfigurationComputer.addConfigurationWithCondition(configurationSet, node2.configuration, (UnresolvedConfigurationCondition)resolvedCondition.get());
            }
        }
        return configurationSet.filter(this.configurationFilter);
    }

    private static <T extends ConfigurationBase<T, ?>> void mergeWithCondition(ConfigurationSet destConfigSet, ConfigurationSet srcConfigSet, UnresolvedConfigurationCondition condition, ConfigurationFile configType) {
        Object destConfig = destConfigSet.getConfiguration(configType);
        Object srcConfig = srcConfigSet.getConfiguration(configType);
        ((ConfigurationBase)destConfig).mergeConditional(condition, srcConfig);
    }

    private static void addConfigurationWithCondition(ConfigurationSet destConfigSet, ConfigurationSet srcConfigSet, UnresolvedConfigurationCondition condition) {
        for (ConfigurationFile configType : ConfigurationFile.agentGeneratedFiles()) {
            ConditionalConfigurationComputer.mergeWithCondition(destConfigSet, srcConfigSet, condition, configType);
        }
    }

    private static void propagateConfiguration(Map<MethodInfo, List<MethodCallNode>> methodCallNodes) {
        Set<MethodInfo> worklist = methodCallNodes.keySet();
        while (!worklist.isEmpty()) {
            HashSet<MethodInfo> newWorkList = new HashSet<MethodInfo>();
            for (List<MethodCallNode> callNodes : methodCallNodes.values()) {
                newWorkList.addAll(ConditionalConfigurationComputer.maybePropagateConfiguration(callNodes));
            }
            worklist = newWorkList;
        }
    }
}

