/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.filters;

import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.filters.ConfigurationFilter;
import com.oracle.svm.configure.filters.FilterConfigurationParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.collections.EconomicMap;

public final class HierarchyFilterNode
implements ConfigurationFilter {
    private static final ConfigurationFilter.Inclusion DEFAULT_INCLUSION = ConfigurationFilter.Inclusion.Exclude;
    private static final String CHILDREN_PATTERN = "*";
    private static final String DESCENDANTS_PATTERN = "**";
    private final String name;
    private ConfigurationFilter.Inclusion inclusion;
    private ConfigurationFilter.Inclusion childrenInclusion;
    private ConfigurationFilter.Inclusion descendantsInclusion;
    private Map<String, HierarchyFilterNode> children;

    public static HierarchyFilterNode createRoot() {
        return new HierarchyFilterNode("");
    }

    public static HierarchyFilterNode createInclusiveRoot() {
        HierarchyFilterNode root = new HierarchyFilterNode("");
        root.inclusion = ConfigurationFilter.Inclusion.Include;
        root.addOrGetChildren(DESCENDANTS_PATTERN, ConfigurationFilter.Inclusion.Include);
        return root;
    }

    private HierarchyFilterNode(String unqualifiedName) {
        this.name = unqualifiedName;
    }

    public void addOrGetChildren(String qualifiedName, ConfigurationFilter.Inclusion leafInclusion) {
        if (leafInclusion != ConfigurationFilter.Inclusion.Include && leafInclusion != ConfigurationFilter.Inclusion.Exclude) {
            throw new IllegalArgumentException(String.valueOf((Object)leafInclusion) + " not supported");
        }
        HierarchyFilterNode parent = this;
        StringTokenizer tokenizer = new StringTokenizer(qualifiedName, ".", false);
        while (tokenizer.hasMoreTokens()) {
            boolean isPattern;
            String token = tokenizer.nextToken();
            boolean isLeaf = !tokenizer.hasMoreTokens();
            boolean bl = isPattern = token.indexOf(42) != -1;
            if (isPattern) {
                boolean recursive = token.equals(DESCENDANTS_PATTERN);
                if (!isLeaf || !recursive && !token.equals(CHILDREN_PATTERN)) {
                    throw new IllegalArgumentException(qualifiedName + ": only * and ** are allowed as the entire pattern (no complex patterns), and only in the last position");
                }
                if (recursive) {
                    parent.descendantsInclusion = leafInclusion;
                    parent.childrenInclusion = null;
                    parent.children = null;
                    continue;
                }
                parent.childrenInclusion = leafInclusion;
                if (parent.children == null) continue;
                parent.children.values().removeIf(c -> {
                    c.inclusion = null;
                    return c.isRedundantLeaf();
                });
                continue;
            }
            HierarchyFilterNode node = null;
            if (parent.children != null) {
                node = parent.children.get(token);
            } else {
                parent.children = new HashMap<String, HierarchyFilterNode>();
            }
            if (node != null) {
                if (isLeaf) {
                    node.inclusion = leafInclusion;
                }
            } else {
                node = new HierarchyFilterNode(token);
                node.inclusion = isLeaf ? leafInclusion : null;
                parent.children.put(token, node);
            }
            parent = node;
        }
    }

    private boolean isLeafNode() {
        return this.children == null || this.children.isEmpty();
    }

    public void reduceExhaustiveTree() {
        if (this.children != null) {
            for (HierarchyFilterNode child : this.children.values()) {
                child.reduceExhaustiveTree0();
            }
        }
        this.removeRedundantNodes();
    }

    private int reduceExhaustiveTree0() {
        if (this.descendantsInclusion != null) {
            throw new IllegalStateException("Recursive rules are not allowed");
        }
        if (this.children != null) {
            int sum = 0;
            for (HierarchyFilterNode child : this.children.values()) {
                sum += child.reduceExhaustiveTree0();
            }
            if (this.descendantsInclusion == null) {
                this.descendantsInclusion = sum > 0 ? ConfigurationFilter.Inclusion.Include : ConfigurationFilter.Inclusion.Exclude;
            }
        }
        int score = 0;
        score = HierarchyFilterNode.addToScore(this.inclusion, score);
        score = HierarchyFilterNode.addToScore(this.childrenInclusion, score);
        score = HierarchyFilterNode.addToScore(this.descendantsInclusion, score);
        return score;
    }

    private static int addToScore(ConfigurationFilter.Inclusion inclusion, int score) {
        if (inclusion == ConfigurationFilter.Inclusion.Include) {
            return score + 1;
        }
        if (inclusion == ConfigurationFilter.Inclusion.Exclude) {
            return score - 1;
        }
        return score;
    }

    public void removeRedundantNodes() {
        this.removeRedundantDescendants(DEFAULT_INCLUSION);
    }

    private void removeRedundantDescendants(ConfigurationFilter.Inclusion inheritedDescendantsInclusion) {
        if (!this.isLeafNode()) {
            ConfigurationFilter.Inclusion descendantsDefaultInclusion = this.descendantsInclusion != null ? this.descendantsInclusion : inheritedDescendantsInclusion;
            ConfigurationFilter.Inclusion childrenDefaultInclusion = this.childrenInclusion != null ? this.childrenInclusion : descendantsDefaultInclusion;
            this.children.values().removeIf(c -> c.removeRedundantNodes(childrenDefaultInclusion, descendantsDefaultInclusion));
        }
    }

    private boolean removeRedundantNodes(ConfigurationFilter.Inclusion defaultInclusion, ConfigurationFilter.Inclusion descendantsDefaultInclusion) {
        assert (defaultInclusion == ConfigurationFilter.Inclusion.Include || descendantsDefaultInclusion == ConfigurationFilter.Inclusion.Exclude);
        assert (descendantsDefaultInclusion == ConfigurationFilter.Inclusion.Include || descendantsDefaultInclusion == ConfigurationFilter.Inclusion.Exclude);
        this.removeRedundantDescendants(descendantsDefaultInclusion);
        if (this.inclusion == defaultInclusion) {
            this.inclusion = null;
        }
        if (this.descendantsInclusion == descendantsDefaultInclusion) {
            this.descendantsInclusion = null;
        }
        if (this.childrenInclusion == this.descendantsInclusion || this.descendantsInclusion == null && this.childrenInclusion == descendantsDefaultInclusion) {
            this.childrenInclusion = null;
        }
        return this.isRedundantLeaf();
    }

    private boolean isRedundantLeaf() {
        return this.inclusion == null && this.childrenInclusion == null && this.descendantsInclusion == null && this.isLeafNode();
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.quote("rules").append(": [").indent().newline();
        boolean[] isFirstRule = new boolean[]{true};
        this.printJsonEntries(writer, isFirstRule, "");
        writer.unindent().newline();
        writer.append(']');
    }

    @Override
    public void parseFromJson(EconomicMap<String, Object> top) {
        Object rulesObject = top.get((Object)"rules");
        if (rulesObject != null) {
            List<Object> rulesList = ConfigurationParser.asList(rulesObject, "Attribute 'list' must be a list of rule objects");
            for (Object entryObject : rulesList) {
                FilterConfigurationParser.parseEntry(entryObject, this::addOrGetChildren);
            }
        }
    }

    private void printJsonEntries(JsonWriter writer, boolean[] isFirstRule, String parentQualified) throws IOException {
        String qualified = parentQualified.isEmpty() ? this.name : parentQualified + "." + this.name;
        Object patternBegin = qualified.isEmpty() ? qualified : qualified + ".";
        FilterConfigurationParser.printEntry(writer, isFirstRule, this.descendantsInclusion, (String)patternBegin + DESCENDANTS_PATTERN);
        FilterConfigurationParser.printEntry(writer, isFirstRule, this.childrenInclusion, (String)patternBegin + CHILDREN_PATTERN);
        FilterConfigurationParser.printEntry(writer, isFirstRule, this.inclusion, qualified);
        if (this.children != null) {
            HierarchyFilterNode[] sorted = this.children.values().toArray(new HierarchyFilterNode[0]);
            Arrays.sort(sorted, Comparator.comparing(child -> child.name));
            for (HierarchyFilterNode child2 : sorted) {
                child2.printJsonEntries(writer, isFirstRule, qualified);
            }
        }
    }

    @Override
    public boolean includes(String qualifiedName) {
        HierarchyFilterNode current = this;
        ConfigurationFilter.Inclusion inheritedInclusion = DEFAULT_INCLUSION;
        StringTokenizer tokenizer = new StringTokenizer(qualifiedName, ".", false);
        while (tokenizer.hasMoreTokens()) {
            HierarchyFilterNode child;
            if (current.descendantsInclusion != null) {
                inheritedInclusion = current.descendantsInclusion;
            }
            String part = tokenizer.nextToken();
            HierarchyFilterNode hierarchyFilterNode = child = current.children != null ? current.children.get(part) : null;
            if (child == null) {
                boolean isDirectChild;
                boolean bl = isDirectChild = !tokenizer.hasMoreTokens();
                if (isDirectChild && current.childrenInclusion != null) {
                    return current.childrenInclusion == ConfigurationFilter.Inclusion.Include;
                }
                return inheritedInclusion == ConfigurationFilter.Inclusion.Include;
            }
            current = child;
        }
        return current.inclusion == ConfigurationFilter.Inclusion.Include;
    }

    public HierarchyFilterNode copy() {
        HierarchyFilterNode copy = new HierarchyFilterNode(this.name);
        copy.inclusion = this.inclusion;
        copy.childrenInclusion = this.childrenInclusion;
        copy.descendantsInclusion = this.descendantsInclusion;
        if (this.children != null) {
            copy.children = new HashMap<String, HierarchyFilterNode>();
            for (Map.Entry<String, HierarchyFilterNode> entry : this.children.entrySet()) {
                HierarchyFilterNode childCopy = entry.getValue().copy();
                copy.children.put(entry.getKey(), childCopy);
            }
        }
        return copy;
    }
}

