/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.LambdaConfigurationTypeDescriptor;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.ProxyConfigurationTypeDescriptor;
import com.oracle.svm.configure.config.ConfigurationSet;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import org.graalvm.collections.EconomicMap;

public abstract class AbstractProcessor {
    AbstractProcessor() {
    }

    abstract void processEntry(EconomicMap<String, Object> var1, ConfigurationSet var2);

    void setInLivePhase(boolean live) {
    }

    static <T> T singleElement(List<?> list) {
        AbstractProcessor.expectSize(list, 1);
        return (T)list.get(0);
    }

    static void expectSize(Collection<?> collection, int size) {
        if (collection.size() != size) {
            throw new IllegalArgumentException("List must have exactly " + size + " element(s)");
        }
    }

    static byte[] asBinary(Object obj) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return Base64.getDecoder().decode((String)obj);
    }

    protected EconomicMap<String, Object> copyWithUniqueEntry(EconomicMap<String, Object> entry, String key, Object value) {
        if (entry.containsKey((Object)key)) {
            throw new AssertionError((Object)String.format("Tried to set unique identifier %s but field already exists: %s%n", key, entry));
        }
        EconomicMap result = EconomicMap.create(entry);
        result.put((Object)key, value);
        return result;
    }

    protected static ConfigurationTypeDescriptor descriptorForClass(Object clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz instanceof ConfigurationTypeDescriptor) {
            ConfigurationTypeDescriptor typeDescriptor = (ConfigurationTypeDescriptor)clazz;
            return typeDescriptor;
        }
        if (clazz instanceof EconomicMap) {
            EconomicMap map = (EconomicMap)clazz;
            if (map.containsKey((Object)"lambda")) {
                String declaringClass = (String)map.get((Object)"declaringClass");
                List interfaces = (List)map.get((Object)"interfaces");
                return LambdaConfigurationTypeDescriptor.fromTypeNames(declaringClass, interfaces);
            }
            if (map.containsKey((Object)"proxy")) {
                List interfaces = (List)map.get((Object)"proxy");
                return ProxyConfigurationTypeDescriptor.fromInterfaceTypeNames(interfaces);
            }
            throw new IllegalArgumentException("Unknown descriptor type: " + String.valueOf(clazz));
        }
        if (clazz instanceof List) {
            return ProxyConfigurationTypeDescriptor.fromInterfaceReflectionNames((List)clazz);
        }
        return NamedConfigurationTypeDescriptor.fromReflectionName((String)clazz);
    }
}

