/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.JsonFileWriter;
import com.oracle.svm.configure.filters.ConfigurationFilter;
import com.oracle.svm.configure.filters.HierarchyFilterNode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.regex.Pattern;
import jdk.graal.compiler.phases.common.LazyValue;
import org.graalvm.collections.EconomicMap;

public final class AccessAdvisor {
    public static final Pattern PROXY_CLASS_NAME_PATTERN = Pattern.compile("^(.+[/.])?\\$Proxy[0-9]+$");
    private static final HierarchyFilterNode internalCallerFilter = HierarchyFilterNode.createInclusiveRoot();
    private static final HierarchyFilterNode internalAccessFilter;
    private static final HierarchyFilterNode accessWithoutCallerFilter;
    private final boolean heuristicsEnabled;
    private final ConfigurationFilter callerFilter;
    private final ConfigurationFilter accessFilter;
    private final JsonFileWriter ignoredEntriesTracer;
    private boolean isInLivePhase = false;
    private int launchPhase = 0;
    private static final JNICallDescriptor[] JNI_STARTUP_SEQUENCE;
    private static final int JNI_STARTUP_COMPLETE;
    private static final int JNI_STARTUP_MISMATCH_COMPLETE;

    private static void excludeInaccessiblePackages(HierarchyFilterNode rootNode) {
        rootNode.addOrGetChildren("com.oracle.graal.**", ConfigurationFilter.Inclusion.Exclude);
        rootNode.addOrGetChildren("com.oracle.truffle.**", ConfigurationFilter.Inclusion.Exclude);
        rootNode.addOrGetChildren("jdk.graal.compiler.**", ConfigurationFilter.Inclusion.Exclude);
        rootNode.addOrGetChildren("org.graalvm.compiler.**", ConfigurationFilter.Inclusion.Exclude);
    }

    public static HierarchyFilterNode copyBuiltinCallerFilterTree() {
        return internalCallerFilter.copy();
    }

    public static HierarchyFilterNode copyBuiltinAccessFilterTree() {
        return internalAccessFilter.copy();
    }

    public AccessAdvisor(boolean heuristicsEnabled, ConfigurationFilter callerFilter, ConfigurationFilter accessFilter, String ignoredEntriesFile) {
        this.heuristicsEnabled = heuristicsEnabled;
        this.callerFilter = callerFilter == null ? internalCallerFilter : callerFilter;
        this.accessFilter = accessFilter == null ? internalAccessFilter : accessFilter;
        JsonFileWriter ignoredEntriesTracerLocal = null;
        if (ignoredEntriesFile != null) {
            try {
                ignoredEntriesTracerLocal = new JsonFileWriter(Path.of(ignoredEntriesFile, new String[0]));
            }
            catch (IOException ex) {
                System.err.printf("%s: could not open file \"%s\" to log ignored entries. No logging will be performed.%n", AccessAdvisor.class.getName(), ignoredEntriesFile);
            }
        }
        this.ignoredEntriesTracer = ignoredEntriesTracerLocal;
    }

    public void setInLivePhase(boolean live) {
        if (this.isInLivePhase && !live && this.ignoredEntriesTracer != null) {
            this.ignoredEntriesTracer.close();
        }
        this.isInLivePhase = live;
    }

    public boolean shouldIgnore(LazyValue<String> queriedClass, LazyValue<String> callerClass, boolean useLambdaHeuristics, EconomicMap<String, Object> entry) {
        if (this.heuristicsEnabled && !this.isInLivePhase) {
            this.logIgnoredEntry("not in live phase", entry);
            return true;
        }
        String qualifiedCaller = (String)callerClass.get();
        assert (qualifiedCaller == null || qualifiedCaller.indexOf(47) == -1) : "expecting Java-format qualifiers, not internal format";
        if (qualifiedCaller != null && !this.callerFilter.includes(qualifiedCaller)) {
            this.logIgnoredEntry("excluded by caller filter", entry);
            return true;
        }
        if (callerClass.get() == null && queriedClass.get() != null && !accessWithoutCallerFilter.includes((String)queriedClass.get())) {
            this.logIgnoredEntry("excluded by caller-less access filter", entry);
            return true;
        }
        if (this.accessFilter != null && queriedClass.get() != null && !this.accessFilter.includes((String)queriedClass.get())) {
            this.logIgnoredEntry("excluded by access filter", entry);
            return true;
        }
        if (this.heuristicsEnabled && queriedClass.get() != null) {
            if (useLambdaHeuristics && ((String)queriedClass.get()).contains("$$Lambda")) {
                this.logIgnoredEntry("lambda class", entry);
                return true;
            }
            if (PROXY_CLASS_NAME_PATTERN.matcher((CharSequence)queriedClass.get()).matches()) {
                this.logIgnoredEntry("proxy class", entry);
                return true;
            }
        }
        return false;
    }

    public boolean shouldIgnore(LazyValue<String> queriedClass, LazyValue<String> callerClass, EconomicMap<String, Object> entry) {
        return this.shouldIgnore(queriedClass, callerClass, true, entry);
    }

    public boolean shouldIgnoreJniLookup(String jniFunction, LazyValue<String> queriedClass, LazyValue<String> name, LazyValue<String> signature, LazyValue<String> callerClass, EconomicMap<String, Object> entry) {
        if (this.shouldIgnore(queriedClass, callerClass, entry) && this.isInLivePhase) {
            throw new AssertionError((Object)"Must check shouldIgnore before shouldIgnoreJniLookup");
        }
        if (!this.heuristicsEnabled || this.launchPhase >= JNI_STARTUP_COMPLETE) {
            return false;
        }
        if (!"GetStaticMethodID".equals(jniFunction) && !"GetMethodID".equals(jniFunction)) {
            this.logIgnoredEntry("JNI startup sequence not completed", entry);
            return true;
        }
        JNICallDescriptor expectedCall = JNI_STARTUP_SEQUENCE[this.launchPhase];
        while (!expectedCall.matches(jniFunction, (String)queriedClass.get(), (String)name.get(), (String)signature.get())) {
            if ("sun.launcher.LauncherHelper".equals(queriedClass.get())) {
                this.logIgnoredEntry("calls from sun.launcher.LauncherHelper are ignored", entry);
                return true;
            }
            if (expectedCall.required) {
                System.err.printf("%s: Warning: Observed unexpected JNI call to %s (%s). Tracing all subsequent JNI accesses.%n", AccessAdvisor.class.getName(), jniFunction, entry);
                this.launchPhase = JNI_STARTUP_MISMATCH_COMPLETE;
                return false;
            }
            ++this.launchPhase;
            expectedCall = JNI_STARTUP_SEQUENCE[this.launchPhase];
        }
        ++this.launchPhase;
        this.logIgnoredEntry(String.format("method %d in JNI startup sequence", this.launchPhase), entry);
        return true;
    }

    public boolean shouldIgnoreResourceLookup(LazyValue<String> resource, EconomicMap<String, Object> entry) {
        boolean result = Set.of("META-INF/services/jdk.vm.ci.services.JVMCIServiceLocator", "META-INF/services/java.lang.System$LoggerFinder", "META-INF/services/jdk.vm.ci.hotspot.HotSpotJVMCIBackendFactory", "META-INF/services/jdk.graal.compiler.options.OptionDescriptors", "META-INF/services/com.oracle.graal.phases.preciseinline.priorityinline.PolicyFactory").contains(resource.get());
        if (result) {
            this.logIgnoredEntry("blocklisted resource", entry);
        }
        return result;
    }

    public boolean shouldIgnoreLoadClass(LazyValue<String> queriedClass, LazyValue<String> callerClass, EconomicMap<String, Object> entry) {
        boolean result;
        if (this.shouldIgnore(queriedClass, callerClass, entry) && this.isInLivePhase) {
            throw new AssertionError((Object)"Must check shouldIgnore before shouldIgnoreLoadClass");
        }
        if (!this.heuristicsEnabled) {
            return false;
        }
        boolean bl = result = callerClass.get() == null;
        if (result) {
            this.logIgnoredEntry("class load without a caller", entry);
        }
        return result;
    }

    private void logIgnoredEntry(String reason, EconomicMap<String, Object> entry) {
        if (this.ignoredEntriesTracer != null) {
            if (entry.containsKey((Object)"reason")) {
                throw new AssertionError((Object)("Entry has unexpected \"reason\" key: " + String.valueOf(entry)));
            }
            entry.put((Object)"reason", (Object)reason);
            this.ignoredEntriesTracer.printObject(entry);
        }
    }

    static {
        internalCallerFilter.addOrGetChildren("com.sun.crypto.provider.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("com.sun.java.util.jar.pack.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("com.sun.net.ssl.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("com.sun.nio.file.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("com.sun.nio.sctp.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("com.sun.nio.zipfs.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.io.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.io.ObjectInputFilter$Config", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.lang.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.lang.ClassLoader", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.lang.ClassLoader$NativeLibrary", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.lang.Module", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.math.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.net.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.net.URLConnection", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.nio.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.text.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.time.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.util.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.util.concurrent.atomic.*", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.util.concurrent.atomic.AtomicReference", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.util.Collections", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.util.logging.LogRecord", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.util.random.*", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.util.ServiceLoader$LazyClassPathLookupIterator", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("javax.crypto.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("javax.lang.model.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("javax.net.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("javax.tools.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("jdk.internal.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("jdk.internal.loader.BootLoader", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("jdk.internal.loader.NativeLibraries$NativeLibraryImpl", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("jdk.jfr.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("jdk.net.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("jdk.nio.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("jdk.vm.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.invoke.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.invoke.util.BytecodeDescriptor", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("sun.launcher.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.management.ManagementFactoryHelper$LoggingMXBeanAccess", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.misc.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.net.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.net.www.protocol.http.*", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("sun.nio.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.reflect.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.reflect.misc.*", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("sun.text.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.util.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.util.resources.Bundles", ConfigurationFilter.Inclusion.Include);
        AccessAdvisor.excludeInaccessiblePackages(internalCallerFilter);
        internalCallerFilter.removeRedundantNodes();
        internalAccessFilter = HierarchyFilterNode.createInclusiveRoot();
        AccessAdvisor.excludeInaccessiblePackages(internalAccessFilter);
        internalAccessFilter.removeRedundantNodes();
        accessWithoutCallerFilter = HierarchyFilterNode.createInclusiveRoot();
        accessWithoutCallerFilter.addOrGetChildren("jdk.vm.ci.**", ConfigurationFilter.Inclusion.Exclude);
        accessWithoutCallerFilter.addOrGetChildren("[Ljava.lang.String;", ConfigurationFilter.Inclusion.Exclude);
        accessWithoutCallerFilter.removeRedundantNodes();
        JNI_STARTUP_SEQUENCE = new JNICallDescriptor[]{new JNICallDescriptor("GetStaticMethodID", "sun.launcher.LauncherHelper", "getApplicationClass", "()Ljava/lang/Class;", true), new JNICallDescriptor("GetMethodID", "java.lang.Class", "getCanonicalName", "()Ljava/lang/String;", false), new JNICallDescriptor("GetMethodID", "java.lang.String", "lastIndexOf", "(I)I", false), new JNICallDescriptor("GetMethodID", "java.lang.String", "substring", "(I)Ljava/lang/String;", false), new JNICallDescriptor("GetStaticMethodID", "java.lang.System", "getProperty", "(Ljava/lang/String;)Ljava/lang/String;", false), new JNICallDescriptor("GetStaticMethodID", "java.lang.System", "setProperty", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", false), new JNICallDescriptor("GetStaticMethodID", null, "main", "([Ljava/lang/String;)V", true)};
        JNI_STARTUP_COMPLETE = JNI_STARTUP_SEQUENCE.length;
        JNI_STARTUP_MISMATCH_COMPLETE = JNI_STARTUP_COMPLETE + 1;
    }

    record JNICallDescriptor(String jniFunction, String declaringClass, String name, String signature, boolean required) {
        public boolean matches(String otherJniFunction, String otherDeclaringClass, String otherName, String otherSignature) {
            return this.jniFunction.equals(otherJniFunction) && (this.declaringClass == null || this.declaringClass.equals(otherDeclaringClass)) && this.name.equals(otherName) && this.signature.equals(otherSignature);
        }
    }
}

