/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.word.WordBase;

public class ObjectScanner {
    private static final String INDENTATION_AFTER_NEWLINE = "    ";
    protected final BigBang bb;
    private final ReusableSet scannedObjects;
    private final CompletionExecutor executor;
    private final Deque<WorklistEntry> worklist;
    private final ObjectScanningObserver scanningObserver;
    static final String indent = "  ";

    public ObjectScanner(BigBang bb, CompletionExecutor executor, ReusableSet scannedObjects, ObjectScanningObserver scanningObserver) {
        this.bb = bb;
        this.scanningObserver = scanningObserver;
        if (executor != null) {
            this.executor = executor;
            this.worklist = null;
        } else {
            this.executor = null;
            this.worklist = new ConcurrentLinkedDeque<WorklistEntry>();
        }
        this.scannedObjects = scannedObjects;
    }

    public void scanBootImageHeapRoots() {
        this.scanBootImageHeapRoots(this.bb.getUniverse().getEmbeddedRoots());
    }

    public void scanBootImageHeapRoots(Map<Constant, Object> embeddedConstants) {
        this.scanBootImageHeapRoots(null, null, embeddedConstants);
    }

    public void scanBootImageHeapRoots(Comparator<AnalysisField> fieldComparator, Comparator<Object> embeddedRootComparator) {
        this.scanBootImageHeapRoots(fieldComparator, embeddedRootComparator, this.bb.getUniverse().getEmbeddedRoots());
    }

    public void scanBootImageHeapRoots(Comparator<AnalysisField> fieldComparator, Comparator<Object> embeddedRootComparator, Map<Constant, Object> embeddedRoots) {
        Collection<AnalysisField> fields = this.bb.getUniverse().getFields();
        if (fieldComparator != null) {
            ArrayList<AnalysisField> fieldsList = new ArrayList<AnalysisField>(fields);
            fieldsList.sort(fieldComparator);
            fields = fieldsList;
        }
        for (AnalysisField field : fields) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.isRead()) continue;
            this.execute(() -> this.scanStaticFieldRoot(field));
        }
        if (embeddedRootComparator != null) {
            embeddedRoots.entrySet().stream().sorted(Map.Entry.comparingByValue(embeddedRootComparator)).filter(entry -> entry.getKey() instanceof JavaConstant).forEach(entry -> this.execute(() -> this.scanEmbeddedRoot((JavaConstant)entry.getKey(), entry.getValue())));
        } else {
            embeddedRoots.entrySet().stream().filter(entry -> entry.getKey() instanceof JavaConstant).forEach(entry -> this.execute(() -> this.scanEmbeddedRoot((JavaConstant)entry.getKey(), entry.getValue())));
        }
        this.finish();
    }

    private void execute(Runnable runnable) {
        if (this.executor != null) {
            this.executor.execute((DebugContext debug) -> runnable.run());
        } else {
            runnable.run();
        }
    }

    protected void scanEmbeddedRoot(JavaConstant root, Object position) {
        ImageHeapConstant ihc;
        if (root instanceof ImageHeapConstant && (ihc = (ImageHeapConstant)root).getHostedObject() == null) {
            return;
        }
        EmbeddedRootScan reason = new EmbeddedRootScan(position, root);
        try {
            this.scanningObserver.forEmbeddedRoot(root, reason);
            this.scanConstant(root, reason);
        }
        catch (UnsupportedFeatureException | AnalysisError.TypeNotFoundError ex) {
            this.bb.getUnsupportedFeatures().addMessage(reason.toString(), reason.getMethod(), ex.getMessage(), null, ex);
        }
    }

    protected final void scanStaticFieldRoot(AnalysisField field) {
        if (!field.installableInLayer()) {
            return;
        }
        this.scanField(field, null, null);
    }

    protected void scanField(AnalysisField field, JavaConstant receiver, ScanReason prevReason) {
        FieldScan reason = new FieldScan(field, receiver, prevReason);
        try {
            ImageHeapConstant ihc;
            if (!this.bb.getUniverse().getHeapScanner().isValueAvailable(field)) {
                return;
            }
            assert (ObjectScanner.isUnwrapped(receiver)) : receiver;
            JavaConstant fieldValue = this.readFieldValue(field, receiver);
            if (fieldValue instanceof ImageHeapConstant && (ihc = (ImageHeapConstant)fieldValue).getHostedObject() == null) {
                return;
            }
            if (fieldValue == null) {
                StringBuilder backtrace = new StringBuilder();
                ObjectScanner.buildObjectBacktrace(this.bb, reason, backtrace);
                throw AnalysisError.shouldNotReachHere("Could not find field " + field.format("%H.%n") + (String)(receiver == null ? "" : " on " + ObjectScanner.constantType(this.bb, receiver).toJavaName()) + System.lineSeparator() + String.valueOf(backtrace));
            }
            if (fieldValue.getJavaKind() == JavaKind.Object && this.bb.getHostVM().isRelocatedPointer(fieldValue)) {
                this.scanningObserver.forRelocatedPointerFieldValue(receiver, field, fieldValue, reason);
            } else if (fieldValue.isNull()) {
                this.scanningObserver.forNullFieldValue(receiver, field, reason);
            } else if (fieldValue.getJavaKind() == JavaKind.Object) {
                this.scanningObserver.forNonNullFieldValue(receiver, field, fieldValue, reason);
                this.scanConstant(fieldValue, reason);
            } else if (fieldValue.getJavaKind().isPrimitive()) {
                this.scanningObserver.forPrimitiveFieldValue(receiver, field, fieldValue, reason);
            }
        }
        catch (UnsupportedFeatureException | AnalysisError.TypeNotFoundError ex) {
            ObjectScanner.unsupportedFeatureDuringFieldScan(this.bb, field, receiver, ex, reason);
        }
        catch (AnalysisError analysisError) {
            Throwable throwable = analysisError.getCause();
            if (throwable instanceof UnsupportedFeatureException) {
                UnsupportedFeatureException ex = (UnsupportedFeatureException)throwable;
                ObjectScanner.unsupportedFeatureDuringFieldScan(this.bb, field, receiver, ex, reason);
            }
            throw analysisError;
        }
    }

    protected JavaConstant readFieldValue(AnalysisField field, JavaConstant receiver) {
        AnalysisError.guarantee(!(receiver instanceof ImageHeapConstant));
        return this.bb.getUniverse().getHostedValuesProvider().readFieldValueWithReplacement(field, receiver);
    }

    private static JavaConstant maybeUnwrap(JavaConstant receiver) {
        ImageHeapConstant heapConstant;
        if (receiver instanceof ImageHeapConstant && (heapConstant = (ImageHeapConstant)receiver).getHostedObject() != null) {
            return heapConstant.getHostedObject();
        }
        return receiver;
    }

    private static boolean isUnwrapped(JavaConstant receiver) {
        if (receiver instanceof ImageHeapConstant) {
            ImageHeapConstant heapConstant = (ImageHeapConstant)receiver;
            return heapConstant.getHostedObject() == null;
        }
        return true;
    }

    protected final void scanArray(JavaConstant array, ScanReason prevReason) {
        block8: {
            ArrayScan reason;
            AnalysisType arrayType;
            block7: {
                assert (ObjectScanner.isUnwrapped(array)) : array;
                arrayType = this.bb.getMetaAccess().lookupJavaType(array);
                reason = new ArrayScan(arrayType, array, prevReason);
                if (!(array instanceof ImageHeapConstant)) break block7;
                if (arrayType.getComponentType().isPrimitive()) break block8;
                ImageHeapArray heapArray = (ImageHeapArray)array;
                for (int idx = 0; idx < heapArray.getLength(); ++idx) {
                    JavaConstant element = heapArray.readElementValue(idx);
                    if (element.isNull()) {
                        this.scanningObserver.forNullArrayElement(array, arrayType, idx, reason);
                        continue;
                    }
                    this.scanArrayElement(array, arrayType, reason, idx, element);
                }
                break block8;
            }
            Object[] arrayObject = (Object[])ObjectScanner.constantAsObject(this.bb, array);
            for (int idx = 0; idx < arrayObject.length; ++idx) {
                Object e = arrayObject[idx];
                if (e == null) {
                    this.scanningObserver.forNullArrayElement(array, arrayType, idx, reason);
                    continue;
                }
                try {
                    JavaConstant element = this.bb.getUniverse().replaceObjectWithConstant(e);
                    this.scanArrayElement(array, arrayType, reason, idx, element);
                    continue;
                }
                catch (UnsupportedFeatureException | AnalysisError.TypeNotFoundError ex) {
                    ObjectScanner.unsupportedFeatureDuringConstantScan(this.bb, this.bb.getUniverse().getHostedValuesProvider().forObject(e), ex, reason);
                }
            }
        }
    }

    private void scanArrayElement(JavaConstant array, AnalysisType arrayType, ScanReason reason, int idx, JavaConstant elementConstant) {
        AnalysisType elementType = this.bb.getMetaAccess().lookupJavaType(elementConstant);
        this.scanningObserver.forNonNullArrayElement(array, arrayType, elementConstant, elementType, idx, reason);
        this.scanConstant(elementConstant, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanConstant(JavaConstant value, ScanReason reason) {
        JavaConstant valueObj;
        if (value.isNull() || value.getJavaKind().isPrimitive() || this.bb.getMetaAccess().isInstanceOf(value, WordBase.class)) {
            return;
        }
        JavaConstant unwrappedValue = ObjectScanner.maybeUnwrap(value);
        Object object = valueObj = unwrappedValue instanceof ImageHeapConstant ? unwrappedValue : ObjectScanner.constantAsObject(this.bb, unwrappedValue);
        if (this.scannedObjects.putAndAcquire(valueObj) == null) {
            try {
                this.scanningObserver.forScannedConstant(unwrappedValue, reason);
            }
            finally {
                this.scannedObjects.release(valueObj);
                WorklistEntry worklistEntry = new WorklistEntry(unwrappedValue, reason);
                if (this.executor != null) {
                    this.executor.execute((DebugContext debug) -> this.doScan(worklistEntry));
                } else {
                    this.worklist.push(worklistEntry);
                }
            }
        }
    }

    public static void unsupportedFeatureDuringConstantScan(BigBang bb, JavaConstant constant, Throwable e, ScanReason reason) {
        ObjectScanner.unsupportedFeature(bb, String.valueOf(ObjectScanner.receiverHashCode(constant)), e.getMessage(), reason);
    }

    public static void unsupportedFeatureDuringFieldScan(BigBang bb, AnalysisField field, JavaConstant receiver, Throwable e, ScanReason reason) {
        ObjectScanner.unsupportedFeature(bb, (String)(receiver != null ? ObjectScanner.receiverHashCode(receiver) + "_" : "") + field.format("%H.%n"), e.getMessage(), reason);
    }

    public static void unsupportedFeatureDuringFieldFolding(BigBang bb, AnalysisField field, JavaConstant receiver, Throwable e, AnalysisMethod parsedMethod, int bci) {
        FieldConstantFold reason = new FieldConstantFold(field, parsedMethod, bci, receiver, new MethodParsing(parsedMethod));
        ObjectScanner.unsupportedFeature(bb, (String)(receiver != null ? ObjectScanner.receiverHashCode(receiver) + "_" : "") + field.format("%H.%n"), e.getMessage(), reason);
    }

    private static int receiverHashCode(JavaConstant receiver) {
        JavaConstant hostedObject;
        if (receiver instanceof ImageHeapConstant && (hostedObject = ((ImageHeapConstant)receiver).getHostedObject()) != null) {
            return hostedObject.hashCode();
        }
        return receiver.hashCode();
    }

    public static void unsupportedFeature(BigBang bb, String key, String message, ScanReason reason) {
        StringBuilder objectBacktrace = new StringBuilder();
        AnalysisMethod method = ObjectScanner.buildObjectBacktrace(bb, reason, objectBacktrace);
        bb.getUnsupportedFeatures().addMessage(key, method, message, objectBacktrace.toString());
    }

    public static AnalysisMethod buildObjectBacktrace(BigBang bb, ScanReason reason, StringBuilder objectBacktrace) {
        return ObjectScanner.buildObjectBacktrace(bb, reason, objectBacktrace, "Object was reached by");
    }

    public static AnalysisMethod buildObjectBacktrace(BigBang bb, ScanReason reason, StringBuilder objectBacktrace, String header) {
        ScanReason cur = reason;
        objectBacktrace.append(header);
        objectBacktrace.append(System.lineSeparator()).append(indent).append(cur.toString(bb));
        ScanReason rootReason = cur;
        cur = cur.getPrevious();
        while (cur != null) {
            ScanReason previous;
            objectBacktrace.append(System.lineSeparator()).append(indent).append(cur.toString(bb));
            rootReason = previous = cur.getPrevious();
            cur = previous;
        }
        if (rootReason instanceof EmbeddedRootScan) {
            return ((EmbeddedRootScan)rootReason).getMethod();
        }
        return null;
    }

    public static String asString(BigBang bb, JavaConstant constant) {
        return ObjectScanner.asString(bb, constant, true);
    }

    public static String asString(BigBang bb, JavaConstant constant, boolean appendToString) {
        if (constant == null || constant.isNull()) {
            return "null";
        }
        AnalysisType type = bb.getMetaAccess().lookupJavaType(constant);
        JavaConstant hosted = constant;
        if (constant instanceof ImageHeapConstant) {
            ImageHeapConstant heapConstant = (ImageHeapConstant)constant;
            JavaConstant hostedObject = heapConstant.getHostedObject();
            if (hostedObject == null) {
                return constant.getClass().getSimpleName() + "<" + type.toJavaName() + ">";
            }
            hosted = hostedObject;
        }
        if (hosted.getJavaKind().isPrimitive()) {
            return hosted.toValueString();
        }
        Object obj = ObjectScanner.constantAsObject(bb, hosted);
        String str = type.toJavaName() + "@" + Integer.toHexString(System.identityHashCode(obj));
        if (appendToString) {
            try {
                str = str + ": " + ObjectScanner.limit(obj.toString(), 80).replace(System.lineSeparator(), "");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return str;
    }

    public static String limit(String value, int length) {
        StringBuilder buf = new StringBuilder(value);
        if (buf.length() > length) {
            buf.setLength(length);
            buf.append("...");
        }
        return buf.toString();
    }

    private void doScan(WorklistEntry entry) {
        try {
            AnalysisType type = this.bb.getMetaAccess().lookupJavaType(entry.constant);
            type.registerAsReachable(entry.reason);
            if (type.isInstanceClass()) {
                for (ResolvedJavaField javaField : type.getInstanceFields(true)) {
                    AnalysisField field = (AnalysisField)javaField;
                    if (!field.isRead()) continue;
                    assert (!Modifier.isStatic(field.getModifiers())) : field;
                    this.scanField(field, entry.constant, entry.reason);
                }
            } else if (type.isArray() && type.getComponentType().getJavaKind() == JavaKind.Object) {
                this.scanArray(entry.constant, entry.reason);
            }
        }
        catch (UnsupportedFeatureException | AnalysisError.TypeNotFoundError ex) {
            ObjectScanner.unsupportedFeatureDuringConstantScan(this.bb, entry.constant, ex, entry.reason);
        }
    }

    protected void finish() {
        if (this.executor == null) {
            while (!this.worklist.isEmpty()) {
                int size = this.worklist.size();
                for (int i = 0; i < size; ++i) {
                    this.doScan(this.worklist.remove());
                }
            }
        }
    }

    public static AnalysisType constantType(BigBang bb, JavaConstant constant) {
        return bb.getMetaAccess().lookupJavaType(constant);
    }

    public static Object constantAsObject(BigBang bb, JavaConstant constant) {
        return bb.getSnippetReflectionProvider().asObject(Object.class, constant);
    }

    public static final class ReusableSet {
        private final IdentityHashMap<Object, AtomicInteger> store = new IdentityHashMap(65536);
        private int sequence = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object putAndAcquire(Object object) {
            IdentityHashMap<Object, AtomicInteger> map = this.store;
            AtomicInteger i = map.get(object);
            int seq = this.sequence;
            int inflightSequence = seq - 1;
            while (true) {
                if (i != null) {
                    int current = i.get();
                    if (current == seq) {
                        return object;
                    }
                    if (current != inflightSequence && i.compareAndSet(current, inflightSequence)) {
                        return null;
                    }
                    while (i.get() != seq) {
                        Thread.yield();
                    }
                    return object;
                }
                AtomicInteger newSequence = new AtomicInteger(inflightSequence);
                IdentityHashMap<Object, AtomicInteger> identityHashMap = map;
                synchronized (identityHashMap) {
                    i = map.putIfAbsent(object, newSequence);
                    if (i == null) {
                        return null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(Object o) {
            IdentityHashMap<Object, AtomicInteger> map = this.store;
            AtomicInteger i = map.get(o);
            if (i == null) {
                IdentityHashMap<Object, AtomicInteger> identityHashMap = map;
                synchronized (identityHashMap) {
                    i = map.get(o);
                }
            }
            i.set(this.sequence);
        }

        public void reset() {
            this.sequence += 2;
        }
    }

    public static class EmbeddedRootScan
    extends ScanReason {
        private final BytecodePosition position;
        private final AnalysisMethod method;
        private final Object reason;

        public EmbeddedRootScan(Object reason, JavaConstant root) {
            this(root, reason, EmbeddedRootScan.rootScanReason(reason));
        }

        private EmbeddedRootScan(JavaConstant root, Object reason, ScanReason previous) {
            super(previous, root);
            this.reason = reason;
            if (reason instanceof NodeSourcePosition) {
                NodeSourcePosition src = (NodeSourcePosition)reason;
                this.position = src;
                this.method = (AnalysisMethod)src.getMethod();
            } else if (reason instanceof AnalysisMethod) {
                AnalysisMethod met;
                this.method = met = (AnalysisMethod)reason;
                this.position = null;
            } else {
                this.method = null;
                this.position = null;
            }
        }

        public Object getReason() {
            return this.reason;
        }

        public AnalysisMethod getMethod() {
            return this.method;
        }

        @Override
        public String toString(BigBang bb) {
            return "scanning root " + ObjectScanner.asString(bb, this.constant) + " embedded in" + System.lineSeparator() + ObjectScanner.INDENTATION_AFTER_NEWLINE + this.asStackTraceElement();
        }

        public String toString() {
            return this.asStackTraceElement();
        }

        private static ScanReason rootScanReason(Object reason) {
            if (reason instanceof NodeSourcePosition) {
                NodeSourcePosition position = (NodeSourcePosition)reason;
                return new MethodParsing((AnalysisMethod)position.getMethod());
            }
            return new OtherReason(reason.toString());
        }

        private String asStackTraceElement() {
            if (this.position != null) {
                return String.valueOf(this.method.asStackTraceElement(this.position.getBCI()));
            }
            if (this.method != null) {
                return String.valueOf(this.method.asStackTraceElement(0));
            }
            return "<unknown>";
        }
    }

    public static abstract class ScanReason {
        final ScanReason previous;
        final JavaConstant constant;

        protected ScanReason(ScanReason previous, JavaConstant constant) {
            this.previous = previous;
            this.constant = constant;
        }

        public ScanReason getPrevious() {
            ImageHeapConstant heapConstant;
            Object object;
            if (this.previous == OtherReason.UNKNOWN && (object = this.constant) instanceof ImageHeapConstant && (object = (heapConstant = (ImageHeapConstant)object).getReachableReason()) instanceof ScanReason) {
                ScanReason parentReason = (ScanReason)object;
                return parentReason;
            }
            return this.previous;
        }

        public String toString(BigBang bb) {
            return this.toString();
        }
    }

    public static class FieldScan
    extends ScanReason {
        final AnalysisField field;

        private static ScanReason previous(AnalysisField field, JavaConstant receiver) {
            Object reason;
            if (receiver instanceof ImageHeapConstant) {
                ImageHeapConstant heapConstant = (ImageHeapConstant)receiver;
                AnalysisError.guarantee(heapConstant.isReachable());
                reason = heapConstant.getReachableReason();
            } else {
                reason = field.getReadBy();
            }
            if (reason instanceof ScanReason) {
                ScanReason scanReason = (ScanReason)reason;
                return scanReason;
            }
            if (reason instanceof BytecodePosition) {
                BytecodePosition position = (BytecodePosition)reason;
                ResolvedJavaMethod readingMethod = position.getMethod();
                return new MethodParsing((AnalysisMethod)readingMethod);
            }
            if (reason instanceof AnalysisMethod) {
                AnalysisMethod method = (AnalysisMethod)reason;
                return new MethodParsing(method);
            }
            if (reason != null) {
                return new OtherReason("registered as read because: " + String.valueOf(reason));
            }
            return null;
        }

        public FieldScan(AnalysisField field) {
            this(field, null, FieldScan.previous(field, null));
        }

        public FieldScan(AnalysisField field, JavaConstant receiver) {
            this(field, receiver, FieldScan.previous(field, receiver));
        }

        public FieldScan(AnalysisField field, JavaConstant receiver, ScanReason previous) {
            super(previous, receiver);
            this.field = field;
        }

        public AnalysisField getField() {
            return this.field;
        }

        public String location() {
            Object readBy = this.field.getReadBy();
            if (readBy instanceof BytecodePosition) {
                BytecodePosition position = (BytecodePosition)readBy;
                return position.getMethod().asStackTraceElement(position.getBCI()).toString();
            }
            if (readBy instanceof AnalysisMethod) {
                return ((AnalysisMethod)readBy).asStackTraceElement(0).toString();
            }
            return "<unknown-location>";
        }

        @Override
        public String toString(BigBang bb) {
            if (this.field.isStatic()) {
                return "reading static field " + this.field.format("%H.%n") + System.lineSeparator() + "    at " + this.location();
            }
            return "reading field " + this.field.format("%H.%n") + " of constant " + System.lineSeparator() + ObjectScanner.INDENTATION_AFTER_NEWLINE + ObjectScanner.asString(bb, this.constant);
        }

        public String toString() {
            return this.field.format("%H.%n");
        }
    }

    public static class ArrayScan
    extends ScanReason {
        final AnalysisType arrayType;
        final int idx;

        public ArrayScan(AnalysisType arrayType, JavaConstant array, ScanReason previous) {
            this(arrayType, array, previous, -1);
        }

        public ArrayScan(AnalysisType arrayType, JavaConstant array, ScanReason previous, int idx) {
            super(previous, array);
            this.arrayType = arrayType;
            this.idx = idx;
        }

        @Override
        public String toString(BigBang bb) {
            return "indexing into array " + ObjectScanner.asString(bb, this.constant) + (String)(this.idx != -1 ? " at index " + this.idx : "");
        }

        public String toString() {
            return this.arrayType.toJavaName(true);
        }
    }

    static class WorklistEntry {
        private final JavaConstant constant;
        private final ScanReason reason;

        WorklistEntry(JavaConstant constant, ScanReason reason) {
            this.constant = constant;
            this.reason = reason;
        }

        public ScanReason getReason() {
            return this.reason;
        }
    }

    public static class FieldConstantFold
    extends ScanReason {
        final AnalysisField field;
        private final AnalysisMethod parsedMethod;
        private final int bci;

        public FieldConstantFold(AnalysisField field, AnalysisMethod parsedMethod, int bci, JavaConstant receiver, ScanReason previous) {
            super(previous, receiver);
            this.field = field;
            this.parsedMethod = parsedMethod;
            this.bci = bci;
        }

        @Override
        public String toString(BigBang bb) {
            StackTraceElement location = this.parsedMethod.asStackTraceElement(this.bci);
            if (this.field.isStatic()) {
                return "trying to constant fold static field " + this.field.format("%H.%n") + System.lineSeparator() + "    at " + String.valueOf(location);
            }
            return "trying to constant fold field " + this.field.format("%H.%n") + " of constant " + System.lineSeparator() + ObjectScanner.INDENTATION_AFTER_NEWLINE + ObjectScanner.asString(bb, this.constant) + System.lineSeparator() + "    at " + String.valueOf(location);
        }

        public String toString() {
            return this.field.format("%H.%n");
        }
    }

    public static class MethodParsing
    extends ScanReason {
        final AnalysisMethod method;

        public MethodParsing(AnalysisMethod method) {
            this(method, null);
        }

        public MethodParsing(AnalysisMethod method, ScanReason previous) {
            super(previous, null);
            this.method = method;
        }

        public AnalysisMethod getMethod() {
            return this.method;
        }

        public String toString() {
            Object str = String.format("parsing method %s reachable via the parsing context", this.method.asStackTraceElement(0));
            str = (String)str + ReportUtils.parsingContext(this.method, ObjectScanner.INDENTATION_AFTER_NEWLINE);
            return str;
        }
    }

    public static class OtherReason
    extends ScanReason {
        public static final ScanReason LATE_SCAN = new OtherReason("late scan, after sealing heap");
        public static final ScanReason UNKNOWN = new OtherReason("manually created constant");
        public static final ScanReason RESCAN = new OtherReason("manually triggered rescan");
        public static final ScanReason HUB = new OtherReason("scanning a class constant");
        public static final ScanReason PERSISTED = new OtherReason("persisted");
        final String reason;

        public OtherReason(String reason) {
            super(null, null);
            this.reason = reason;
        }

        public String toString() {
            return this.reason;
        }
    }
}

