/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public class FormalParamTypeFlow
extends TypeFlow<BytecodePosition> {
    protected final int position;

    public FormalParamTypeFlow(BytecodePosition sourcePosition, AnalysisType declaredType, int position) {
        super(sourcePosition, FormalParamTypeFlow.filterUncheckedInterface(declaredType));
        this.position = position;
    }

    protected FormalParamTypeFlow(FormalParamTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
        this.position = original.position;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new FormalParamTypeFlow(this, methodFlows);
    }

    @Override
    protected TypeState processInputState(PointsToAnalysis bb, TypeState newState) {
        return this.declaredTypeFilter(bb, newState);
    }

    public int position() {
        return this.position;
    }

    @Override
    public String format(boolean withState, boolean withSource) {
        return "Parameter " + this.position + " of " + this.method().format("%H.%n(%p)") + (String)(withSource ? " at " + this.formatSource() : "") + (String)(withState ? " with state <" + this.getStateDescription() + ">" : "");
    }
}

